# 画面設計書 34-岗位管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「岗位（役職）管理一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システムに登録されている岗位（役職・ポスト）情報を一覧表示し、検索・追加・編集・削除・エクスポートなどの管理操作を行うための画面である。岗位はユーザーに割り当てられる職位を表し、組織における役職体系の管理を実現する。

**業務上の目的・背景**：企業や組織では、「部長」「課長」「主任」などの役職体系が存在し、ユーザーの職責や権限に影響を与える。岗位マスタを適切に管理することで、組織の役職体系をシステム上で一元管理し、ユーザー登録時に正しい岗位を割り当てることができる。また、Excelエクスポート機能により、岗位一覧の帳票出力や外部システムとの連携が可能となる。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」>「岗位管理」を選択することで本画面に遷移する。

**主要な操作・処理内容**：
1. 岗位一覧の表示（ページング、ソート対応）
2. 条件検索（岗位編碼、岗位名称、状態）
3. 新規岗位の登録（モーダル画面呼び出し）
4. 既存岗位の編集（モーダル画面呼び出し）
5. 岗位の削除（単一/複数選択）
6. 岗位データのExcelエクスポート

**画面遷移**：システム首頁から本画面に遷移する。「新規」ボタンで岗位新規登録画面、「編集」ボタンで岗位編集画面（モーダル）が開く。

**権限による表示制御**：
- `system:post:view`：画面表示権限
- `system:post:add`：新規ボタン表示
- `system:post:edit`：編集ボタン表示
- `system:post:remove`：削除ボタン表示
- `system:post:export`：エクスポートボタン表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 役職管理 | 主機能 | 役職一覧の検索、表示処理 |
| 24 | ファイルダウンロード | 補助機能 | 役職データのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

- 画面表示：`GET /system/post`
- 一覧取得：`POST /system/post/list`
- 削除処理：`POST /system/post/remove`
- エクスポート：`POST /system/post/export`

## 入出力項目

### 検索条件

| 項目名 | 項目ID | 型 | 必須 | 入力形式 | 備考 |
|--------|--------|-----|------|----------|------|
| 岗位編碼 | postCode | String | - | テキスト | 部分一致検索 |
| 岗位名称 | postName | String | - | テキスト | 部分一致検索 |
| 岗位状態 | status | String | - | セレクト | 0:正常、1:停用、空:すべて |

## 表示項目

### 一覧表示項目

| 項目名 | フィールド | ソート | 備考 |
|--------|-----------|--------|------|
| チェックボックス | - | - | 複数選択用 |
| 岗位編号 | postId | - | 主キー |
| 岗位編碼 | postCode | ○ | 岗位識別コード |
| 岗位名称 | postName | ○ | 岗位の名称 |
| 表示順序 | postSort | ○ | ソート順（デフォルトソート列） |
| 状態 | status | - | sys_normal_disable辞書で表示変換 |
| 作成日時 | createTime | ○ | レコード作成日時 |
| 操作 | - | - | 編集・削除ボタン |

### ツールバーボタン

| ボタン名 | 表示条件 | 機能 |
|---------|----------|------|
| 新規 | system:post:add | 新規登録画面を開く |
| 修正 | system:post:edit | 選択行の編集画面を開く（単一選択時のみ有効） |
| 削除 | system:post:remove | 選択行を削除（複数選択可） |
| 導出 | system:post:export | Excel形式でエクスポート |

## イベント仕様

### 1-検索ボタン押下

検索条件を入力し検索ボタンをクリックすると、条件に合致する岗位データを取得して一覧を更新する。

**処理フロー**：
1. $.table.search()を呼び出し
2. フォームの検索条件を取得
3. POST /system/post/listへリクエスト
4. レスポンスでテーブルを更新

### 2-リセットボタン押下

検索条件をクリアし、全件表示に戻す。

**処理フロー**：
1. $.form.reset()を呼び出し
2. 検索条件をクリア
3. 一覧を再取得

### 3-新規ボタン押下

新規岗位登録用のモーダル画面を開く。

**処理フロー**：
1. $.operate.add()を呼び出し
2. GET /system/post/addで新規登録画面取得
3. モーダルダイアログで表示

### 4-編集ボタン押下（行内）

選択した岗位の編集画面をモーダルで開く。

**処理フロー**：
1. $.operate.edit(postId)を呼び出し
2. GET /system/post/edit/{postId}で編集画面取得
3. モーダルダイアログで表示

### 5-削除ボタン押下（行内）

選択した岗位を削除する。

**処理フロー**：
1. $.operate.remove(postId)を呼び出し
2. 確認ダイアログ表示
3. POST /system/post/removeへリクエスト
4. 成功時：一覧を更新

### 6-一括削除ボタン押下

チェックボックスで選択した複数の岗位を一括削除する。

**処理フロー**：
1. $.operate.removeAll()を呼び出し
2. 選択されたpostIdを収集
3. 確認ダイアログ表示
4. POST /system/post/removeへリクエスト
5. 成功時：一覧を更新

### 7-エクスポートボタン押下

検索条件に合致するデータをExcelファイルとしてダウンロードする。

**処理フロー**：
1. $.table.exportExcel()を呼び出し
2. 検索条件をパラメータとしてPOST /system/post/exportへリクエスト
3. Excelファイルをダウンロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧取得 | sys_post | SELECT | 岗位一覧を取得 |
| 削除 | sys_post | DELETE | 岗位レコードを削除 |

### テーブル別更新項目詳細

#### sys_post（削除）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| DELETE | - | post_id IN (選択されたID) | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | 確認 | 確認是否刪除選中的数据？ | 削除ボタン押下時 |
| MSG002 | エラー | xxx岗位已分配，不能刪除 | ユーザーに割当済みの岗位を削除しようとした場合 |
| MSG003 | 成功 | 操作成功 | 削除成功時 |
| MSG004 | 成功 | 導出成功 | エクスポート成功時 |

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| 権限不足 | system:post:view権限なし | 画面アクセス拒否 |
| 岗位使用中 | 削除対象がユーザーに割当済み | エラーメッセージ表示、削除中止 |
| 通信エラー | Ajaxリクエスト失敗 | エラーメッセージ表示 |

## 備考

- 一覧のデフォルトソートはpostSort（表示順序）の昇順
- 状態列はsys_normal_disable辞書を使用して「正常/停用」を表示
- 編集・削除ボタンは権限に応じてdisabled状態で表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | 岗位エンティティ、@Excelアノテーションでエクスポート設定 |

**読解のコツ**: @Excelアノテーションがエクスポート時の列定義となる。statusのreadConverterExpでDB値から表示値への変換が定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | post.html | `ruoyi-admin/src/main/resources/templates/system/post/post.html` | 画面構成、Bootstrap Table設定 |

**主要処理フロー**:
1. **行10-31**: 検索フォーム（postCode, postName, status）
2. **行34-47**: ツールバーボタン（新規、修正、削除、導出）
3. **行61-117**: Bootstrap Table初期化とカラム定義

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | 各エンドポイントの実装 |

**主要処理フロー**:
- **行44-52**: list()メソッド - ページング対応の一覧取得
- **行54-63**: export()メソッド - Excelエクスポート
- **行65-72**: remove()メソッド - 削除処理

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ISysPostService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysPostService.java` | サービスインターフェース |
| 4-2 | SysPostServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysPostServiceImpl.java` | 削除時のユーザー割当チェック等 |

### プログラム呼び出し階層図

```
post.html（Bootstrap Table初期化）
    │
    ├─ $.table.init() [行116]
    │      └─ POST /system/post/list
    │             │
    │             └─ SysPostController.list() [行44-52]
    │                    ├─ startPage() - ページング設定
    │                    ├─ postService.selectPostList()
    │                    └─ getDataTable() - レスポンス生成
    │
    ├─ $.operate.removeAll()
    │      └─ POST /system/post/remove
    │             │
    │             └─ SysPostController.remove() [行65-72]
    │                    └─ postService.deletePostByIds()
    │
    └─ $.table.exportExcel()
           └─ POST /system/post/export
                  │
                  └─ SysPostController.export() [行54-63]
                         ├─ postService.selectPostList()
                         └─ ExcelUtil.exportExcel()
```

### データフロー図

```
[入力]                   [処理]                              [出力]

検索条件 ───────────▶ SysPostController.list()
  - postCode                   │
  - postName                   ├─▶ startPage()
  - status                     ├─▶ selectPostList()
                               │         └─▶ sys_post SELECT
                               └─▶ getDataTable() ──────▶ TableDataInfo
                                                              │
                                                              ▼
                                                        Bootstrap Table描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| post.html | `ruoyi-admin/src/main/resources/templates/system/post/post.html` | テンプレート | 一覧画面 |
| add.html | `ruoyi-admin/src/main/resources/templates/system/post/add.html` | テンプレート | 新規登録画面 |
| edit.html | `ruoyi-admin/src/main/resources/templates/system/post/edit.html` | テンプレート | 編集画面 |
| SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | コントローラー | リクエスト処理 |
| ISysPostService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysPostService.java` | インターフェース | サービス定義 |
| SysPostMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` | 設定 | SQLマッピング |
| SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | エンティティ | データモデル |
