# 画面設計書 35-岗位新規登録

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「岗位新規登録」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、新規の岗位（役職・ポスト）を登録するための入力フォーム画面である。システム管理者は本画面を通じて、組織の役職体系を構築・拡張することができる。

**業務上の目的・背景**：企業の成長や組織改編に伴い、新しい役職が必要となる場面がある。「プロジェクトマネージャー」「テクニカルリード」など、新規役職の追加を迅速に行うことで、組織構造の変化に柔軟に対応できる。岗位は一意の編碼と名称を持ち、ユーザー登録時に選択される。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」>「岗位管理」を選択し、岗位管理一覧画面に遷移後、ツールバーの「新規」ボタンをクリックすることで本画面がモーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. 岗位名称の入力（必須、50文字以内、一意性チェック）
2. 岗位編碼の入力（必須、64文字以内、一意性チェック）
3. 表示順序の入力（必須、数値のみ）
4. 岗位状態の選択（正常/停用）
5. 備考の入力（任意）
6. 確定ボタンで登録処理を実行

**画面遷移**：岗位管理一覧画面から本画面に遷移する。登録完了後は岗位管理一覧画面に戻り、一覧が更新される。

**権限による表示制御**：`system:post:add`権限を持つユーザーのみが本画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 役職管理 | 主機能 | 新規役職情報入力と登録保存処理 |

## 画面種別

登録（モーダルダイアログ形式）

## URL/ルーティング

- 画面表示：`GET /system/post/add`
- 登録処理：`POST /system/post/add`
- 岗位名一意性チェック：`POST /system/post/checkPostNameUnique`
- 岗位編碼一意性チェック：`POST /system/post/checkPostCodeUnique`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|-----|------|--------|----------|------|
| 岗位名称 | postName | String | ○ | 50 | テキスト | 一意性チェックあり |
| 岗位編碼 | postCode | String | ○ | 64 | テキスト | 一意性チェックあり |
| 表示順序 | postSort | String | ○ | - | 数値 | 整数のみ |
| 岗位状態 | status | String | - | 1 | ラジオ | 0:正常、1:停用 |
| 備考 | remark | String | - | - | テキストエリア | 自由記述 |

## 表示項目

| 項目名 | 表示形式 | 初期値 | 備考 |
|--------|----------|--------|------|
| 岗位名称 | テキストボックス | 空 | 必須入力 |
| 岗位編碼 | テキストボックス | 空 | 必須入力 |
| 表示順序 | テキストボックス | 空 | 必須入力、数値のみ |
| 岗位状態 | ラジオボタン | 正常 | sys_normal_disable辞書から取得 |
| 備考 | テキストエリア | 空 | 任意 |

## イベント仕様

### 1-確定ボタン押下

入力内容のバリデーションを行い、問題がなければサーバーへPOSTリクエストを送信して岗位を登録する。

**バリデーション処理**：
1. 必須項目チェック（岗位名称、岗位編碼、表示順序）
2. 岗位名称の一意性チェック（Ajax、`/system/post/checkPostNameUnique`）
3. 岗位編碼の一意性チェック（Ajax、`/system/post/checkPostCodeUnique`）
4. 表示順序の数値チェック

**登録処理**：
1. バリデーション成功後、`/system/post/add`へフォームデータをPOST
2. サーバー側で再度一意性チェック
3. sys_postテーブルにINSERT
4. 成功時：親画面を更新してモーダルを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確定ボタン押下 | sys_post | INSERT | 新規岗位レコードの登録 |

### テーブル別更新項目詳細

#### sys_post

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | post_id | 自動採番（useGeneratedKeys） | 主キー |
| INSERT | post_code | 画面入力値（postCode） | 岗位編碼 |
| INSERT | post_name | 画面入力値（postName） | 岗位名称 |
| INSERT | post_sort | 画面入力値（postSort） | 表示順序 |
| INSERT | status | 画面入力値（status） | 岗位状態 |
| INSERT | remark | 画面入力値（remark） | 備考 |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | エラー | 岗位編碼已經存在 | 岗位編碼重複時 |
| MSG002 | エラー | 岗位名称已經存在 | 岗位名称重複時 |
| MSG003 | エラー | 新増岗位'xxx'失敗，岗位名称已存在 | サーバー側名称重複時 |
| MSG004 | エラー | 新増岗位'xxx'失敗，岗位編碼已存在 | サーバー側編碼重複時 |
| MSG005 | 成功 | 操作成功 | 登録成功時 |

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| 権限不足 | system:post:add権限なし | 画面アクセス拒否 |
| 一意性違反 | 岗位名称または編碼が既存 | エラーメッセージ表示、処理中止 |
| 通信エラー | Ajaxリクエスト失敗 | エラーメッセージ表示 |

## 備考

- 岗位編碼と岗位名称は両方とも一意である必要がある
- 状態の選択肢はsys_normal_disable辞書から動的に取得される
- 登録時のIDはMySQLのAUTO_INCREMENTを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | 岗位エンティティ、バリデーションアノテーション |

**読解のコツ**: @NotBlank, @Sizeアノテーションで必須チェックと長さ制限を確認。postCodeは64文字、postNameは50文字が上限。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | add.html | `ruoyi-admin/src/main/resources/templates/system/post/add.html` | 画面構成、入力項目、JavaScript処理 |

**主要処理フロー**:
1. **行8-42**: フォーム定義（form-post-add）、各入力項目
2. **行48-88**: jQuery Validateによるバリデーション設定（postName, postCode両方にremote）
3. **行90-94**: submitHandler関数で$.operate.saveを呼び出し

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | add, addSave, checkPostNameUnique, checkPostCodeUniqueメソッド |

**主要処理フロー**:
- **行77-82**: add()メソッド - 画面表示
- **行87-103**: addSave()メソッド - 登録処理、名称・編碼一意性チェック
- **行140-145**: checkPostNameUnique()メソッド
- **行150-155**: checkPostCodeUnique()メソッド

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ISysPostService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysPostService.java` | サービスインターフェース |

### プログラム呼び出し階層図

```
add.html（フォーム送信）
    │
    ├─ submitHandler() [JavaScript]
    │      └─ $.operate.save()
    │             └─ POST /system/post/add
    │
    └─ SysPostController.addSave() [行87-103]
           │
           ├─ postService.checkPostNameUnique() [行93]
           ├─ postService.checkPostCodeUnique() [行97]
           │
           └─ postService.insertPost() [行102]
                  └─ postMapper.insertPost() [Mapper]
```

### データフロー図

```
[入力]                   [処理]                              [出力]

フォーム入力データ ──▶ SysPostController.addSave()
  - postName                  │
  - postCode                  ├─▶ checkPostNameUnique()
  - postSort                  │         └─▶ sys_post SELECT
  - status                    │
  - remark                    ├─▶ checkPostCodeUnique()
                              │         └─▶ sys_post SELECT
                              │
                              └─▶ insertPost()
                                      └─▶ sys_post INSERT ──▶ AjaxResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| add.html | `ruoyi-admin/src/main/resources/templates/system/post/add.html` | テンプレート | 画面表示 |
| SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | コントローラー | リクエスト処理 |
| ISysPostService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysPostService.java` | インターフェース | サービス定義 |
| SysPostMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` | 設定 | SQLマッピング |
| SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | エンティティ | データモデル |
