# 画面設計書 36-岗位編集

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「岗位編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、既存の岗位（役職・ポスト）情報を変更するための編集フォーム画面である。岗位の名称、編碼、表示順序、状態などを更新することができる。

**業務上の目的・背景**：組織運営において、役職名の変更（例：「係長」から「チームリーダー」への変更）や役職コードの統一、表示順の調整などが発生する。本画面はこれらの変更を迅速かつ正確に行うために必要である。ただし、既存ユーザーに割り当てられている岗位の変更は、影響範囲を考慮して慎重に行う必要がある。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」>「岗位管理」を選択し、岗位管理一覧画面に遷移後、編集対象の岗位行の「編集」ボタンをクリックすることで本画面がモーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. 既存の岗位情報の表示・確認
2. 岗位名称の変更（必須、50文字以内、一意性チェック）
3. 岗位編碼の変更（必須、64文字以内、一意性チェック）
4. 表示順序の変更（必須、数値のみ）
5. 岗位状態の変更（正常/停用）
6. 備考の変更（任意）
7. 確定ボタンで更新処理を実行

**画面遷移**：岗位管理一覧画面から本画面に遷移する。更新完了後は岗位管理一覧画面に戻り、一覧が更新される。

**権限による表示制御**：`system:post:edit`権限を持つユーザーのみが本画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 役職管理 | 主機能 | 役職情報の更新保存処理 |

## 画面種別

編集（モーダルダイアログ形式）

## URL/ルーティング

- 画面表示：`GET /system/post/edit/{postId}`
- 更新処理：`POST /system/post/edit`
- 岗位名一意性チェック：`POST /system/post/checkPostNameUnique`
- 岗位編碼一意性チェック：`POST /system/post/checkPostCodeUnique`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|-----|------|--------|----------|------|
| 岗位ID | postId | Long | ○ | - | hidden | 更新対象の識別子 |
| 岗位名称 | postName | String | ○ | 50 | テキスト | 一意性チェック（自身を除く） |
| 岗位編碼 | postCode | String | ○ | 64 | テキスト | 一意性チェック（自身を除く） |
| 表示順序 | postSort | String | ○ | - | 数値 | 整数のみ |
| 岗位状態 | status | String | - | 1 | ラジオ | 0:正常、1:停用 |
| 備考 | remark | String | - | - | テキストエリア | 自由記述 |

## 表示項目

| 項目名 | 表示形式 | 初期値 | 備考 |
|--------|----------|--------|------|
| 岗位名称 | テキストボックス | 現在の岗位名称 | 必須入力 |
| 岗位編碼 | テキストボックス | 現在の岗位編碼 | 必須入力 |
| 表示順序 | テキストボックス | 現在の表示順序 | 必須入力、数値のみ |
| 岗位状態 | ラジオボタン | 現在の状態 | sys_normal_disable辞書から取得 |
| 備考 | テキストエリア | 現在の備考 | 任意 |

## イベント仕様

### 1-確定ボタン押下

入力内容のバリデーションを行い、問題がなければサーバーへPOSTリクエストを送信して岗位情報を更新する。

**バリデーション処理**：
1. 必須項目チェック（岗位名称、岗位編碼、表示順序）
2. 岗位名称の一意性チェック（Ajax、postIdを含めて自身を除外）
3. 岗位編碼の一意性チェック（Ajax、postIdを含めて自身を除外）
4. 表示順序の数値チェック

**更新処理**：
1. バリデーション成功後、`/system/post/edit`へフォームデータをPOST
2. サーバー側で再度一意性チェック（自身を除外）
3. sys_postテーブルをUPDATE
4. 成功時：親画面を更新してモーダルを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確定ボタン押下 | sys_post | UPDATE | 岗位レコードの更新 |

### テーブル別更新項目詳細

#### sys_post

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | post_code | 画面入力値（postCode） | 岗位編碼 |
| UPDATE | post_name | 画面入力値（postName） | 岗位名称 |
| UPDATE | post_sort | 画面入力値（postSort） | 表示順序 |
| UPDATE | status | 画面入力値（status） | 岗位状態 |
| UPDATE | remark | 画面入力値（remark） | 備考 |
| UPDATE | update_by | ログインユーザー名 | 更新者 |
| UPDATE | update_time | sysdate() | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | エラー | 岗位編碼已經存在 | 岗位編碼重複時 |
| MSG002 | エラー | 岗位名称已經存在 | 岗位名称重複時 |
| MSG003 | エラー | 修改岗位'xxx'失敗，岗位名称已存在 | サーバー側名称重複時 |
| MSG004 | エラー | 修改岗位'xxx'失敗，岗位編碼已存在 | サーバー側編碼重複時 |
| MSG005 | 成功 | 操作成功 | 更新成功時 |

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| 権限不足 | system:post:edit権限なし | 画面アクセス拒否 |
| 一意性違反 | 岗位名称または編碼が既存（自身を除く） | エラーメッセージ表示、処理中止 |
| 通信エラー | Ajaxリクエスト失敗 | エラーメッセージ表示 |

## 備考

- 一意性チェック時はpostIdを含めてリクエストし、自身のレコードは除外して判定
- th:fieldでフォームに既存値をバインド
- 状態の選択肢はsys_normal_disable辞書から動的に取得される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | 岗位エンティティ、バリデーションアノテーション |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | edit.html | `ruoyi-admin/src/main/resources/templates/system/post/edit.html` | 画面構成、th:fieldによる既存値バインディング |

**主要処理フロー**:
1. **行9**: postIdをhiddenフィールドで保持
2. **行13, 19, 25**: th:fieldで既存値をバインド
3. **行49-95**: jQuery ValidateでpostIdを含めた一意性チェック
4. **行97-101**: submitHandler関数で$.operate.saveを呼び出し

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | edit, editSaveメソッド |

**主要処理フロー**:
- **行108-114**: edit()メソッド - 画面表示、既存データ取得
- **行119-135**: editSave()メソッド - 更新処理、一意性チェック

### プログラム呼び出し階層図

```
edit.html（フォーム送信）
    │
    ├─ submitHandler() [JavaScript]
    │      └─ $.operate.save()
    │             └─ POST /system/post/edit
    │
    └─ SysPostController.editSave() [行119-135]
           │
           ├─ postService.checkPostNameUnique() [行125]
           ├─ postService.checkPostCodeUnique() [行129]
           │
           └─ postService.updatePost() [行134]
                  └─ postMapper.updatePost() [Mapper]
```

### データフロー図

```
[入力]                   [処理]                              [出力]

編集フォームデータ ──▶ SysPostController.editSave()
  - postId                    │
  - postName                  ├─▶ checkPostNameUnique(postId含む)
  - postCode                  │
  - postSort                  ├─▶ checkPostCodeUnique(postId含む)
  - status                    │
  - remark                    └─▶ updatePost()
                                      └─▶ sys_post UPDATE ──▶ AjaxResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| edit.html | `ruoyi-admin/src/main/resources/templates/system/post/edit.html` | テンプレート | 画面表示 |
| SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | コントローラー | リクエスト処理 |
| ISysPostService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysPostService.java` | インターフェース | サービス定義 |
| SysPostMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` | 設定 | SQLマッピング |
| SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | エンティティ | データモデル |
