# 画面設計書 37-字典類型管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「字典類型管理一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システムで使用される字典（辞書）類型を一覧表示し、検索・追加・編集・削除・エクスポートなどの管理操作を行うための画面である。字典類型は、状態値やカテゴリ値など、システム全体で共通利用される選択肢のマスタ定義を管理する。

**業務上の目的・背景**：業務システムでは「有効/無効」「男性/女性」「処理中/完了/エラー」など、多くの選択肢が使用される。これらをハードコーディングせず、字典として外部管理することで、メンテナンス性と拡張性が向上する。本画面は字典類型（辞書のカテゴリ）を管理し、各類型配下に字典データ（具体的な選択肢）を登録する構造となっている。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」>「字典管理」を選択することで本画面に遷移する。

**主要な操作・処理内容**：
1. 字典類型一覧の表示（ページング、ソート対応）
2. 条件検索（字典名称、字典類型、状態、作成日時範囲）
3. 新規字典類型の登録（モーダル画面呼び出し）
4. 既存字典類型の編集（モーダル画面呼び出し）
5. 字典類型の削除（単一/複数選択）
6. 字典類型データのExcelエクスポート
7. 字典キャッシュの手動リフレッシュ
8. 字典データ一覧への遷移（字典類型列のリンク）

**画面遷移**：システム首頁から本画面に遷移する。「新規」ボタンで字典類型新規登録画面、「編集」ボタンで字典類型編集画面（モーダル）が開く。字典類型列または「列表」ボタンをクリックで字典データ管理一覧画面へ遷移する。

**権限による表示制御**：
- `system:dict:view`：画面表示権限
- `system:dict:add`：新規ボタン表示
- `system:dict:edit`：編集ボタン表示
- `system:dict:remove`：削除・キャッシュ更新ボタン表示
- `system:dict:export`：エクスポートボタン表示
- `system:dict:list`：列表ボタン表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 辞書タイプ管理 | 主機能 | 辞書タイプ一覧の検索、表示処理 |
| 24 | ファイルダウンロード | 補助機能 | 辞書タイプデータのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

- 画面表示：`GET /system/dict`
- 一覧取得：`POST /system/dict/list`
- 削除処理：`POST /system/dict/remove`
- エクスポート：`POST /system/dict/export`
- キャッシュリフレッシュ：`GET /system/dict/refreshCache`
- 字典データ画面遷移：`GET /system/dict/detail/{dictId}`

## 入出力項目

### 検索条件

| 項目名 | 項目ID | 型 | 必須 | 入力形式 | 備考 |
|--------|--------|-----|------|----------|------|
| 字典名称 | dictName | String | - | テキスト | 部分一致検索 |
| 字典類型 | dictType | String | - | テキスト | 部分一致検索 |
| 字典状態 | status | String | - | セレクト | 0:正常、1:停用、空:すべて |
| 作成日時（開始） | params[beginTime] | Date | - | 日付 | 範囲検索開始 |
| 作成日時（終了） | params[endTime] | Date | - | 日付 | 範囲検索終了 |

## 表示項目

### 一覧表示項目

| 項目名 | フィールド | ソート | 備考 |
|--------|-----------|--------|------|
| チェックボックス | - | - | 複数選択用 |
| 字典主鍵 | dictId | - | 主キー |
| 字典名称 | dictName | ○ | 辞書の名称 |
| 字典類型 | dictType | ○ | 辞書のタイプコード（リンク付き） |
| 状態 | status | - | sys_normal_disable辞書で表示変換 |
| 備考 | remark | - | tooltip表示 |
| 作成日時 | createTime | ○ | レコード作成日時 |
| 操作 | - | - | 編集・列表・削除ボタン |

### ツールバーボタン

| ボタン名 | 表示条件 | 機能 |
|---------|----------|------|
| 新規 | system:dict:add | 新規登録画面を開く |
| 修正 | system:dict:edit | 選択行の編集画面を開く |
| 削除 | system:dict:remove | 選択行を削除 |
| 導出 | system:dict:export | Excel形式でエクスポート |
| 刷新缓存 | system:dict:remove | 字典キャッシュをリフレッシュ |

## イベント仕様

### 1-検索ボタン押下

検索条件を入力し検索ボタンをクリックすると、条件に合致する字典類型データを取得して一覧を更新する。

### 2-リセットボタン押下

検索条件をクリアし、全件表示に戻す。

### 3-新規ボタン押下

新規字典類型登録用のモーダル画面を開く。

### 4-編集ボタン押下（行内）

選択した字典類型の編集画面をモーダルで開く。

### 5-列表ボタン押下（行内）

選択した字典類型の字典データ管理一覧画面に遷移する。

**処理フロー**：
1. detail(dictId)関数を呼び出し
2. `/system/dict/detail/{dictId}`を新しいタブで開く

### 6-削除ボタン押下

選択した字典類型を削除する。削除時は関連する字典データも確認される。

### 7-刷新缓存ボタン押下

字典のキャッシュデータをクリアし、DBから再読み込みする。

**処理フロー**：
1. $.operate.get()でGET /system/dict/refreshCacheへリクエスト
2. サービス層でキャッシュをクリア・再構築
3. 成功メッセージを表示

### 8-字典類型列リンククリック

字典類型のリンクをクリックすると、該当字典の字典データ管理一覧画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧取得 | sys_dict_type | SELECT | 字典類型一覧を取得 |
| 削除 | sys_dict_type | DELETE | 字典類型レコードを削除 |
| 削除 | sys_dict_data | DELETE | 関連する字典データも削除 |
| キャッシュ更新 | - | - | Redisキャッシュをクリア・再構築 |

### テーブル別更新項目詳細

#### sys_dict_type（削除）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| DELETE | - | dict_id IN (選択されたID) | 物理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | 確認 | 確認是否刪除選中的数据？ | 削除ボタン押下時 |
| MSG002 | エラー | xxx已分配，不能刪除 | 使用中の字典を削除しようとした場合 |
| MSG003 | 成功 | 操作成功 | 削除成功時 |
| MSG004 | 成功 | 刷新缓存成功 | キャッシュリフレッシュ成功時 |

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| 権限不足 | system:dict:view権限なし | 画面アクセス拒否 |
| 字典使用中 | 削除対象の字典データが存在 | エラーメッセージ表示、削除中止 |
| 通信エラー | Ajaxリクエスト失敗 | エラーメッセージ表示 |

## 備考

- 一覧のデフォルトソートはdictId（字典主鍵）の昇順
- 字典類型列はクリックで字典データ一覧に遷移するリンク付き
- 備考列は長文の場合tooltipで全文表示
- 字典はRedisにキャッシュされ、refreshCacheで手動更新可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | 字典類型エンティティ、@Excelアノテーション |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | type.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/type.html` | 画面構成、Bootstrap Table設定、detail関数 |

**主要処理フロー**:
1. **行9-37**: 検索フォーム（dictName, dictType, status, 日時範囲）
2. **行40-56**: ツールバーボタン（新規、修正、削除、導出、刷新缓存）
3. **行71-134**: Bootstrap Table初期化とカラム定義
4. **行137-140**: detail関数で字典データ画面へ遷移
5. **行143-145**: refreshCache関数でキャッシュリフレッシュ

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | 各エンドポイント |

**主要処理フロー**:
- **行45-53**: list()メソッド - ページング対応の一覧取得
- **行134-143**: refreshCache()メソッド - キャッシュリフレッシュ
- **行148-155**: detail()メソッド - 字典データ画面への遷移

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ISysDictTypeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDictTypeService.java` | サービスインターフェース |

### プログラム呼び出し階層図

```
type.html（Bootstrap Table初期化）
    │
    ├─ $.table.init() [行133]
    │      └─ POST /system/dict/list
    │             └─ SysDictTypeController.list()
    │
    ├─ refreshCache() [行143-145]
    │      └─ GET /system/dict/refreshCache
    │             └─ SysDictTypeController.refreshCache()
    │                    └─ dictTypeService.resetDictCache()
    │
    └─ detail(dictId) [行137-140]
           └─ GET /system/dict/detail/{dictId}
                  └─ SysDictTypeController.detail()
                         └─ 字典データ管理画面へ遷移
```

### データフロー図

```
[入力]                   [処理]                              [出力]

検索条件 ───────────▶ SysDictTypeController.list()
  - dictName                   │
  - dictType                   ├─▶ startPage()
  - status                     ├─▶ selectDictTypeList()
  - beginTime                  │         └─▶ sys_dict_type SELECT
  - endTime                    └─▶ getDataTable() ──────▶ TableDataInfo
                                                              │
                                                              ▼
                                                        Bootstrap Table描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| type.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/type.html` | テンプレート | 一覧画面 |
| add.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/add.html` | テンプレート | 新規登録画面 |
| edit.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/edit.html` | テンプレート | 編集画面 |
| SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | コントローラー | リクエスト処理 |
| ISysDictTypeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDictTypeService.java` | インターフェース | サービス定義 |
| SysDictTypeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictTypeMapper.xml` | 設定 | SQLマッピング |
| SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | エンティティ | データモデル |
