# 画面設計書 38-字典類型新規登録

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「字典類型新規登録」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、新規の字典類型（辞書タイプ）を登録するための入力フォーム画面である。システム管理者は本画面を通じて、新しい辞書カテゴリを追加することができる。

**業務上の目的・背景**：業務要件の変化に伴い、新しい選択肢カテゴリが必要になることがある。例えば、新しいステータス種別や分類区分を追加する場合、まず字典類型を登録し、その後に具体的な字典データ（選択肢の値）を登録する。本画面は、この字典類型登録を行うためのインターフェースを提供する。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」>「字典管理」を選択し、字典類型管理一覧画面に遷移後、ツールバーの「新規」ボタンをクリックすることで本画面がモーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. 字典名称の入力（必須、100文字以内）
2. 字典類型の入力（必須、100文字以内、5文字以上、一意性チェック、小文字英数字とアンダースコアのみ）
3. 状態の選択（正常/停用）
4. 備考の入力（任意）
5. 確定ボタンで登録処理を実行

**画面遷移**：字典類型管理一覧画面から本画面に遷移する。登録完了後は字典類型管理一覧画面に戻り、一覧が更新される。

**権限による表示制御**：`system:dict:add`権限を持つユーザーのみが本画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 辞書タイプ管理 | 主機能 | 新規辞書タイプ情報入力と登録保存処理 |

## 画面種別

登録（モーダルダイアログ形式）

## URL/ルーティング

- 画面表示：`GET /system/dict/add`
- 登録処理：`POST /system/dict/add`
- 字典類型一意性チェック：`POST /system/dict/checkDictTypeUnique`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|-----|------|--------|----------|------|
| 字典名称 | dictName | String | ○ | 100 | テキスト | 辞書の表示名 |
| 字典類型 | dictType | String | ○ | 100 | テキスト | 5文字以上、小文字英数字とアンダースコアのみ、一意 |
| 状態 | status | String | - | 1 | ラジオ | 0:正常、1:停用 |
| 備考 | remark | String | - | - | テキストエリア | 自由記述 |

## 表示項目

| 項目名 | 表示形式 | 初期値 | 備考 |
|--------|----------|--------|------|
| 字典名称 | テキストボックス | 空 | 必須入力 |
| 字典類型 | テキストボックス | 空 | 必須入力、ヘルプテキスト表示 |
| 状態 | ラジオボタン | 正常 | sys_normal_disable辞書から取得 |
| 備考 | テキストエリア | 空 | 任意 |

## イベント仕様

### 1-確定ボタン押下

入力内容のバリデーションを行い、問題がなければサーバーへPOSTリクエストを送信して字典類型を登録する。

**バリデーション処理**：
1. 必須項目チェック（字典名称、字典類型）
2. 字典類型の最小文字数チェック（5文字以上）
3. 字典類型の一意性チェック（Ajax、`/system/dict/checkDictTypeUnique`）
4. 字典類型の形式チェック（小文字英字で始まり、小文字英数字とアンダースコアのみ）

**登録処理**：
1. バリデーション成功後、`/system/dict/add`へフォームデータをPOST
2. サーバー側で再度一意性チェック
3. sys_dict_typeテーブルにINSERT
4. 成功時：親画面を更新してモーダルを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確定ボタン押下 | sys_dict_type | INSERT | 新規字典類型レコードの登録 |

### テーブル別更新項目詳細

#### sys_dict_type

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | dict_name | 画面入力値（dictName） | 字典名称 |
| INSERT | dict_type | 画面入力値（dictType） | 字典類型 |
| INSERT | status | 画面入力値（status） | 状態 |
| INSERT | remark | 画面入力値（remark） | 備考 |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | エラー | 該字典類型已經存在 | 字典類型重複時 |
| MSG002 | エラー | 新増字典'xxx'失敗，字典類型已存在 | サーバー側重複時 |
| MSG003 | 成功 | 操作成功 | 登録成功時 |

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| 権限不足 | system:dict:add権限なし | 画面アクセス拒否 |
| 一意性違反 | 字典類型が既存 | エラーメッセージ表示、処理中止 |
| 形式不正 | 字典類型が規定形式に違反 | クライアント側でバリデーションエラー |
| 通信エラー | Ajaxリクエスト失敗 | エラーメッセージ表示 |

## 備考

- 字典類型はシステム内部で使用するキー値であり、sys_user_sexのような形式で命名する
- 小文字英字で始まり、小文字英数字とアンダースコアのみ使用可能
- 最小5文字の制限があり、識別性を確保している
- 状態の選択肢はsys_normal_disable辞書から動的に取得される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | 字典類型エンティティ、@Patternアノテーション |

**読解のコツ**: @NotBlank, @Size, @Patternアノテーションで入力制約を確認。特に@Pattern(regexp = "^[a-z][a-z0-9_]*$")で字典類型の形式が定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | add.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/add.html` | 画面構成、入力項目、ヘルプテキスト |

**主要処理フロー**:
1. **行8-36**: フォーム定義（form-dict-add）、各入力項目、ヘルプテキスト（行19）
2. **行43-66**: jQuery Validateによるバリデーション設定（minlength: 5, remote）
3. **行68-72**: submitHandler関数で$.operate.saveを呼び出し

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | add, addSave, checkDictTypeUniqueメソッド |

**主要処理フロー**:
- **行70-75**: add()メソッド - 画面表示
- **行80-92**: addSave()メソッド - 登録処理、一意性チェック
- **行160-165**: checkDictTypeUnique()メソッド - Ajax一意性チェック

### プログラム呼び出し階層図

```
add.html（フォーム送信）
    │
    ├─ submitHandler() [JavaScript]
    │      └─ $.operate.save()
    │             └─ POST /system/dict/add
    │
    └─ SysDictTypeController.addSave() [行80-92]
           │
           ├─ dictTypeService.checkDictTypeUnique() [行86]
           │
           └─ dictTypeService.insertDictType() [行91]
                  └─ dictTypeMapper.insertDictType() [Mapper]
```

### データフロー図

```
[入力]                   [処理]                              [出力]

フォーム入力データ ──▶ SysDictTypeController.addSave()
  - dictName                  │
  - dictType                  ├─▶ checkDictTypeUnique()
  - status                    │         └─▶ sys_dict_type SELECT
  - remark                    │
                              └─▶ insertDictType()
                                      └─▶ sys_dict_type INSERT ──▶ AjaxResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| add.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/add.html` | テンプレート | 画面表示 |
| SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | コントローラー | リクエスト処理 |
| ISysDictTypeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDictTypeService.java` | インターフェース | サービス定義 |
| SysDictTypeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictTypeMapper.xml` | 設定 | SQLマッピング |
| SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | エンティティ | データモデル |
