# 画面設計書 39-字典類型編集

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「字典類型編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、既存の字典類型（辞書タイプ）情報を変更するための編集フォーム画面である。字典の名称、類型コード、状態などを更新することができる。

**業務上の目的・背景**：業務要件の変化や命名規則の統一に伴い、既存の字典類型の名称や類型コードを変更する必要がある場合がある。本画面は、これらの変更を適切に管理し、字典データとの整合性を保ちながら更新を行うためのインターフェースを提供する。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」>「字典管理」を選択し、字典類型管理一覧画面に遷移後、編集対象の字典類型行の「編集」ボタンをクリックすることで本画面がモーダルダイアログとして表示される。

**主要な操作・処理内容**：
1. 既存の字典類型情報の表示・確認
2. 字典名称の変更（必須、100文字以内）
3. 字典類型の変更（必須、100文字以内、5文字以上、一意性チェック、小文字英数字とアンダースコアのみ）
4. 状態の変更（正常/停用）
5. 備考の変更（任意）
6. 確定ボタンで更新処理を実行

**画面遷移**：字典類型管理一覧画面から本画面に遷移する。更新完了後は字典類型管理一覧画面に戻り、一覧が更新される。

**権限による表示制御**：`system:dict:edit`権限を持つユーザーのみが本画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 辞書タイプ管理 | 主機能 | 辞書タイプ情報の更新保存処理 |

## 画面種別

編集（モーダルダイアログ形式）

## URL/ルーティング

- 画面表示：`GET /system/dict/edit/{dictId}`
- 更新処理：`POST /system/dict/edit`
- 字典類型一意性チェック：`POST /system/dict/checkDictTypeUnique`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|-----|------|--------|----------|------|
| 字典ID | dictId | Long | ○ | - | hidden | 更新対象の識別子 |
| 字典名称 | dictName | String | ○ | 100 | テキスト | 辞書の表示名 |
| 字典類型 | dictType | String | ○ | 100 | テキスト | 5文字以上、小文字英数字とアンダースコアのみ、一意（自身除外） |
| 状態 | status | String | - | 1 | ラジオ | 0:正常、1:停用 |
| 備考 | remark | String | - | - | テキストエリア | 自由記述 |

## 表示項目

| 項目名 | 表示形式 | 初期値 | 備考 |
|--------|----------|--------|------|
| 字典名称 | テキストボックス | 現在の字典名称 | 必須入力 |
| 字典類型 | テキストボックス | 現在の字典類型 | 必須入力、ヘルプテキスト表示 |
| 状態 | ラジオボタン | 現在の状態 | sys_normal_disable辞書から取得 |
| 備考 | テキストエリア | 現在の備考 | 任意 |

## イベント仕様

### 1-確定ボタン押下

入力内容のバリデーションを行い、問題がなければサーバーへPOSTリクエストを送信して字典類型情報を更新する。

**バリデーション処理**：
1. 必須項目チェック（字典名称、字典類型）
2. 字典類型の最小文字数チェック（5文字以上）
3. 字典類型の一意性チェック（Ajax、dictIdを含めて自身を除外）
4. 字典類型の形式チェック（小文字英字で始まり、小文字英数字とアンダースコアのみ）

**更新処理**：
1. バリデーション成功後、`/system/dict/edit`へフォームデータをPOST
2. サーバー側で再度一意性チェック（自身を除外）
3. sys_dict_typeテーブルをUPDATE
4. 字典類型が変更された場合、関連する字典データのdictTypeも更新
5. 成功時：親画面を更新してモーダルを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確定ボタン押下 | sys_dict_type | UPDATE | 字典類型レコードの更新 |
| 字典類型変更時 | sys_dict_data | UPDATE | 関連する字典データのdictTypeも更新 |

### テーブル別更新項目詳細

#### sys_dict_type

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | dict_name | 画面入力値（dictName） | 字典名称 |
| UPDATE | dict_type | 画面入力値（dictType） | 字典類型 |
| UPDATE | status | 画面入力値（status） | 状態 |
| UPDATE | remark | 画面入力値（remark） | 備考 |
| UPDATE | update_by | ログインユーザー名 | 更新者 |
| UPDATE | update_time | sysdate() | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | エラー | 該字典類型已經存在 | 字典類型重複時 |
| MSG002 | エラー | 修改字典'xxx'失敗，字典類型已存在 | サーバー側重複時 |
| MSG003 | 成功 | 操作成功 | 更新成功時 |

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| 権限不足 | system:dict:edit権限なし | 画面アクセス拒否 |
| 一意性違反 | 字典類型が既存（自身を除く） | エラーメッセージ表示、処理中止 |
| 形式不正 | 字典類型が規定形式に違反 | クライアント側でバリデーションエラー |
| 通信エラー | Ajaxリクエスト失敗 | エラーメッセージ表示 |

## 備考

- 一意性チェック時はdictIdを含めてリクエストし、自身のレコードは除外して判定
- th:fieldでフォームに既存値をバインド
- 字典類型を変更した場合、関連する字典データ（sys_dict_data）のdictTypeも連動して更新される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | 字典類型エンティティ、バリデーションアノテーション |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | edit.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/edit.html` | 画面構成、th:fieldによる既存値バインディング |

**主要処理フロー**:
1. **行9**: dictIdをhiddenフィールドで保持
2. **行13, 19**: th:fieldで既存値をバインド
3. **行44-70**: jQuery ValidateでdictIdを含めた一意性チェック
4. **行72-76**: submitHandler関数で$.operate.saveを呼び出し

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | edit, editSaveメソッド |

**主要処理フロー**:
- **行97-103**: edit()メソッド - 画面表示、既存データ取得
- **行108-120**: editSave()メソッド - 更新処理、一意性チェック

### プログラム呼び出し階層図

```
edit.html（フォーム送信）
    │
    ├─ submitHandler() [JavaScript]
    │      └─ $.operate.save()
    │             └─ POST /system/dict/edit
    │
    └─ SysDictTypeController.editSave() [行108-120]
           │
           ├─ dictTypeService.checkDictTypeUnique() [行114]
           │
           └─ dictTypeService.updateDictType() [行119]
                  └─ dictTypeMapper.updateDictType() [Mapper]
```

### データフロー図

```
[入力]                   [処理]                              [出力]

編集フォームデータ ──▶ SysDictTypeController.editSave()
  - dictId                    │
  - dictName                  ├─▶ checkDictTypeUnique(dictId含む)
  - dictType                  │
  - status                    └─▶ updateDictType()
  - remark                           └─▶ sys_dict_type UPDATE ──▶ AjaxResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| edit.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/edit.html` | テンプレート | 画面表示 |
| SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | コントローラー | リクエスト処理 |
| ISysDictTypeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDictTypeService.java` | インターフェース | サービス定義 |
| SysDictTypeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictTypeMapper.xml` | 設定 | SQLマッピング |
| SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | エンティティ | データモデル |
