# 画面設計書 4-システム首頁

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「システム首頁」の設計仕様を定義する。

### 本画面の処理概要

ログイン後のメイン画面であり、左側にナビゲーションメニュー、右側にiframe形式のコンテンツ領域を持つレイアウト構成。システムの全機能へのアクセス起点となる。

**業務上の目的・背景**：後台管理システムにおいて、ユーザーが各機能に効率的にアクセスできる統合的なインターフェースを提供する。左側サイドバーメニューによる階層的なナビゲーション、タブ形式のマルチウィンドウ操作、テーマ切替による個人カスタマイズなど、業務効率を最大化するための機能を集約している。権限に応じたメニュー表示により、ユーザーは自身がアクセス可能な機能のみを認識できる。

**画面へのアクセス方法**：ログイン成功後に自動的にこの画面に遷移する。また、画面ロック解除後やブラウザリロード時もこの画面に戻る。URL直接アクセスは `/index`。

**主要な操作・処理内容**：
1. サイドバーメニューからの各機能画面への遷移
2. タブによる複数画面の同時表示・切り替え
3. ユーザーアバタークリックによるドロップダウンメニュー表示
4. 個人中心・パスワード変更・テーマ切替・メニュー切替へのアクセス
5. 画面ロック・全画面表示・ログアウトの実行
6. タブの右クリックコンテキストメニュー操作

**画面遷移**：
- 遷移元：ログイン画面（認証成功時）、画面ロック（解除時）
- 遷移先：各管理機能画面（iframeで表示）、ログイン画面（ログアウト時）、画面ロック（ロック時）、テーマ切替画面（モーダル）

**権限による表示制御**：サイドバーメニューはユーザーのロールに基づいて動的に生成される。管理者はすべてのメニューが表示されるが、一般ユーザーは割り当てられた権限に対応するメニューのみが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログイン | API連携 | ログイン状態確認とセッション管理 |

## 画面種別

フレーム（メイン）

## URL/ルーティング

- GET `/index` - システム首頁の表示
- GET `/system/main` - メインコンテンツ（デフォルト）の表示
- GET `/logout` - ログアウト処理
- GET `/lockscreen` - 画面ロック
- GET `/system/switchSkin` - テーマ切替画面
- GET `/system/menuStyle/{style}` - メニュースタイル切替

## 入出力項目

本画面は入力項目を持たない（表示専用フレーム）。

## 表示項目

| 項目名 | 説明 |
|--------|------|
| システムロゴ | 「RuoYi」ロゴ |
| ユーザーアバター | ログインユーザーのプロフィール画像 |
| ユーザー名 | ログインユーザーのloginName |
| オンライン状態 | 「在线」表示 |
| サイドバーメニュー | 権限に基づく階層メニュー（最大4階層） |
| タブバー | 開いている画面のタブ一覧 |
| コンテンツiframe | 選択された機能画面を表示 |
| ヘッダーツールバー | 文档・锁屏・全屏アイコン |
| フッター | コピーライト表示（設定により非表示可） |

## イベント仕様

### 1-サイドバーメニュークリック

1. メニュー項目をクリック
2. 該当するURLのコンテンツをiframeで表示
3. タブバーに新しいタブを追加（既存の場合はアクティブ化）
4. メニュー項目をハイライト表示

### 2-タブクリック

1. 対象タブをアクティブ化
2. 対応するiframeを表示
3. サイドバーメニューの対応項目をハイライト（連動設定時）

### 3-タブ右クリック（コンテキストメニュー）

- 「刷新」：現在のタブを再読み込み
- 「关闭当前」：現在のタブを閉じる
- 「关闭其他」：他のタブをすべて閉じる
- 「关闭左侧」：左側のタブをすべて閉じる
- 「关闭右侧」：右側のタブをすべて閉じる
- 「关闭全部」：すべてのタブを閉じる
- 「全屏显示」：現在のタブを全画面表示

### 4-ユーザードロップダウンメニュー

- 「个人中心」：プロフィール画面を開く
- 「修改密码」：パスワード変更モーダルを開く
- 「切换主题」：テーマ切替モーダルを開く
- 「横向菜单」：トップナビ型レイアウトに切替
- 「退出登录」：ログアウト処理

### 5-画面ロック（锁屏）

1. `/lockscreen` に遷移
2. 現在のタブパスをローカルストレージに保存

### 6-全画面表示

1. ブラウザの全画面APIを使用
2. 全画面終了で元に戻る

### 7-メニュー折りたたみ

1. ハンバーガーアイコンをクリック
2. サイドバーの展開/折りたたみを切り替え

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | sys_menu | SELECT | ユーザー権限に基づくメニュー取得 |
| ログアウト | sys_user_online | DELETE | オンラインユーザー情報の削除 |
| ログアウト | sys_logininfor | INSERT | ログアウト履歴の記録 |

### テーブル別更新項目詳細

本画面自体はデータベースを更新しない。メニュー表示のためにsys_menuをSELECTするのみ。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 確認 | 确认要切换成横向菜单吗？ | 横向メニュー切替選択時 |
| 警告 | 您的密码还是初始密码，请修改密码！ | 初期パスワード未変更時 |
| 警告 | 您的密码已过期，请尽快修改密码！ | パスワード有効期限切れ時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| セッションタイムアウト | ログイン画面にリダイレクト |
| 画面ロック中のアクセス | 画面ロック画面にリダイレクト |
| iframe内でのセッション切れ | トップフレームをログイン画面にリダイレクト |

## 備考

- メニュースタイルはCookieに保存され、次回ログイン時に復元される
- テーマ（スキン）設定はローカルストレージに保存される
- 履歴パス機能により、リロード時に最後に表示していたタブが復元される
- 初期パスワード変更促進機能はsys.account.initPasswordModify設定で制御
- パスワード有効期限機能はsys.account.passwordValidateDays設定で制御
- モバイルデバイスでは自動的にcollapsed状態で表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メニュー表示で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysMenu.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java` | メニューエンティティ、children階層構造 |
| 1-2 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザー情報（avatar, loginName） |

**読解のコツ**: SysMenuのchildren属性による再帰的な階層構造を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | /indexのハンドリング |

**主要処理フロー**:
1. **48-89行目**: GET /index - メニュー取得、設定値取得、テンプレート選択
2. **54行目**: menuService.selectMenusByUser() - 権限に基づくメニュー取得
3. **71-88行目**: Cookie/設定によるメニュースタイル判定

#### Step 3: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html | `ruoyi-admin/src/main/resources/templates/index.html` | 左側メニュー型レイアウト |
| 3-2 | index.js | `ruoyi-admin/src/main/resources/static/ruoyi/index.js` | タブ管理、メニュー連動 |

**主要処理フロー**:
- **index.html 52-73行目**: Thymeleafによるメニュー再帰表示
- **index.js**: タブ操作、コンテキストメニュー、ストレージ管理

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ISysMenuService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java` | メニューサービスインターフェース |
| 4-2 | SysMenuServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysMenuServiceImpl.java` | selectMenusByUser実装 |

### プログラム呼び出し階層図

```
Browser: GET /index
    │
    └─ SysIndexController.index()
           │
           ├─ getSysUser() - 現在のユーザー取得
           │
           ├─ menuService.selectMenusByUser()
           │      │
           │      └─ SysMenuMapper.selectMenusByUserId()
           │
           ├─ configService.selectConfigByKey() - 各種設定取得
           │      ├─ sys.index.sideTheme
           │      ├─ sys.index.skinName
           │      ├─ sys.index.footer
           │      └─ sys.index.tagsView
           │
           └─ return "index" or "index-topnav"
```

### データフロー図

```
[入力]               [処理]                    [出力]

Session(User) ──▶ SysIndexController ──▶ Model {menus, user, settings}
                        │                          │
                        ├──▶ ISysMenuService       └──▶ index.html
                        │
                        └──▶ ISysConfigService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `ruoyi-admin/src/main/resources/templates/index.html` | テンプレート | 左側メニュー型レイアウト |
| index.js | `ruoyi-admin/src/main/resources/static/ruoyi/index.js` | JavaScript | タブ・メニュー管理 |
| common.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/common.js` | JavaScript | 共通ユーティリティ |
| SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | コントローラー | 首頁エンドポイント |
| ISysMenuService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java` | サービス | メニュー操作 |
| SysMenu.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java` | エンティティ | メニューデータ構造 |
| style.min.css | `ruoyi-admin/src/main/resources/static/css/style.min.css` | スタイル | メインスタイル |
| skins.css | `ruoyi-admin/src/main/resources/static/css/skins.css` | スタイル | テーマスタイル |
| jquery.contextMenu.min.js | `ruoyi-admin/src/main/resources/static/js/jquery.contextMenu.min.js` | JavaScript | コンテキストメニュー |
