# 画面設計書 40-字典類型ツリー表示

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「字典類型ツリー表示」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、字典類型（辞書タイプ）の一覧をツリー形式で表示し、選択するための画面である。他の画面からポップアップで呼び出され、字典類型を選択するためのインターフェースを提供する。

**業務上の目的・背景**：システム内の様々な入力項目において、字典類型を指定する必要がある場合がある。本画面は、登録されている字典類型をツリー形式で一覧表示し、視覚的に確認しながら選択できるようにすることで、入力の効率化と正確性向上を図る。

**画面へのアクセス方法**：字典類型を選択する必要がある画面から、選択ボタンやリンクをクリックすることで本画面がポップアップとして表示される。

**主要な操作・処理内容**：
1. 字典類型一覧のツリー表示（正常状態のもののみ）
2. キーワード検索による絞り込み
3. ツリーノードのクリックによる選択
4. 選択結果の呼び出し元画面への反映

**画面遷移**：他の画面からポップアップとして呼び出される。字典類型ノードをクリックすると選択値が設定され、呼び出し元画面のフォームに反映される。

**権限による表示制御**：特別な権限制御はなく、呼び出し元画面の権限に依存する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 辞書タイプ管理 | 主機能 | 辞書タイプ一覧のツリー形式表示と選択 |

## 画面種別

選択（ポップアップダイアログ形式）

## URL/ルーティング

- 画面表示：`GET /system/dict/selectDictTree/{columnId}/{dictType}`
- ツリーデータ取得：`GET /system/dict/treeData`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|-----|------|--------|----------|------|
| カラムID | columnId | Long | ○ | - | パスパラメータ | 呼び出し元画面のカラム識別子 |
| 字典類型 | dictType | String | ○ | - | パスパラメータ | 初期選択対象の字典類型 |
| 検索キーワード | keyword | String | - | 50 | テキスト | ツリーノードの検索条件 |

## 表示項目

| 項目名 | 表示形式 | 初期値 | 備考 |
|--------|----------|--------|------|
| 検索キーワード | テキストボックス | 空 | ツリーノードの絞り込み検索 |
| 字典類型ツリー | ztree | 全字典類型 | 正常状態のもののみ表示 |

## イベント仕様

### 1-ツリーノードクリック

ツリー上の字典類型ノードをクリックすると、該当の字典類型が選択状態となり、呼び出し元画面の対応フィールドに値が反映される。

**処理内容**：
1. クリックされたノードのtitle属性（dictType値）を取得
2. hidden項目「dictType」に選択値を設定
3. 呼び出し元画面のフィールドに選択値を反映

### 2-検索ボタン押下

入力されたキーワードでツリーノードを検索し、該当するノードをハイライト表示する。

**処理内容**：
1. 入力されたキーワードを取得
2. $.tree.searchNode()でツリー内を検索
3. 該当ノードをハイライト表示

### 3-検索表示/非表示切替

検索欄の表示/非表示を切り替える。

**処理内容**：
1. treeShowHideButtonクリックで$.tree.toggleSearch()を呼び出し
2. 検索欄の表示状態を切り替え
3. ボタンラベルを「︾」（表示時）/「︽」（非表示時）に切替

## データベース参照仕様

### 操作別データベース参照一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | sys_dict_type | SELECT | 全字典類型を取得（正常状態のみ） |

### テーブル別参照項目詳細

#### sys_dict_type

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | dict_id | status = '0' | ノードID |
| SELECT | dict_name | status = '0' | ツリー表示名（括弧付き） |
| SELECT | dict_type | status = '0' | title属性、選択値 |

## ツリーデータ構造

ツリーノードはZtreeエンティティで構成される。

| 属性名 | データ型 | 内容 | 備考 |
|--------|---------|------|------|
| id | Long | dictId | ノード識別子 |
| pId | Long | なし | 親ノードなし（フラット構造） |
| name | String | (dictName) dictType | 表示名 |
| title | String | dictType | 選択時に返却される値 |
| checked | boolean | false | 選択状態 |
| open | boolean | false | 展開状態 |
| nocheck | boolean | false | 選択可否 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| - | - | - | 本画面では特定のメッセージ表示なし |

## 例外処理

| 例外パターン | 発生条件 | 処理内容 |
|-------------|----------|----------|
| データ取得エラー | treeData API失敗 | エラーメッセージ表示 |
| 検索結果なし | 該当ノードなし | 検索結果なしの状態を表示 |

## 備考

- 字典類型は階層構造を持たないため、フラットなリスト形式でツリー表示される
- 表示名は「(字典名称) 字典類型」の形式で表示される
- 停用状態（status = '1'）の字典類型は表示されない
- ztree.jsライブラリを使用してツリーコンポーネントを実装
- 選択時はtitle属性（dictType値）が呼び出し元に返却される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | ツリーノードの構造（id, pId, name, title, checked, open） |
| 1-2 | SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | 字典類型エンティティ |

**読解のコツ**: Ztreeクラスはztree.jsライブラリが期待するJSON構造にマッピングされる。title属性が選択時に返却される値として使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tree.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/tree.html` | 画面構成、ztree初期化、zOnClick関数 |

**主要処理フロー**:
1. **行12-14**: hidden項目（columnId, treeId, dictType）でパラメータを保持
2. **行19-22**: 検索欄（キーワード入力、検索ボタン）
3. **行23**: ztreeコンテナ
4. **行28-35**: $.tree.init()でツリー初期化、treeDataエンドポイントからデータ取得
5. **行37-39**: zOnClick関数でノードクリック時にdictTypeをhiddenに設定

#### Step 3: コントローラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | selectDictTree, treeDataメソッド |

**主要処理フロー**:
- **行170-176**: selectDictTree()メソッド - 画面表示、columnIdとdictTypeをモデルに設定
- **行181-187**: treeData()メソッド - 全字典類型をZtree形式で返却

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysDictTypeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictTypeServiceImpl.java` | selectDictTree, transDictNameメソッド |

**主要処理フロー**:
- **行235-251**: selectDictTree()メソッド - SysDictTypeからZtreeへの変換、正常状態のみフィルタ
- **行241**: status = '0'（正常）のチェック
- **行244-246**: Ztreeへの値設定（id=dictId, name=transDictName, title=dictType）
- **行253-258**: transDictName()メソッド - 「(dictName) dictType」形式の表示名生成

### プログラム呼び出し階層図

```
tree.html（画面表示）
    │
    ├─ SysDictTypeController.selectDictTree() [行170-176]
    │      └─ dictTypeService.selectDictTypeByType() [行174]
    │             └─ dictTypeMapper.selectDictTypeByType() [Mapper行53]
    │
    ├─ $.tree.init() [JavaScript]
    │      └─ GET /system/dict/treeData
    │             └─ SysDictTypeController.treeData() [行181-187]
    │                    └─ dictTypeService.selectDictTree() [行185]
    │                           └─ dictTypeMapper.selectDictTypeList() [Mapper]
    │
    └─ zOnClick() [JavaScript]
           └─ $("#dictType").val(treeNode.title)
```

### データフロー図

```
[入力]                   [処理]                              [出力]

パスパラメータ ────▶ SysDictTypeController.selectDictTree()
  - columnId                │
  - dictType                └─▶ selectDictTypeByType()
                                     └─▶ dict情報取得 ────▶ Model

画面ロード時 ────────▶ $.tree.init()
                            └─▶ GET /system/dict/treeData
                                     └─▶ dictTypeService.selectDictTree()
                                              │
                                              ├─▶ dictTypeMapper.selectDictTypeList()
                                              │
                                              └─▶ List<Ztree>変換 ────▶ JSON

ノードクリック ────▶ zOnClick(event, treeId, treeNode)
                            └─▶ treeNode.title取得 ────▶ hidden項目に設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tree.html | `ruoyi-admin/src/main/resources/templates/system/dict/type/tree.html` | テンプレート | 画面表示 |
| SysDictTypeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` | コントローラー | リクエスト処理 |
| ISysDictTypeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDictTypeService.java` | インターフェース | サービス定義 |
| SysDictTypeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictTypeServiceImpl.java` | サービス | ビジネスロジック |
| SysDictTypeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictTypeMapper.xml` | 設定 | SQLマッピング |
| Ztree.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` | エンティティ | ツリーノードモデル |
| SysDictType.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` | エンティティ | 字典類型モデル |
