# 画面設計書 41-字典データ管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムの「字典データ管理一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

字典データ（辞書データ）の一覧表示・管理を行う画面である。システム内で使用される各種コードや区分値を管理するためのマスタメンテナンス機能を提供する。

**業務上の目的・背景**：システム内で使用される「状態」「種別」「区分」などの選択肢を一元管理するための画面である。字典類型（辞書タイプ）に紐づく個々の選択項目データを管理することで、ハードコーディングを避け、運用段階でも柔軟にコード値の追加・変更が可能となる。システムの保守性と拡張性を向上させる重要な機能である。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」→「字典管理」→字典類型一覧画面で特定の字典類型を選択し「字典データ」ボタンを押下、またはメニューから直接アクセスする。

**主要な操作・処理内容**：
1. 字典データの検索（字典名称、字典標籤、状態による絞り込み）
2. 字典データの新規登録（新増ボタン押下）
3. 字典データの編集（修改ボタン押下）
4. 字典データの削除（削除ボタン押下、複数選択一括削除対応）
5. 字典データのExcelエクスポート（導出ボタン押下）
6. 画面を閉じて字典類型一覧に戻る（関閉ボタン押下）

**画面遷移**：
- 遷移元：字典類型管理一覧画面、システム首頁（メニュー）
- 遷移先：字典データ新規登録画面、字典データ編集画面

**権限による表示制御**：
- `system:dict:add`権限がない場合、「新増」ボタンは非表示
- `system:dict:edit`権限がない場合、「修改」ボタンおよび行内「編集」ボタンは非表示
- `system:dict:remove`権限がない場合、「削除」ボタンおよび行内「削除」ボタンは非表示
- `system:dict:export`権限がない場合、「導出」ボタンは非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | 辞書データ管理 | 主機能 | 辞書データ一覧の検索、表示処理 |
| 24 | ファイルダウンロード | 補助機能 | 辞書データのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

- 画面表示: `GET /system/dict/data`
- 一覧取得: `POST /system/dict/data/list`
- データ削除: `POST /system/dict/data/remove`
- Excelエクスポート: `POST /system/dict/data/export`

## 入出力項目

### 検索条件（入力）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 字典名称 | dictType | select | - | 字典類型を選択（ドロップダウン） |
| 字典標籤 | dictLabel | text | - | 部分一致検索 |
| 数据状態 | status | select | - | 0:正常、1:停用 |

## 表示項目

### 一覧テーブル

| 項目名 | 項目ID | 型 | ソート | 説明 |
|--------|--------|-----|--------|------|
| （チェックボックス） | - | checkbox | - | 複数選択用 |
| 字典編碼 | dictCode | number | - | 字典データID（主キー） |
| 字典標籤 | dictLabel | string | - | 表示用ラベル（スタイル適用） |
| 字典鍵値 | dictValue | string | - | 実際のコード値 |
| 字典排序 | dictSort | number | asc（デフォルト） | 表示順序 |
| 状態 | status | string | - | 0:正常、1:停用（辞書変換表示） |
| 備考 | remark | string | - | 備考欄 |
| 作成時間 | createTime | datetime | 可 | レコード作成日時 |
| 操作 | - | button | - | 編集・削除ボタン |

## イベント仕様

### 1-検索ボタン押下

検索条件を元にデータを再取得し、一覧テーブルを更新する。

- エンドポイント: `POST /system/dict/data/list`
- リクエストパラメータ: dictType, dictLabel, status, ページング情報
- レスポンス: TableDataInfo（total, rows）

### 2-重置（リセット）ボタン押下

検索条件をクリアし、字典名称は初期値（現在選択中の字典類型）を維持する。

### 3-新増ボタン押下

字典データ新規登録画面をモーダルウィンドウで開く。

- 遷移先URL: `/system/dict/data/add/{dictType}`
- dictTypeは現在選択中の字典類型コード

### 4-修改ボタン押下

選択されたデータの編集画面をモーダルウィンドウで開く。

- 遷移先URL: `/system/dict/data/edit/{dictCode}`
- 単一選択必須

### 5-削除ボタン押下

選択されたデータを一括削除する。

- 確認ダイアログ表示後、`POST /system/dict/data/remove`を実行
- パラメータ: ids（カンマ区切りのdictCode）

### 6-導出（エクスポート）ボタン押下

検索条件に一致するデータをExcelファイルとしてダウンロードする。

- エンドポイント: `POST /system/dict/data/export`

### 7-行内編集ボタン押下

該当行のデータを編集画面で開く（4-修改ボタンと同様）。

### 8-行内削除ボタン押下

該当行のデータを単独削除する（確認ダイアログあり）。

### 9-関閉（閉じる）ボタン押下

現在のタブを閉じ、字典類型一覧画面に戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索ボタン押下 | sys_dict_data | SELECT | 条件に一致する字典データを取得 |
| 削除ボタン押下 | sys_dict_data | DELETE | 選択された字典データを削除 |
| 導出ボタン押下 | sys_dict_data | SELECT | Excelエクスポート用データ取得 |

### テーブル別更新項目詳細

#### sys_dict_data

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | dict_code, dict_sort, dict_label, dict_value, dict_type, css_class, list_class, is_default, status, create_by, create_time, remark | dictType、dictLabel（LIKE）、status | 検索条件による |
| DELETE | - | dict_code IN (選択されたID) | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 確認 | 是否确认删除字典编号为"xxx"的数据项? | 削除実行前 |
| - | 成功 | 删除成功 | 削除完了時 |
| - | 成功 | 导出成功 | エクスポート完了時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| データ取得エラー | エラーメッセージを表示し、一覧は空で表示 |
| 削除対象なし | 「请先选择要删除的数据」メッセージ表示 |
| 権限不足 | ボタンは非表示のため基本的に発生しない |
| 通信エラー | エラーメッセージ表示 |

## 備考

- 字典データはキャッシュされており、追加・更新・削除時にキャッシュも同期更新される（DictUtils.setDictCache）
- 一覧は字典排序（dictSort）の昇順がデフォルトソート
- 字典標籤列は、cssClassまたはlistClassに応じたスタイル（badge等）で表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | 字典データエンティティのフィールド定義、バリデーション制約 |
| 1-2 | SysDictDataMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictDataMapper.xml` | テーブルカラムとエンティティのマッピング、SQL定義 |

**読解のコツ**: SysDictDataクラスの各フィールドは@Excel注釈でExcel出力時のカラム名を定義している。また、@NotBlank、@Size等のバリデーション注釈も確認すること。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | 各エンドポイントのマッピングと権限制御 |

**主要処理フロー**:
1. **37-42行目**: `dictData()`メソッド - 画面表示のエントリーポイント
2. **44-52行目**: `list()`メソッド - 一覧データ取得API
3. **54-63行目**: `export()`メソッド - Excelエクスポート処理
4. **113-121行目**: `remove()`メソッド - データ削除処理

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysDictDataService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDictDataService.java` | サービスインターフェース定義 |
| 3-2 | SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | サービス実装、キャッシュ更新処理 |

**主要処理フロー**:
- **30-33行目**: `selectDictDataList()` - 一覧検索
- **66-76行目**: `deleteDictDataByIds()` - 削除処理とキャッシュ更新

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | data.html | `ruoyi-admin/src/main/resources/templates/system/dict/data/data.html` | Thymeleafテンプレート、Bootstrap Table設定 |

**主要処理フロー**:
- **11-34行目**: 検索フォーム定義
- **37-53行目**: ツールバーボタン（権限制御付き）
- **68-131行目**: Bootstrap Table初期化、カラム定義

### プログラム呼び出し階層図

```
data.html (View)
    │
    ├─ $.table.init() → POST /system/dict/data/list
    │      │
    │      └─ SysDictDataController.list()
    │             │
    │             └─ ISysDictDataService.selectDictDataList()
    │                    │
    │                    └─ SysDictDataMapper.selectDictDataList()
    │
    ├─ $.operate.removeAll() → POST /system/dict/data/remove
    │      │
    │      └─ SysDictDataController.remove()
    │             │
    │             └─ ISysDictDataService.deleteDictDataByIds()
    │                    │
    │                    ├─ SysDictDataMapper.deleteDictDataById()
    │                    │
    │                    └─ DictUtils.setDictCache()
    │
    └─ $.table.exportExcel() → POST /system/dict/data/export
           │
           └─ SysDictDataController.export()
                  │
                  └─ ExcelUtil.exportExcel()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ─────────▶ Controller ──────────────▶ JSON Response
(dictType,           │                         (TableDataInfo)
 dictLabel,          ▼
 status)           Service
                     │
                     ▼
                   Mapper ──▶ sys_dict_data

削除ID ───────────▶ Controller ──────────────▶ AjaxResult
(ids)                │
                     ▼
                   Service
                     │
                     ├──▶ Mapper (DELETE)
                     │
                     └──▶ DictUtils (キャッシュ更新)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | ソース | 字典データエンティティ |
| SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | ソース | コントローラー |
| ISysDictDataService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDictDataService.java` | ソース | サービスインターフェース |
| SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | ソース | サービス実装 |
| SysDictDataMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictDataMapper.xml` | 設定 | MyBatisマッパー |
| data.html | `ruoyi-admin/src/main/resources/templates/system/dict/data/data.html` | テンプレート | 一覧画面HTML |
| DictUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/DictUtils.java` | ソース | 字典キャッシュユーティリティ |
