# 画面設計書 42-字典データ新規登録

## 概要

本ドキュメントは、RuoYi後台管理システムの「字典データ新規登録」画面の設計仕様を定義するものである。

### 本画面の処理概要

新規の字典データ（辞書データ）を登録するためのフォーム画面である。字典類型に紐づくコード値（選択肢）を追加するための入力機能を提供する。

**業務上の目的・背景**：システム内で使用される選択肢やコード値を動的に追加するための画面である。新しい状態区分や種別が必要になった際に、開発者によるコード変更なしに、管理者が直接データを追加できる。これにより、システムの運用柔軟性が大幅に向上し、業務要件の変化に迅速に対応可能となる。

**画面へのアクセス方法**：字典データ管理一覧画面のツールバーにある「新増」ボタンを押下することでモーダルウィンドウとして表示される。

**主要な操作・処理内容**：
1. 字典標籤（表示ラベル）の入力
2. 字典鍵値（コード値）の入力
3. 様式属性（CSSクラス）の入力（任意）
4. 字典排序（表示順序）の入力
5. 回显様式（表格表示スタイル）の選択
6. システムデフォルト設定の選択
7. 状態（有効/無効）の選択
8. 備考の入力（任意）
9. 確定ボタンで登録実行

**画面遷移**：
- 遷移元：字典データ管理一覧画面（モーダルとして開く）
- 遷移先：字典データ管理一覧画面（登録成功後、モーダルを閉じて一覧を更新）

**権限による表示制御**：
- `system:dict:add`権限がある場合のみ本画面にアクセス可能
- 権限がない場合、字典データ管理一覧画面の「新増」ボタン自体が非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | 辞書データ管理 | 主機能 | 新規辞書データ情報入力と登録保存処理 |

## 画面種別

登録

## URL/ルーティング

- 画面表示: `GET /system/dict/data/add/{dictType}`
- 登録実行: `POST /system/dict/data/add`

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 初期値 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| 字典標籤 | dictLabel | text | ○ | 100 | - | 画面表示用のラベル名 |
| 字典鍵値 | dictValue | text | ○ | 100 | - | 実際に保存されるコード値 |
| 字典類型 | dictType | text | ○ | - | URLパラメータから | 読み取り専用、所属する字典類型 |
| 様式属性 | cssClass | text | - | 100 | - | カスタムCSSクラス |
| 字典排序 | dictSort | number | ○ | - | - | 表示順序（整数のみ） |
| 回显様式 | listClass | select | - | - | - | table表格字典列の表示スタイル |
| 系統默認 | isDefault | radio | - | - | N | Y:是、N:否 |
| 状態 | status | radio | - | - | 0 | 0:正常、1:停用 |
| 備考 | remark | textarea | - | - | - | 備考欄 |

### 回显様式の選択肢

| 値 | 表示名 | 説明 |
|----|--------|------|
| (空) | ---请选择--- | 未設定 |
| default | 默认 | デフォルトスタイル |
| primary | 主要 | プライマリスタイル |
| success | 成功 | 成功スタイル（緑） |
| info | 信息 | 情報スタイル（青） |
| warning | 警告 | 警告スタイル（黄） |
| danger | 危险 | 危険スタイル（赤） |

## 表示項目

なし（入力フォームのみ）

## イベント仕様

### 1-確定（保存）ボタン押下

入力内容をバリデーション後、データを登録する。

- バリデーション:
  - dictLabel: 必須、100文字以内
  - dictValue: 必須、100文字以内
  - dictSort: 必須、整数のみ
- エンドポイント: `POST /system/dict/data/add`
- リクエストパラメータ: フォーム全項目
- 成功時: モーダルを閉じ、親画面の一覧を更新
- 失敗時: エラーメッセージを表示

### 2-取消（キャンセル）ボタン押下

モーダルウィンドウを閉じ、入力内容を破棄する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確定ボタン押下 | sys_dict_data | INSERT | 新規字典データを登録 |

### テーブル別更新項目詳細

#### sys_dict_data

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | dict_sort | 入力値 | 表示順序 |
| INSERT | dict_label | 入力値 | 字典標籤 |
| INSERT | dict_value | 入力値 | 字典鍵値 |
| INSERT | dict_type | URLパラメータ | 字典類型 |
| INSERT | css_class | 入力値 | 様式属性（任意） |
| INSERT | list_class | 入力値 | 回显様式（任意） |
| INSERT | is_default | 入力値（Y/N） | システムデフォルト |
| INSERT | status | 入力値（0/1） | 状態 |
| INSERT | remark | 入力値 | 備考（任意） |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 新增成功 | 登録完了時 |
| - | エラー | 字典标签不能为空 | dictLabel未入力時 |
| - | エラー | 字典键值不能为空 | dictValue未入力時 |
| - | エラー | 字典排序必须为数字 | dictSort非数値入力時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| バリデーションエラー | 該当項目にエラーメッセージを表示 |
| 重複データ | エラーメッセージを表示（現状、重複チェックは実装なし） |
| 通信エラー | エラーメッセージ表示 |
| 権限不足 | アクセス前に制御されるため基本的に発生しない |

## 備考

- 字典類型（dictType）はURLパラメータとして渡され、フォーム上は読み取り専用で表示
- 登録成功時、該当字典類型のキャッシュが自動更新される（DictUtils.setDictCache）
- 回显様式は、一覧画面で字典標籤列を表示する際のバッジスタイルに影響する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | フィールド定義、@NotBlank/@Size等のバリデーション制約 |

**読解のコツ**: 各フィールドのgetter/setterに付与されたバリデーション注釈を確認し、入力制約を把握すること。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | add(), addSave()メソッド |

**主要処理フロー**:
1. **65-74行目**: `add()`メソッド - 新規登録画面表示、dictTypeをModelに設定
2. **78-87行目**: `addSave()`メソッド - 登録処理実行、createByを設定

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | insertDictData()メソッド |

**主要処理フロー**:
- **84-94行目**: `insertDictData()` - Mapper呼び出し後、キャッシュ更新

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | add.html | `ruoyi-admin/src/main/resources/templates/system/dict/data/add.html` | フォーム構造、jQuery Validate設定 |

**主要処理フロー**:
- **8-78行目**: フォーム定義（各入力項目）
- **84-91行目**: バリデーションルール（dictSortは整数のみ）
- **93-97行目**: submitHandler - フォーム送信処理

### プログラム呼び出し階層図

```
add.html (View)
    │
    ├─ submitHandler() → POST /system/dict/data/add
    │      │
    │      └─ SysDictDataController.addSave()
    │             │
    │             ├─ getLoginName() → createBy設定
    │             │
    │             └─ ISysDictDataService.insertDictData()
    │                    │
    │                    ├─ SysDictDataMapper.insertDictData()
    │                    │      │
    │                    │      └─ sys_dict_data INSERT
    │                    │
    │                    └─ DictUtils.setDictCache()
    │
    └─ $.operate.save() → 成功時に親画面更新
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───────▶ jQuery Validate ────────▶ バリデーションOK/NG
(dictLabel,          │
 dictValue,          ▼ OK
 dictSort,         Controller
 listClass,          │
 isDefault,          ├─ createBy設定
 status,             │
 remark)             ▼
                   Service
                     │
                     ├─▶ Mapper (INSERT)
                     │      │
                     │      └─▶ sys_dict_data
                     │
                     └─▶ DictUtils (キャッシュ更新)
                           │
                           └─▶ AjaxResult (成功/失敗)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | ソース | 字典データエンティティ |
| SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | ソース | コントローラー |
| SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | ソース | サービス実装 |
| SysDictDataMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictDataMapper.xml` | 設定 | INSERT文定義 |
| add.html | `ruoyi-admin/src/main/resources/templates/system/dict/data/add.html` | テンプレート | 新規登録フォーム |
| DictUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/DictUtils.java` | ソース | キャッシュユーティリティ |
