# 画面設計書 43-字典データ編集

## 概要

本ドキュメントは、RuoYi後台管理システムの「字典データ編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

既存の字典データ（辞書データ）を編集・更新するためのフォーム画面である。登録済みのコード値や表示ラベルの変更機能を提供する。

**業務上の目的・背景**：システム運用中に発生する選択肢の名称変更、表示順序の調整、有効/無効の切替などを行うための画面である。例えば「状態」の表示名を変更したい場合や、表示スタイルを変更したい場合に使用する。ただし、既存データで使用されているコード値（dictValue）の変更は、データ整合性に影響を与える可能性があるため注意が必要である。

**画面へのアクセス方法**：字典データ管理一覧画面のツールバーにある「修改」ボタン、または各行の「編集」ボタンを押下することでモーダルウィンドウとして表示される。

**主要な操作・処理内容**：
1. 既存データの確認（画面表示時に自動読み込み）
2. 字典標籤（表示ラベル）の変更
3. 字典鍵値（コード値）の変更
4. 様式属性（CSSクラス）の変更
5. 字典排序（表示順序）の変更
6. 回显様式（表格表示スタイル）の変更
7. システムデフォルト設定の変更
8. 状態（有効/無効）の変更
9. 備考の変更
10. 確定ボタンで更新実行

**画面遷移**：
- 遷移元：字典データ管理一覧画面（モーダルとして開く）
- 遷移先：字典データ管理一覧画面（更新成功後、モーダルを閉じて一覧を更新）

**権限による表示制御**：
- `system:dict:edit`権限がある場合のみ本画面にアクセス可能
- 権限がない場合、字典データ管理一覧画面の「修改」ボタンおよび行内「編集」ボタンが非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | 辞書データ管理 | 主機能 | 辞書データ情報の更新保存処理 |

## 画面種別

編集

## URL/ルーティング

- 画面表示: `GET /system/dict/data/edit/{dictCode}`
- 更新実行: `POST /system/dict/data/edit`

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 初期値 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| 字典編碼 | dictCode | hidden | ○ | - | DBから取得 | 主キー（非表示） |
| 字典標籤 | dictLabel | text | ○ | 100 | DBから取得 | 画面表示用のラベル名 |
| 字典鍵値 | dictValue | text | ○ | 100 | DBから取得 | 実際に保存されるコード値 |
| 字典類型 | dictType | text | - | - | DBから取得 | 読み取り専用 |
| 様式属性 | cssClass | text | - | 100 | DBから取得 | カスタムCSSクラス |
| 字典排序 | dictSort | number | ○ | - | DBから取得 | 表示順序（整数のみ） |
| 回显様式 | listClass | select | - | - | DBから取得 | table表格字典列の表示スタイル |
| 系統默認 | isDefault | radio | - | - | DBから取得 | Y:是、N:否 |
| 状態 | status | radio | - | - | DBから取得 | 0:正常、1:停用 |
| 備考 | remark | textarea | - | - | DBから取得 | 備考欄 |

### 回显様式の選択肢

| 値 | 表示名 | 説明 |
|----|--------|------|
| (空) | ---请选择--- | 未設定 |
| default | 默认 | デフォルトスタイル |
| primary | 主要 | プライマリスタイル |
| success | 成功 | 成功スタイル（緑） |
| info | 信息 | 情報スタイル（青） |
| warning | 警告 | 警告スタイル（黄） |
| danger | 危险 | 危険スタイル（赤） |

## 表示項目

なし（入力フォームのみ）

## イベント仕様

### 1-画面表示時

URLパラメータのdictCodeを元にデータを取得し、フォームに初期表示する。

- エンドポイント: `GET /system/dict/data/edit/{dictCode}`
- レスポンス: editビュー + 字典データモデル

### 2-確定（保存）ボタン押下

入力内容をバリデーション後、データを更新する。

- バリデーション:
  - dictLabel: 必須、100文字以内
  - dictValue: 必須、100文字以内
  - dictSort: 必須、整数のみ
- エンドポイント: `POST /system/dict/data/edit`
- リクエストパラメータ: フォーム全項目（dictCode含む）
- 成功時: モーダルを閉じ、親画面の一覧を更新
- 失敗時: エラーメッセージを表示

### 3-取消（キャンセル）ボタン押下

モーダルウィンドウを閉じ、変更内容を破棄する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | sys_dict_data | SELECT | dictCodeに該当するデータを取得 |
| 確定ボタン押下 | sys_dict_data | UPDATE | 字典データを更新 |

### テーブル別更新項目詳細

#### sys_dict_data

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | dict_code = パラメータ値 | 初期表示用 |
| UPDATE | dict_sort | 入力値 | 表示順序 |
| UPDATE | dict_label | 入力値 | 字典標籤 |
| UPDATE | dict_value | 入力値 | 字典鍵値 |
| UPDATE | dict_type | 入力値 | 字典類型 |
| UPDATE | css_class | 入力値 | 様式属性 |
| UPDATE | list_class | 入力値 | 回显様式 |
| UPDATE | is_default | 入力値（Y/N） | システムデフォルト |
| UPDATE | status | 入力値（0/1） | 状態 |
| UPDATE | remark | 入力値 | 備考 |
| UPDATE | update_by | ログインユーザー名 | 更新者 |
| UPDATE | update_time | sysdate() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 修改成功 | 更新完了時 |
| - | エラー | 字典标签不能为空 | dictLabel未入力時 |
| - | エラー | 字典键值不能为空 | dictValue未入力時 |
| - | エラー | 字典排序必须为数字 | dictSort非数値入力時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| データ取得エラー | エラーページを表示 |
| バリデーションエラー | 該当項目にエラーメッセージを表示 |
| 対象データなし | エラーメッセージを表示 |
| 通信エラー | エラーメッセージ表示 |
| 権限不足 | アクセス前に制御されるため基本的に発生しない |

## 備考

- 字典類型（dictType）は読み取り専用として表示（変更不可）
- 更新成功時、該当字典類型のキャッシュが自動更新される（DictUtils.setDictCache）
- dictValueの変更は、既にこの値を使用しているデータに影響を与える可能性があるため注意

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | フィールド定義、バリデーション制約 |

**読解のコツ**: 編集画面ではth:field属性でエンティティのプロパティとバインドされる点に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | edit(), editSave()メソッド |

**主要処理フロー**:
1. **92-98行目**: `edit()`メソッド - 編集画面表示、dictCodeでデータ取得
2. **103-111行目**: `editSave()`メソッド - 更新処理実行、updateByを設定

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | selectDictDataById(), updateDictData()メソッド |

**主要処理フロー**:
- **54-58行目**: `selectDictDataById()` - 主キー検索
- **102-112行目**: `updateDictData()` - Mapper呼び出し後、キャッシュ更新

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.html | `ruoyi-admin/src/main/resources/templates/system/dict/data/edit.html` | Thymeleafバインディング、フォーム構造 |

**主要処理フロー**:
- **8行目**: th:objectでエンティティバインド
- **9行目**: hiddenフィールドでdictCode保持
- **85-92行目**: バリデーションルール
- **94-98行目**: submitHandler - フォーム送信処理

### プログラム呼び出し階層図

```
edit.html (View)
    │
    ├─ 画面表示時 ← GET /system/dict/data/edit/{dictCode}
    │      │
    │      └─ SysDictDataController.edit()
    │             │
    │             └─ ISysDictDataService.selectDictDataById()
    │                    │
    │                    └─ SysDictDataMapper.selectDictDataById()
    │
    └─ submitHandler() → POST /system/dict/data/edit
           │
           └─ SysDictDataController.editSave()
                  │
                  ├─ getLoginName() → updateBy設定
                  │
                  └─ ISysDictDataService.updateDictData()
                         │
                         ├─ SysDictDataMapper.updateDictData()
                         │      │
                         │      └─ sys_dict_data UPDATE
                         │
                         └─ DictUtils.setDictCache()
```

### データフロー図

```
[入力]               [処理]                    [出力]

dictCode ─────────▶ Controller ──────────────▶ edit.html
(PathVariable)       │                         (初期値設定済フォーム)
                     ▼
                   Service
                     │
                     └─▶ Mapper (SELECT)
                            │
                            └─▶ sys_dict_data

フォーム入力 ───────▶ jQuery Validate ────────▶ バリデーションOK/NG
(dictCode,           │
 dictLabel,          ▼ OK
 dictValue,        Controller
 ...)                │
                     ├─ updateBy設定
                     │
                     ▼
                   Service
                     │
                     ├─▶ Mapper (UPDATE)
                     │
                     └─▶ DictUtils (キャッシュ更新)
                           │
                           └─▶ AjaxResult (成功/失敗)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysDictData.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` | ソース | 字典データエンティティ |
| SysDictDataController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java` | ソース | コントローラー |
| SysDictDataServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java` | ソース | サービス実装 |
| SysDictDataMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysDictDataMapper.xml` | 設定 | SELECT/UPDATE文定義 |
| edit.html | `ruoyi-admin/src/main/resources/templates/system/dict/data/edit.html` | テンプレート | 編集フォーム |
| DictUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/DictUtils.java` | ソース | キャッシュユーティリティ |
