# 画面設計書 44-パラメータ管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムの「パラメータ管理一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

システムパラメータ（設定値）の一覧表示・管理を行う画面である。システム全体で使用される各種設定値を一元管理するための機能を提供する。

**業務上の目的・背景**：システムの動作を制御する設定値（例：ユーザー登録機能の有効/無効、初期パスワード、キャプチャ表示の有無等）を管理するための画面である。これらの設定値をデータベースで管理することで、アプリケーションの再起動なしに動的に設定を変更でき、運用の柔軟性を高めている。特にシステム内置（内蔵）パラメータは削除保護されており、重要設定の誤削除を防止する仕組みがある。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」→「パラメータ設定」を選択する。

**主要な操作・処理内容**：
1. パラメータの検索（パラメータ名称、パラメータ鍵名、システム内置、作成時間による絞り込み）
2. パラメータの新規登録（新増ボタン押下）
3. パラメータの編集（修改ボタン押下）
4. パラメータの削除（削除ボタン押下、複数選択一括削除対応）
5. パラメータのExcelエクスポート（導出ボタン押下）
6. キャッシュの刷新（刷新缓存ボタン押下）

**画面遷移**：
- 遷移元：システム首頁（メニュー）
- 遷移先：パラメータ新規登録画面、パラメータ編集画面

**権限による表示制御**：
- `system:config:add`権限がない場合、「新増」ボタンは非表示
- `system:config:edit`権限がない場合、「修改」ボタンおよび行内「編集」ボタンは非表示
- `system:config:remove`権限がない場合、「削除」ボタンおよび「刷新缓存」ボタン、行内「削除」ボタンは非表示
- `system:config:export`権限がない場合、「導出」ボタンは非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | パラメータ設定 | 主機能 | パラメータ一覧の検索、表示処理 |
| 24 | ファイルダウンロード | 補助機能 | パラメータデータのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

- 画面表示: `GET /system/config`
- 一覧取得: `POST /system/config/list`
- データ削除: `POST /system/config/remove`
- Excelエクスポート: `POST /system/config/export`
- キャッシュ刷新: `GET /system/config/refreshCache`

## 入出力項目

### 検索条件（入力）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 参数名称 | configName | text | - | 部分一致検索 |
| 参数鍵名 | configKey | text | - | 部分一致検索 |
| 系統内置 | configType | select | - | Y:是、N:否 |
| 創建時間（開始） | params[beginTime] | date | - | 範囲検索（開始） |
| 創建時間（終了） | params[endTime] | date | - | 範囲検索（終了） |

## 表示項目

### 一覧テーブル

| 項目名 | 項目ID | 型 | ソート | 説明 |
|--------|--------|-----|--------|------|
| （チェックボックス） | - | checkbox | - | 複数選択用 |
| 参数主鍵 | configId | number | asc（デフォルト） | パラメータID（主キー） |
| 参数名称 | configName | string | - | パラメータの説明名 |
| 参数鍵名 | configKey | string | - | システム内で使用するキー名 |
| 参数鍵値 | configValue | string | - | 設定値（ツールチップ表示） |
| 系統内置 | configType | string | - | Y:是、N:否（辞書変換表示） |
| 備考 | remark | string | - | 備考欄（ツールチップ表示） |
| 作成時間 | createTime | datetime | - | レコード作成日時 |
| 操作 | - | button | - | 編集・削除ボタン |

## イベント仕様

### 1-検索ボタン押下

検索条件を元にデータを再取得し、一覧テーブルを更新する。

- エンドポイント: `POST /system/config/list`
- リクエストパラメータ: configName, configKey, configType, params[beginTime], params[endTime], ページング情報
- レスポンス: TableDataInfo（total, rows）

### 2-重置（リセット）ボタン押下

全ての検索条件をクリアする。

### 3-新増ボタン押下

パラメータ新規登録画面をモーダルウィンドウで開く。

- 遷移先URL: `/system/config/add`

### 4-修改ボタン押下

選択されたデータの編集画面をモーダルウィンドウで開く。

- 遷移先URL: `/system/config/edit/{configId}`
- 単一選択必須

### 5-削除ボタン押下

選択されたデータを一括削除する。

- 確認ダイアログ表示後、`POST /system/config/remove`を実行
- パラメータ: ids（カンマ区切りのconfigId）
- システム内置（configType=Y）のパラメータは削除不可

### 6-導出（エクスポート）ボタン押下

検索条件に一致するデータをExcelファイルとしてダウンロードする。

- エンドポイント: `POST /system/config/export`

### 7-刷新缓存（キャッシュ刷新）ボタン押下

パラメータキャッシュを再読み込みする。

- エンドポイント: `GET /system/config/refreshCache`
- キャッシュをクリアし、DBから再読み込み

### 8-行内編集ボタン押下

該当行のデータを編集画面で開く（4-修改ボタンと同様）。

### 9-行内削除ボタン押下

該当行のデータを単独削除する（確認ダイアログあり）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索ボタン押下 | sys_config | SELECT | 条件に一致するパラメータを取得 |
| 削除ボタン押下 | sys_config | DELETE | 選択されたパラメータを削除 |
| 導出ボタン押下 | sys_config | SELECT | Excelエクスポート用データ取得 |
| 刷新缓存押下 | sys_config | SELECT | 全パラメータを取得しキャッシュ再構築 |

### テーブル別更新項目詳細

#### sys_config

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | config_id, config_name, config_key, config_value, config_type, create_by, create_time, update_by, update_time, remark | configName（LIKE）、configKey（LIKE）、configType、日付範囲 | 検索条件による |
| DELETE | - | config_id = 指定ID、config_type != 'Y' | システム内置は削除不可 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 確認 | 是否确认删除参数编号为"xxx"的数据项? | 削除実行前 |
| - | 成功 | 删除成功 | 削除完了時 |
| - | 成功 | 导出成功 | エクスポート完了時 |
| - | 成功 | 刷新缓存成功 | キャッシュ刷新完了時 |
| - | エラー | 内置参数【xxx】不能删除 | システム内置パラメータ削除時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| データ取得エラー | エラーメッセージを表示し、一覧は空で表示 |
| 削除対象なし | 「请先选择要删除的数据」メッセージ表示 |
| システム内置パラメータ削除 | 「内置参数【xxx】不能删除」エラー表示 |
| 権限不足 | ボタンは非表示のため基本的に発生しない |
| 通信エラー | エラーメッセージ表示 |

## 備考

- パラメータはキャッシュされており、起動時にDBから読み込まれる（@PostConstruct）
- 更新・削除時にキャッシュも同期更新される
- configValueは長い場合、ツールチップで全文表示
- 「刷新缓存」ボタンは`system:config:remove`権限で制御されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | パラメータエンティティのフィールド定義、バリデーション制約 |
| 1-2 | SysConfigMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml` | テーブルカラムとエンティティのマッピング、SQL定義 |

**読解のコツ**: SysConfigクラスの@Excel注釈でExcel出力時のカラム名を定義。@NotBlank、@Size等のバリデーション注釈も確認すること。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | 各エンドポイントのマッピングと権限制御 |

**主要処理フロー**:
1. **37-42行目**: `config()`メソッド - 画面表示のエントリーポイント
2. **47-55行目**: `list()`メソッド - 一覧データ取得API
3. **57-66行目**: `export()`メソッド - Excelエクスポート処理
4. **126-134行目**: `remove()`メソッド - データ削除処理
5. **139-147行目**: `refreshCache()`メソッド - キャッシュ刷新処理

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysConfigService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysConfigService.java` | サービスインターフェース定義 |
| 3-2 | SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | サービス実装、キャッシュ管理 |

**主要処理フロー**:
- **31-35行目**: `init()` - 起動時キャッシュ初期化（@PostConstruct）
- **82-86行目**: `selectConfigList()` - 一覧検索
- **133-147行目**: `deleteConfigByIds()` - 削除処理（システム内置チェック）
- **174-179行目**: `resetConfigCache()` - キャッシュ刷新

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | config.html | `ruoyi-admin/src/main/resources/templates/system/config/config.html` | Thymeleafテンプレート、Bootstrap Table設定 |

**主要処理フロー**:
- **10-37行目**: 検索フォーム定義（日付範囲検索含む）
- **40-56行目**: ツールバーボタン（権限制御付き）
- **69-140行目**: Bootstrap Table初期化、カラム定義
- **142-145行目**: refreshCache() - キャッシュ刷新処理

### プログラム呼び出し階層図

```
config.html (View)
    │
    ├─ $.table.init() → POST /system/config/list
    │      │
    │      └─ SysConfigController.list()
    │             │
    │             └─ ISysConfigService.selectConfigList()
    │                    │
    │                    └─ SysConfigMapper.selectConfigList()
    │
    ├─ $.operate.removeAll() → POST /system/config/remove
    │      │
    │      └─ SysConfigController.remove()
    │             │
    │             └─ ISysConfigService.deleteConfigByIds()
    │                    │
    │                    ├─ システム内置チェック
    │                    │
    │                    ├─ SysConfigMapper.deleteConfigById()
    │                    │
    │                    └─ CacheUtils.remove()
    │
    ├─ $.table.exportExcel() → POST /system/config/export
    │      │
    │      └─ SysConfigController.export()
    │             │
    │             └─ ExcelUtil.exportExcel()
    │
    └─ refreshCache() → GET /system/config/refreshCache
           │
           └─ SysConfigController.refreshCache()
                  │
                  └─ ISysConfigService.resetConfigCache()
                         │
                         ├─ clearConfigCache()
                         │
                         └─ loadingConfigCache()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ─────────▶ Controller ──────────────▶ JSON Response
(configName,         │                         (TableDataInfo)
 configKey,          ▼
 configType,       Service
 日付範囲)           │
                     ▼
                   Mapper ──▶ sys_config

削除ID ───────────▶ Controller ──────────────▶ AjaxResult
(ids)                │
                     ▼
                   Service
                     │
                     ├──▶ システム内置チェック
                     │
                     ├──▶ Mapper (DELETE)
                     │
                     └──▶ CacheUtils (キャッシュ削除)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | ソース | パラメータエンティティ |
| SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | ソース | コントローラー |
| ISysConfigService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysConfigService.java` | ソース | サービスインターフェース |
| SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | ソース | サービス実装 |
| SysConfigMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml` | 設定 | MyBatisマッパー |
| config.html | `ruoyi-admin/src/main/resources/templates/system/config/config.html` | テンプレート | 一覧画面HTML |
| CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/CacheUtils.java` | ソース | キャッシュユーティリティ |
