# 画面設計書 45-パラメータ新規登録

## 概要

本ドキュメントは、RuoYi後台管理システムの「パラメータ新規登録」画面の設計仕様を定義するものである。

### 本画面の処理概要

新規のシステムパラメータを登録するためのフォーム画面である。システム全体で使用する設定値を追加する機能を提供する。

**業務上の目的・背景**：システム運用中に新しい設定項目が必要になった場合に使用する画面である。例えば、新機能追加時のフラグ設定や、業務パラメータの追加などに対応できる。パラメータ鍵名（configKey）はシステム全体でユニークである必要があり、重複チェックが行われる。

**画面へのアクセス方法**：パラメータ管理一覧画面のツールバーにある「新増」ボタンを押下することでモーダルウィンドウとして表示される。

**主要な操作・処理内容**：
1. 参数名称（パラメータ説明）の入力
2. 参数鍵名（システムキー）の入力
3. 参数鍵値（設定値）の入力
4. 系統内置（システム内蔵フラグ）の選択
5. 備考の入力（任意）
6. 確定ボタンで登録実行

**画面遷移**：
- 遷移元：パラメータ管理一覧画面（モーダルとして開く）
- 遷移先：パラメータ管理一覧画面（登録成功後、モーダルを閉じて一覧を更新）

**権限による表示制御**：
- `system:config:add`権限がある場合のみ本画面にアクセス可能
- 権限がない場合、パラメータ管理一覧画面の「新増」ボタン自体が非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | パラメータ設定 | 主機能 | 新規パラメータ情報入力と登録保存処理 |

## 画面種別

登録

## URL/ルーティング

- 画面表示: `GET /system/config/add`
- 登録実行: `POST /system/config/add`
- 鍵名重複チェック: `POST /system/config/checkConfigKeyUnique`

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 初期値 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| 参数名称 | configName | text | ○ | 100 | - | パラメータの説明名 |
| 参数鍵名 | configKey | text | ○ | 100 | - | システム内で使用するキー名（ユニーク） |
| 参数鍵値 | configValue | textarea | ○ | 500 | - | 設定値 |
| 系統内置 | configType | radio | - | - | N | Y:是、N:否 |
| 備考 | remark | textarea | - | - | - | 備考欄 |

## 表示項目

なし（入力フォームのみ）

## イベント仕様

### 1-参数鍵名入力時（フォーカスアウト）

入力された鍵名の重複チェックを非同期で実行する。

- エンドポイント: `POST /system/config/checkConfigKeyUnique`
- リクエストパラメータ: configKey
- レスポンス: true（ユニーク）/ false（重複）
- 重複時: 「参数键名已经存在」エラーメッセージ表示

### 2-確定（保存）ボタン押下

入力内容をバリデーション後、データを登録する。

- バリデーション:
  - configName: 必須、100文字以内
  - configKey: 必須、100文字以内、ユニーク
  - configValue: 必須、500文字以内
- エンドポイント: `POST /system/config/add`
- リクエストパラメータ: フォーム全項目
- 成功時: モーダルを閉じ、親画面の一覧を更新
- 失敗時: エラーメッセージを表示

### 3-取消（キャンセル）ボタン押下

モーダルウィンドウを閉じ、入力内容を破棄する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 鍵名重複チェック | sys_config | SELECT | 同一configKeyの存在確認 |
| 確定ボタン押下 | sys_config | INSERT | 新規パラメータを登録 |

### テーブル別更新項目詳細

#### sys_config

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | config_id | config_key = 入力値 LIMIT 1 | 重複チェック用 |
| INSERT | config_name | 入力値 | パラメータ名称 |
| INSERT | config_key | 入力値 | パラメータ鍵名 |
| INSERT | config_value | 入力値 | パラメータ鍵値 |
| INSERT | config_type | 入力値（Y/N） | システム内置 |
| INSERT | remark | 入力値 | 備考（任意） |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 新增成功 | 登録完了時 |
| - | エラー | 参数名称不能为空 | configName未入力時 |
| - | エラー | 参数键名长度不能为空 | configKey未入力時 |
| - | エラー | 参数键值不能为空 | configValue未入力時 |
| - | エラー | 参数键名已经存在 | configKey重複時 |
| - | エラー | 新增参数'xxx'失败，参数键名已存在 | サーバーサイド重複チェック時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| バリデーションエラー | 該当項目にエラーメッセージを表示 |
| 鍵名重複 | 「参数键名已经存在」エラー表示 |
| 通信エラー | エラーメッセージ表示 |
| 権限不足 | アクセス前に制御されるため基本的に発生しない |

## 備考

- configKeyはシステム全体でユニーク制約があり、フロント・サーバー両方でチェック
- 登録成功時、該当パラメータがキャッシュに追加される（CacheUtils.put）
- configTypeを「Y」（是）にすると、削除保護対象となる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | フィールド定義、@NotBlank/@Size等のバリデーション制約 |

**読解のコツ**: configNameは100文字、configKeyも100文字、configValueは500文字の制限がバリデーション注釈で定義されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | add(), addSave(), checkConfigKeyUnique()メソッド |

**主要処理フロー**:
1. **71-76行目**: `add()`メソッド - 新規登録画面表示
2. **81-93行目**: `addSave()`メソッド - 登録処理（重複チェック含む）
3. **152-158行目**: `checkConfigKeyUnique()`メソッド - Ajax重複チェック

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | insertConfig(), checkConfigKeyUnique()メソッド |

**主要処理フロー**:
- **94-103行目**: `insertConfig()` - INSERT実行後、キャッシュ追加
- **187-197行目**: `checkConfigKeyUnique()` - 重複チェックロジック

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | add.html | `ruoyi-admin/src/main/resources/templates/system/config/add.html` | フォーム構造、jQuery Validate設定（remote） |

**主要処理フロー**:
- **8-42行目**: フォーム定義（各入力項目）
- **48-70行目**: バリデーションルール（configKey remote検証）
- **72-76行目**: submitHandler - フォーム送信処理

### プログラム呼び出し階層図

```
add.html (View)
    │
    ├─ configKey入力時 → POST /system/config/checkConfigKeyUnique
    │      │
    │      └─ SysConfigController.checkConfigKeyUnique()
    │             │
    │             └─ ISysConfigService.checkConfigKeyUnique()
    │                    │
    │                    └─ SysConfigMapper.checkConfigKeyUnique()
    │
    └─ submitHandler() → POST /system/config/add
           │
           └─ SysConfigController.addSave()
                  │
                  ├─ checkConfigKeyUnique() → 重複チェック
                  │
                  ├─ getLoginName() → createBy設定
                  │
                  └─ ISysConfigService.insertConfig()
                         │
                         ├─ SysConfigMapper.insertConfig()
                         │      │
                         │      └─ sys_config INSERT
                         │
                         └─ CacheUtils.put()
```

### データフロー図

```
[入力]               [処理]                    [出力]

configKey ─────────▶ Controller ──────────────▶ true/false
(Ajax)               │                         (重複チェック結果)
                     ▼
                   Service
                     │
                     └─▶ Mapper (SELECT)

フォーム入力 ───────▶ jQuery Validate ────────▶ バリデーションOK/NG
(configName,         │
 configKey,          ▼ OK
 configValue,      Controller
 configType,         │
 remark)             ├─ 重複チェック（再確認）
                     │
                     ├─ createBy設定
                     │
                     ▼
                   Service
                     │
                     ├─▶ Mapper (INSERT)
                     │
                     └─▶ CacheUtils (キャッシュ追加)
                           │
                           └─▶ AjaxResult (成功/失敗)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | ソース | パラメータエンティティ |
| SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | ソース | コントローラー |
| SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | ソース | サービス実装 |
| SysConfigMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml` | 設定 | INSERT文、重複チェックSQL定義 |
| add.html | `ruoyi-admin/src/main/resources/templates/system/config/add.html` | テンプレート | 新規登録フォーム |
| CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/CacheUtils.java` | ソース | キャッシュユーティリティ |
