# 画面設計書 46-パラメータ編集

## 概要

本ドキュメントは、RuoYi後台管理システムの「パラメータ編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

既存のシステムパラメータを編集・更新するためのフォーム画面である。登録済みの設定値を変更する機能を提供する。

**業務上の目的・背景**：システム運用中に設定値の変更が必要になった場合に使用する画面である。例えば、初期パスワードの変更、機能フラグのON/OFF切替、各種閾値の調整などに対応できる。鍵名を変更する場合は、システム内でその鍵名を参照している箇所への影響を考慮する必要がある。

**画面へのアクセス方法**：パラメータ管理一覧画面のツールバーにある「修改」ボタン、または各行の「編集」ボタンを押下することでモーダルウィンドウとして表示される。

**主要な操作・処理内容**：
1. 既存データの確認（画面表示時に自動読み込み）
2. 参数名称（パラメータ説明）の変更
3. 参数鍵名（システムキー）の変更
4. 参数鍵値（設定値）の変更
5. 系統内置（システム内蔵フラグ）の変更
6. 備考の変更
7. 確定ボタンで更新実行

**画面遷移**：
- 遷移元：パラメータ管理一覧画面（モーダルとして開く）
- 遷移先：パラメータ管理一覧画面（更新成功後、モーダルを閉じて一覧を更新）

**権限による表示制御**：
- `system:config:edit`権限がある場合のみ本画面にアクセス可能
- 権限がない場合、パラメータ管理一覧画面の「修改」ボタンおよび行内「編集」ボタンが非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | パラメータ設定 | 主機能 | パラメータ情報の更新保存処理 |

## 画面種別

編集

## URL/ルーティング

- 画面表示: `GET /system/config/edit/{configId}`
- 更新実行: `POST /system/config/edit`
- 鍵名重複チェック: `POST /system/config/checkConfigKeyUnique`

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 初期値 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| 参数主鍵 | configId | hidden | ○ | - | DBから取得 | 主キー（非表示） |
| 参数名称 | configName | text | ○ | 100 | DBから取得 | パラメータの説明名 |
| 参数鍵名 | configKey | text | ○ | 100 | DBから取得 | システム内で使用するキー名（ユニーク） |
| 参数鍵値 | configValue | textarea | ○ | 500 | DBから取得 | 設定値 |
| 系統内置 | configType | radio | - | - | DBから取得 | Y:是、N:否 |
| 備考 | remark | textarea | - | - | DBから取得 | 備考欄 |

## 表示項目

なし（入力フォームのみ）

## イベント仕様

### 1-画面表示時

URLパラメータのconfigIdを元にデータを取得し、フォームに初期表示する。

- エンドポイント: `GET /system/config/edit/{configId}`
- レスポンス: editビュー + パラメータモデル

### 2-参数鍵名入力時（フォーカスアウト）

入力された鍵名の重複チェックを非同期で実行する。

- エンドポイント: `POST /system/config/checkConfigKeyUnique`
- リクエストパラメータ: configId, configKey
- レスポンス: true（ユニーク）/ false（重複）
- 重複時: 「参数键名已经存在」エラーメッセージ表示
- 自分自身のレコードは重複とみなさない

### 3-確定（保存）ボタン押下

入力内容をバリデーション後、データを更新する。

- バリデーション:
  - configName: 必須、100文字以内
  - configKey: 必須、100文字以内、ユニーク（自分自身除く）
  - configValue: 必須、500文字以内
- エンドポイント: `POST /system/config/edit`
- リクエストパラメータ: フォーム全項目（configId含む）
- 成功時: モーダルを閉じ、親画面の一覧を更新
- 失敗時: エラーメッセージを表示

### 4-取消（キャンセル）ボタン押下

モーダルウィンドウを閉じ、変更内容を破棄する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | sys_config | SELECT | configIdに該当するデータを取得 |
| 鍵名重複チェック | sys_config | SELECT | 同一configKeyの存在確認（自分除く） |
| 確定ボタン押下 | sys_config | UPDATE | パラメータを更新 |

### テーブル別更新項目詳細

#### sys_config

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | config_id = パラメータ値 | 初期表示用 |
| SELECT | config_id | config_key = 入力値 LIMIT 1 | 重複チェック用 |
| UPDATE | config_name | 入力値 | パラメータ名称 |
| UPDATE | config_key | 入力値 | パラメータ鍵名 |
| UPDATE | config_value | 入力値 | パラメータ鍵値 |
| UPDATE | config_type | 入力値（Y/N） | システム内置 |
| UPDATE | remark | 入力値 | 備考 |
| UPDATE | update_by | ログインユーザー名 | 更新者 |
| UPDATE | update_time | sysdate() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 修改成功 | 更新完了時 |
| - | エラー | 参数名称不能为空 | configName未入力時 |
| - | エラー | 参数键名长度不能为空 | configKey未入力時 |
| - | エラー | 参数键值不能为空 | configValue未入力時 |
| - | エラー | 参数键名已经存在 | configKey重複時 |
| - | エラー | 修改参数'xxx'失败，参数键名已存在 | サーバーサイド重複チェック時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| データ取得エラー | エラーページを表示 |
| バリデーションエラー | 該当項目にエラーメッセージを表示 |
| 鍵名重複 | 「参数键名已经存在」エラー表示 |
| 対象データなし | エラーメッセージを表示 |
| 通信エラー | エラーメッセージ表示 |
| 権限不足 | アクセス前に制御されるため基本的に発生しない |

## 備考

- configKeyを変更した場合、旧キーのキャッシュは削除され、新キーでキャッシュが登録される
- 更新成功時、該当パラメータのキャッシュが更新される（CacheUtils.put）
- configTypeを「N」から「Y」に変更すると、以降削除保護対象となる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | フィールド定義、バリデーション制約 |

**読解のコツ**: 編集画面ではth:field属性でエンティティのプロパティとバインドされる点に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | edit(), editSave(), checkConfigKeyUnique()メソッド |

**主要処理フロー**:
1. **98-104行目**: `edit()`メソッド - 編集画面表示、configIdでデータ取得
2. **109-121行目**: `editSave()`メソッド - 更新処理（重複チェック含む）
3. **152-158行目**: `checkConfigKeyUnique()`メソッド - Ajax重複チェック

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | selectConfigById(), updateConfig(), checkConfigKeyUnique()メソッド |

**主要処理フロー**:
- **44-49行目**: `selectConfigById()` - 主キー検索
- **111-126行目**: `updateConfig()` - 旧キー削除、UPDATE実行、新キーキャッシュ登録
- **187-197行目**: `checkConfigKeyUnique()` - 重複チェック（自分除外）

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.html | `ruoyi-admin/src/main/resources/templates/system/config/edit.html` | Thymeleafバインディング、jQuery Validate設定（remote） |

**主要処理フロー**:
- **8行目**: th:objectでエンティティバインド
- **9行目**: hiddenフィールドでconfigId保持
- **49-74行目**: バリデーションルール（configKey remote検証、configId送信）
- **76-80行目**: submitHandler - フォーム送信処理

### プログラム呼び出し階層図

```
edit.html (View)
    │
    ├─ 画面表示時 ← GET /system/config/edit/{configId}
    │      │
    │      └─ SysConfigController.edit()
    │             │
    │             └─ ISysConfigService.selectConfigById()
    │                    │
    │                    └─ SysConfigMapper.selectConfigById()
    │
    ├─ configKey入力時 → POST /system/config/checkConfigKeyUnique
    │      │
    │      └─ SysConfigController.checkConfigKeyUnique()
    │             │
    │             └─ ISysConfigService.checkConfigKeyUnique()
    │                    │    （configIdで自分自身を除外）
    │                    │
    │                    └─ SysConfigMapper.checkConfigKeyUnique()
    │
    └─ submitHandler() → POST /system/config/edit
           │
           └─ SysConfigController.editSave()
                  │
                  ├─ checkConfigKeyUnique() → 重複チェック
                  │
                  ├─ getLoginName() → updateBy設定
                  │
                  └─ ISysConfigService.updateConfig()
                         │
                         ├─ 旧キーと新キー比較
                         │    └─ 異なる場合: CacheUtils.remove(旧キー)
                         │
                         ├─ SysConfigMapper.updateConfig()
                         │      │
                         │      └─ sys_config UPDATE
                         │
                         └─ CacheUtils.put(新キー)
```

### データフロー図

```
[入力]               [処理]                    [出力]

configId ─────────▶ Controller ──────────────▶ edit.html
(PathVariable)       │                         (初期値設定済フォーム)
                     ▼
                   Service
                     │
                     └─▶ Mapper (SELECT)

configKey ─────────▶ Controller ──────────────▶ true/false
configId             │                         (重複チェック結果)
(Ajax)               ▼
                   Service
                     │
                     └─▶ Mapper (SELECT + 自分除外)

フォーム入力 ───────▶ jQuery Validate ────────▶ バリデーションOK/NG
(configId,           │
 configName,         ▼ OK
 configKey,        Controller
 configValue,        │
 configType,         ├─ 重複チェック（再確認）
 remark)             │
                     ├─ updateBy設定
                     │
                     ▼
                   Service
                     │
                     ├─▶ キー変更判定 → CacheUtils.remove(旧)
                     │
                     ├─▶ Mapper (UPDATE)
                     │
                     └─▶ CacheUtils.put(新)
                           │
                           └─▶ AjaxResult (成功/失敗)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | ソース | パラメータエンティティ |
| SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | ソース | コントローラー |
| SysConfigServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java` | ソース | サービス実装 |
| SysConfigMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml` | 設定 | SELECT/UPDATE文定義 |
| edit.html | `ruoyi-admin/src/main/resources/templates/system/config/edit.html` | テンプレート | 編集フォーム |
| CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/CacheUtils.java` | ソース | キャッシュユーティリティ |
