# 画面設計書 47-通知公告管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムの「通知公告管理一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

システム内の通知・公告の一覧表示・管理を行う画面である。管理者が全ユーザー向けの通知や公告を作成・管理するための機能を提供する。

**業務上の目的・背景**：組織内での情報共有を目的とした通知・公告管理機能の中核となる画面である。「通知」はシステム運用に関する連絡事項、「公告」は業務に関する公式な告知を想定している。リッチテキスト形式で内容を作成でき、画像の埋め込みにも対応しているため、視覚的にわかりやすい情報発信が可能である。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム管理」→「通知公告」を選択する。

**主要な操作・処理内容**：
1. 通知・公告の検索（公告標題、操作人員、公告類型による絞り込み）
2. 通知・公告の新規登録（新増ボタン押下）- フルスクリーンモーダル
3. 通知・公告の編集（修改ボタン押下）- フルスクリーンモーダル
4. 通知・公告の詳細表示（標題クリック）
5. 通知・公告の削除（削除ボタン押下、複数選択一括削除対応）

**画面遷移**：
- 遷移元：システム首頁（メニュー）
- 遷移先：通知公告新規登録画面、通知公告編集画面、通知公告表示画面

**権限による表示制御**：
- `system:notice:add`権限がない場合、「新増」ボタンは非表示
- `system:notice:edit`権限がない場合、「修改」ボタンおよび行内「編集」ボタンは非表示
- `system:notice:remove`権限がない場合、「削除」ボタンおよび行内「削除」ボタンは非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | 通知公告 | 主機能 | 通知・公告一覧の検索、表示処理 |

## 画面種別

一覧

## URL/ルーティング

- 画面表示: `GET /system/notice`
- 一覧取得: `POST /system/notice/list`
- データ削除: `POST /system/notice/remove`

## 入出力項目

### 検索条件（入力）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 公告標題 | noticeTitle | text | - | 部分一致検索 |
| 操作人員 | createBy | text | - | 作成者名（部分一致検索） |
| 公告類型 | noticeType | select | - | 1:通知、2:公告 |

## 表示項目

### 一覧テーブル

| 項目名 | 項目ID | 型 | ソート | 説明 |
|--------|--------|-----|--------|------|
| （チェックボックス） | - | checkbox | - | 複数選択用 |
| 序号 | noticeId | number | - | 通知・公告ID（主キー） |
| 公告標題 | noticeTitle | link | - | クリックで詳細画面へ遷移 |
| 公告類型 | noticeType | string | - | 1:通知、2:公告（辞書変換表示） |
| 状態 | status | string | - | 0:正常、1:関閉（辞書変換表示） |
| 創建者 | createBy | string | - | 作成者名 |
| 創建時間 | createTime | datetime | 可 | レコード作成日時 |
| 操作 | - | button | - | 編集・削除ボタン |

## イベント仕様

### 1-検索ボタン押下

検索条件を元にデータを再取得し、一覧テーブルを更新する。

- エンドポイント: `POST /system/notice/list`
- リクエストパラメータ: noticeTitle, createBy, noticeType, ページング情報
- レスポンス: TableDataInfo（total, rows）

### 2-重置（リセット）ボタン押下

全ての検索条件をクリアする。

### 3-新増ボタン押下

通知公告新規登録画面をフルスクリーンモーダルで開く。

- 遷移先URL: `/system/notice/add`
- フルスクリーン表示（$.operate.addFull()）

### 4-修改ボタン押下

選択されたデータの編集画面をフルスクリーンモーダルで開く。

- 遷移先URL: `/system/notice/edit/{noticeId}`
- 単一選択必須
- フルスクリーン表示（$.operate.editFull()）

### 5-削除ボタン押下

選択されたデータを一括削除する。

- 確認ダイアログ表示後、`POST /system/notice/remove`を実行
- パラメータ: ids（カンマ区切りのnoticeId）

### 6-公告標題クリック

該当通知・公告の詳細表示画面を開く。

- 遷移先URL: `/system/notice/view/{noticeId}`
- $.operate.view()で表示

### 7-行内編集ボタン押下

該当行のデータを編集画面で開く（4-修改ボタンと同様）。

### 8-行内削除ボタン押下

該当行のデータを単独削除する（確認ダイアログあり）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索ボタン押下 | sys_notice | SELECT | 条件に一致する通知・公告を取得 |
| 削除ボタン押下 | sys_notice | DELETE | 選択された通知・公告を削除 |

### テーブル別更新項目詳細

#### sys_notice

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | notice_id, notice_title, notice_type, notice_content, status, create_by, create_time, update_by, update_time, remark | noticeTitle（LIKE）、createBy（LIKE）、noticeType | 検索条件による |
| DELETE | - | notice_id IN (選択されたID) | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 確認 | 是否确认删除公告编号为"xxx"的数据项? | 削除実行前 |
| - | 成功 | 删除成功 | 削除完了時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| データ取得エラー | エラーメッセージを表示し、一覧は空で表示 |
| 削除対象なし | 「请先选择要删除的数据」メッセージ表示 |
| 権限不足 | ボタンは非表示のため基本的に発生しない |
| 通信エラー | エラーメッセージ表示 |

## 備考

- 新規登録・編集画面はフルスクリーンモーダル（$.operate.addFull/editFull）で開く
- これはリッチテキストエディタ（Summernote）を使用するため、十分な編集スペースを確保するため
- notice_contentはBLOB型で格納されるため、SELECT時にcast(notice_content as char)で変換

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | 通知・公告エンティティのフィールド定義、バリデーション制約 |
| 1-2 | SysNoticeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml` | テーブルカラムとエンティティのマッピング、SQL定義 |

**読解のコツ**: noticeTitleには@Xss注釈が付いており、XSS攻撃対策が施されている点に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | 各エンドポイントのマッピングと権限制御 |

**主要処理フロー**:
1. **36-41行目**: `notice()`メソッド - 画面表示のエントリーポイント
2. **46-54行目**: `list()`メソッド - 一覧データ取得API
3. **103-108行目**: `view()`メソッド - 詳細表示
4. **114-124行目**: `remove()`メソッド - データ削除処理

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysNoticeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysNoticeService.java` | サービスインターフェース定義 |
| 3-2 | SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | サービス実装 |

**主要処理フロー**:
- **40-45行目**: `selectNoticeList()` - 一覧検索
- **77-81行目**: `deleteNoticeByIds()` - 削除処理

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | notice.html | `ruoyi-admin/src/main/resources/templates/system/notice/notice.html` | Thymeleafテンプレート、Bootstrap Table設定、Full Modal |

**主要処理フロー**:
- **10-31行目**: 検索フォーム定義
- **34-44行目**: ツールバーボタン（addFull/editFull使用）
- **59-118行目**: Bootstrap Table初期化、カラム定義

### プログラム呼び出し階層図

```
notice.html (View)
    │
    ├─ $.table.init() → POST /system/notice/list
    │      │
    │      └─ SysNoticeController.list()
    │             │
    │             └─ ISysNoticeService.selectNoticeList()
    │                    │
    │                    └─ SysNoticeMapper.selectNoticeList()
    │
    ├─ $.operate.view() → GET /system/notice/view/{noticeId}
    │      │
    │      └─ SysNoticeController.view()
    │             │
    │             └─ ISysNoticeService.selectNoticeById()
    │
    └─ $.operate.removeAll() → POST /system/notice/remove
           │
           └─ SysNoticeController.remove()
                  │
                  └─ ISysNoticeService.deleteNoticeByIds()
                         │
                         └─ SysNoticeMapper.deleteNoticeByIds()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ─────────▶ Controller ──────────────▶ JSON Response
(noticeTitle,        │                         (TableDataInfo)
 createBy,           ▼
 noticeType)       Service
                     │
                     ▼
                   Mapper ──▶ sys_notice
                              (CAST notice_content)

削除ID ───────────▶ Controller ──────────────▶ AjaxResult
(ids)                │
                     ▼
                   Service
                     │
                     └──▶ Mapper (DELETE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | ソース | 通知・公告エンティティ |
| SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | ソース | コントローラー |
| ISysNoticeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysNoticeService.java` | ソース | サービスインターフェース |
| SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | ソース | サービス実装 |
| SysNoticeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml` | 設定 | MyBatisマッパー |
| notice.html | `ruoyi-admin/src/main/resources/templates/system/notice/notice.html` | テンプレート | 一覧画面HTML |
