# 画面設計書 48-通知公告新規登録

## 概要

本ドキュメントは、RuoYi後台管理システムの「通知公告新規登録」画面の設計仕様を定義するものである。

### 本画面の処理概要

新規の通知・公告を登録するためのフォーム画面である。リッチテキストエディタ（Summernote）を使用して、書式付きのコンテンツや画像を含む通知・公告を作成できる。

**業務上の目的・背景**：管理者が全ユーザー向けの通知や公告を作成するための画面である。Summernoteエディタにより、テキストの書式設定（太字、色、フォントサイズ等）や画像の挿入が可能で、視覚的にわかりやすい情報発信ができる。作成した通知・公告は「通知」または「公告」のタイプと、「正常」または「関閉」の状態を設定できる。

**画面へのアクセス方法**：通知公告管理一覧画面のツールバーにある「新増」ボタンを押下することでフルスクリーンモーダルとして表示される。

**主要な操作・処理内容**：
1. 公告標題（タイトル）の入力
2. 公告類型（通知/公告）の選択
3. 公告内容のリッチテキスト編集
4. 公告状態（正常/関閉）の選択
5. 確定ボタンで登録実行

**画面遷移**：
- 遷移元：通知公告管理一覧画面（フルスクリーンモーダルとして開く）
- 遷移先：通知公告管理一覧画面（登録成功後、モーダルを閉じて一覧を更新）

**権限による表示制御**：
- `system:notice:add`権限がある場合のみ本画面にアクセス可能
- 権限がない場合、通知公告管理一覧画面の「新増」ボタン自体が非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | 通知公告 | 主機能 | 新規通知情報入力と登録保存処理 |

## 画面種別

登録

## URL/ルーティング

- 画面表示: `GET /system/notice/add`
- 登録実行: `POST /system/notice/add`
- 画像アップロード: `POST /common/upload`

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 初期値 | 説明 |
|--------|--------|-----|------|--------|--------|------|
| 公告標題 | noticeTitle | text | ○ | 50 | - | 通知・公告のタイトル |
| 公告類型 | noticeType | select | - | - | 最初の選択肢 | 1:通知、2:公告 |
| 公告内容 | noticeContent | hidden+editor | - | - | - | Summernoteエディタで編集 |
| 公告状態 | status | radio | - | - | 0 | 0:正常、1:関閉 |

### 公告類型の選択肢

| 値 | 表示名 | 説明 |
|----|--------|------|
| 1 | 通知 | システム運用に関する連絡事項 |
| 2 | 公告 | 業務に関する公式な告知 |

### 公告状態の選択肢

| 値 | 表示名 | 説明 |
|----|--------|------|
| 0 | 正常 | 有効な通知・公告 |
| 1 | 関閉 | 無効化された通知・公告 |

## 表示項目

なし（入力フォームのみ）

## イベント仕様

### 1-画像アップロード（Summernote内）

Summernoteエディタで画像を挿入する際に実行される。

- エンドポイント: `POST /common/upload`
- リクエスト: FormData（file）
- レスポンス: {code, url, fileName}
- 成功時: エディタに画像を挿入
- 失敗時: 「图片上传失败」警告表示

### 2-確定（保存）ボタン押下

入力内容をバリデーション後、データを登録する。

- バリデーション:
  - noticeTitle: 必須、50文字以内、XSSチェック
- 処理フロー:
  1. Summernoteの内容をhiddenフィールドに設定
  2. フォームをシリアライズして送信
- エンドポイント: `POST /system/notice/add`
- リクエストパラメータ: フォーム全項目
- 成功時: モーダルを閉じ、親画面の一覧を更新
- 失敗時: エラーメッセージを表示

### 3-取消（キャンセル）ボタン押下

モーダルウィンドウを閉じ、入力内容を破棄する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確定ボタン押下 | sys_notice | INSERT | 新規通知・公告を登録 |

### テーブル別更新項目詳細

#### sys_notice

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | notice_title | 入力値 | 公告標題 |
| INSERT | notice_type | 入力値（1/2） | 公告類型 |
| INSERT | notice_content | 入力値（HTML） | リッチテキスト内容 |
| INSERT | status | 入力値（0/1） | 公告状態 |
| INSERT | remark | 入力値 | 備考（任意） |
| INSERT | create_by | ログインユーザー名 | 作成者 |
| INSERT | create_time | sysdate() | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 新增成功 | 登録完了時 |
| - | エラー | 公告标题不能为空 | noticeTitle未入力時 |
| - | エラー | 公告标题不能超过50个字符 | noticeTitle50文字超過時 |
| - | エラー | 公告标题不能包含脚本字符 | XSS検出時 |
| - | 警告 | 图片上传失败。 | 画像アップロード失敗時 |
| - | エラー | 操作失败 | 処理失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| バリデーションエラー | 該当項目にエラーメッセージを表示 |
| 画像アップロードエラー | 警告メッセージ表示、エディタへの挿入は行わない |
| XSSコンテンツ検出 | エラーメッセージを表示、登録を中止 |
| 通信エラー | エラーメッセージ表示 |
| 権限不足 | アクセス前に制御されるため基本的に発生しない |

## 備考

- Summernoteエディタはフルスクリーンモーダル内で十分な編集スペースを確保
- 公告内容はHTML形式で保存され、表示時はth:utext属性でHTMLとしてレンダリング
- 画像アップロードは共通エンドポイント（/common/upload）を使用
- XSS対策として、noticeTitleには@Xss注釈が付与されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | フィールド定義、@Xss/@NotBlank/@Size等のバリデーション制約 |

**読解のコツ**: noticeTitleの@Xss注釈はスクリプト文字を含む入力をブロックするカスタムバリデーション。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | add(), addSave()メソッド |

**主要処理フロー**:
1. **59-63行目**: `add()`メソッド - 新規登録画面表示
2. **69-77行目**: `addSave()`メソッド - 登録処理実行、createByを設定

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | insertNotice()メソッド |

**主要処理フロー**:
- **54-57行目**: `insertNotice()` - Mapper呼び出し

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造と動作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | add.html | `ruoyi-admin/src/main/resources/templates/system/notice/add.html` | Summernote初期化、画像アップロード処理 |

**主要処理フロー**:
- **5行目**: Summernote CSS読み込み
- **9-40行目**: フォーム定義
- **43行目**: Summernote JS読み込み
- **47-58行目**: Summernote初期化（画像アップロードコールバック）
- **61-83行目**: sendFile() - 画像アップロード処理
- **89-95行目**: submitHandler - 内容取得してフォーム送信

### プログラム呼び出し階層図

```
add.html (View)
    │
    ├─ Summernote onImageUpload → POST /common/upload
    │      │
    │      └─ CommonController.uploadFile()
    │             │
    │             └─ ファイル保存
    │                    │
    │                    └─ {code, url, fileName}
    │
    └─ submitHandler() → POST /system/notice/add
           │
           ├─ summernote('code') → noticeContent設定
           │
           └─ SysNoticeController.addSave()
                  │
                  ├─ getLoginName() → createBy設定
                  │
                  └─ ISysNoticeService.insertNotice()
                         │
                         └─ SysNoticeMapper.insertNotice()
                                │
                                └─ sys_notice INSERT
```

### データフロー図

```
[入力]               [処理]                    [出力]

画像ファイル ───────▶ FormData ────────────────▶ 画像URL
(Summernote)         │                         (エディタに挿入)
                     ▼
                   /common/upload

フォーム入力 ───────▶ jQuery Validate ────────▶ バリデーションOK/NG
(noticeTitle,        │
 noticeType,         ▼ OK
 noticeContent,    summernote('code')
 status)             │
                     ▼
                   hiddenフィールド設定
                     │
                     ▼
                   Controller
                     │
                     ├─ createBy設定
                     │
                     ▼
                   Service
                     │
                     └─▶ Mapper (INSERT)
                           │
                           └─▶ AjaxResult (成功/失敗)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | ソース | 通知・公告エンティティ |
| SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | ソース | コントローラー |
| SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | ソース | サービス実装 |
| SysNoticeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml` | 設定 | INSERT文定義 |
| add.html | `ruoyi-admin/src/main/resources/templates/system/notice/add.html` | テンプレート | 新規登録フォーム |
| CommonController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/common/CommonController.java` | ソース | 画像アップロード |
| Xss.java | `ruoyi-common/src/main/java/com/ruoyi/common/xss/Xss.java` | ソース | XSSバリデーション注釈 |
