# 画面設計書 5-システム首頁（トップナビ型）

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「システム首頁（トップナビ型）」の設計仕様を定義する。

### 本画面の処理概要

ログイン後のメイン画面であり、上部に横型ナビゲーションメニュー、左側にサブメニュー、右側にiframe形式のコンテンツ領域を持つレイアウト構成。No.4「システム首頁」の横型メニューバージョン。

**業務上の目的・背景**：左側サイドバー型のメニューに加え、横型ナビゲーションを好むユーザー向けの代替レイアウトを提供する。トップナビ型では、第1階層のメニューが上部に水平表示され、選択した項目に応じて左側にサブメニューが表示される。ワイドスクリーンディスプレイでより多くのコンテンツ領域を確保したい場合や、メニュー項目が多い場合に有効。

**画面へのアクセス方法**：システム首頁のユーザードロップダウンメニューから「横向菜单」を選択するか、Cookie設定でnav-style=topnavが保存されている場合に自動的にこのレイアウトが適用される。

**主要な操作・処理内容**：
1. トップナビゲーションバーからの第1階層メニュー選択
2. 選択に応じた左側サブメニューの表示切替
3. サブメニューからの各機能画面への遷移
4. タブによる複数画面の同時表示・切り替え
5. ユーザーアバタークリックによるドロップダウンメニュー表示
6. 左側メニュー型への切り替え

**画面遷移**：
- 遷移元：ログイン画面（認証成功時）、システム首頁からの切替
- 遷移先：各管理機能画面（iframeで表示）、ログイン画面（ログアウト時）

**権限による表示制御**：メニュー表示はNo.4「システム首頁」と同様に、ユーザーのロールに基づいて動的に生成される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログイン | API連携 | ログイン状態確認とセッション管理 |

## 画面種別

フレーム（メイン）

## URL/ルーティング

- GET `/index` - システム首頁の表示（Cookie/設定によりトップナビ型を選択）
- GET `/system/main` - メインコンテンツ（デフォルト）の表示
- GET `/logout` - ログアウト処理
- GET `/system/menuStyle/default` - 左側メニュー型に切替

## 入出力項目

本画面は入力項目を持たない（表示専用フレーム）。

## 表示項目

| 項目名 | 説明 |
|--------|------|
| システムロゴ | 「RuoYi」ロゴ |
| トップナビゲーション | 第1階層メニューの水平表示 |
| 左側サブメニュー | 選択された第1階層に対応するサブメニュー |
| ユーザーアバター | ログインユーザーのプロフィール画像 |
| ユーザー名 | ログインユーザーのloginName |
| タブバー | 開いている画面のタブ一覧 |
| コンテンツiframe | 選択された機能画面を表示 |
| ヘッダーツールバー | 文档・锁屏・全屏アイコン |

## イベント仕様

### 1-トップナビゲーションクリック

1. 第1階層メニュー項目をクリック
2. 対応する左側サブメニューパネルをアクティブ化（tab-content切替）
3. 子メニューがある場合はサブメニューを表示
4. 子メニューがない場合は直接コンテンツをiframeで表示

### 2-サブメニュークリック

1. 該当するURLのコンテンツをiframeで表示
2. タブバーに新しいタブを追加
3. メニュー項目をハイライト表示

### 3-左側メニュー型への切替

1. ユーザードロップダウンから「左側菜单」を選択
2. 確認ダイアログを表示
3. 確認後、GET `/system/menuStyle/default` を呼び出し
4. Cookie nav-style を 'default' に設定
5. 画面をリロード

### 4-その他のイベント

- タブ操作、ドロップダウンメニュー、画面ロック、全画面表示等はNo.4「システム首頁」と同様

## データベース更新仕様

No.4「システム首頁」と同様。本画面自体はデータベースを更新しない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 確認 | 确认要切换成左侧菜单吗？ | 左側メニュー切替選択時 |

## 例外処理

No.4「システム首頁」と同様。

## 備考

- 第1階層メニューがトップナビゲーションとして水平表示される
- 左側のサブメニューはタブコンテンツとして管理される（Bootstrap tab-content）
- resize-tabs.jsによりナビゲーションタブの幅が自動調整される
- 「統計報表」「実例演示」タブが固定で表示される（設定による）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

No.4「システム首頁」と同様。SysMenuの階層構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysMenu.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java` | メニューエンティティ |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | メニュースタイル判定ロジック |

**主要処理フロー**:
1. **85行目**: webIndex = "topnav".equalsIgnoreCase(indexStyle) ? "index-topnav" : "index"

#### Step 3: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index-topnav.html | `ruoyi-admin/src/main/resources/templates/index-topnav.html` | トップナビ型レイアウト |
| 3-2 | resize-tabs.js | `ruoyi-admin/src/main/resources/static/js/resize-tabs.js` | タブ幅自動調整 |

**主要処理フロー**:
- **index-topnav.html 49-80行目**: 左側サブメニュー（tab-pane）の定義
- **index-topnav.html 222-248行目**: トップナビゲーションの定義

### プログラム呼び出し階層図

```
Browser: GET /index
    │
    └─ SysIndexController.index()
           │
           ├─ Cookie "nav-style" チェック
           │
           ├─ "topnav" の場合
           │      │
           │      └─ return "index-topnav"
           │
           └─ それ以外
                  │
                  └─ return "index"
```

### データフロー図

```
[入力]               [処理]                    [出力]

Cookie(nav-style) ──▶ SysIndexController ──▶ index-topnav.html
                           │
Session(User) ─────────────┤
                           │
sys_menu ──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index-topnav.html | `ruoyi-admin/src/main/resources/templates/index-topnav.html` | テンプレート | トップナビ型レイアウト |
| resize-tabs.js | `ruoyi-admin/src/main/resources/static/js/resize-tabs.js` | JavaScript | タブ幅自動調整 |
| index.js | `ruoyi-admin/src/main/resources/static/ruoyi/index.js` | JavaScript | 共通タブ管理 |
| SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | コントローラー | メニュースタイル判定 |
| skins.css | `ruoyi-admin/src/main/resources/static/css/skins.css` | スタイル | トップナビ用スタイル |
