# 画面設計書 50-通知公告表示

## 概要

本ドキュメントは、RuoYi後台管理システムの「通知公告表示」画面の設計仕様を定義するものである。

### 本画面の処理概要

通知・公告の詳細内容を表示するための参照専用画面である。リッチテキスト形式で作成された公告内容をHTMLとしてレンダリングして表示する。

**業務上の目的・背景**：ユーザーが通知・公告の全文を確認するための画面である。一覧画面では標題のみ表示されるため、詳細内容を確認する際にこの画面を使用する。書式付きのテキストや画像を含む内容が、作成時のレイアウトで表示される。

**画面へのアクセス方法**：通知公告管理一覧画面で、公告標題のリンクをクリックすることで表示される。

**主要な操作・処理内容**：
1. 通知・公告の詳細内容表示（参照のみ）
2. 標題、発件人、発送時間、本文の確認

**画面遷移**：
- 遷移元：通知公告管理一覧画面
- 遷移先：なし（参照専用、閉じるのみ）

**権限による表示制御**：
- `system:notice:list`権限がある場合にアクセス可能
- 基本的に一覧が閲覧できるユーザーは詳細も閲覧可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | 通知公告 | 主機能 | 通知・公告の詳細表示処理 |

## 画面種別

詳細

## URL/ルーティング

- 画面表示: `GET /system/notice/view/{noticeId}`

## 入出力項目

なし（参照専用のため入力項目なし）

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 公告標題 | noticeTitle | string | 中央揃えで大きく表示 |
| 発件人 | createBy | string | 左側に表示 |
| 発送時間 | createTime | datetime | 右側に表示（yyyy-MM-dd HH:mm:ss形式） |
| 公告内容 | noticeContent | html | HTMLとしてレンダリング表示 |

## イベント仕様

### 1-画面表示時

URLパラメータのnoticeIdを元にデータを取得し、画面に表示する。

- エンドポイント: `GET /system/notice/view/{noticeId}`
- レスポンス: viewビュー + 通知・公告モデル
- 公告内容はth:utextでHTMLとしてレンダリング

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | sys_notice | SELECT | noticeIdに該当するデータを取得 |

### テーブル別更新項目詳細

#### sys_notice

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | notice_id, notice_title, notice_type, notice_content, status, create_by, create_time, update_by, update_time, remark | notice_id = パラメータ値 | CAST(notice_content as char) |

## メッセージ仕様

なし（参照専用画面のため）

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| データ取得エラー | エラーページを表示 |
| 対象データなし | エラーメッセージを表示 |
| 権限不足 | アクセス前に制御されるため基本的に発生しない |

## 備考

- 公告内容はBLOB型で格納されており、SELECT時にCAST変換される
- th:utextでHTMLとしてレンダリングするため、Summernoteで作成した書式がそのまま表示される
- シンプルなメールボックス風のレイアウトで表示
- フッターのみ読み込み（フォーム入力がないためバリデーション不要）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | フィールド定義 |

**読解のコツ**: 表示のみのため、バリデーション制約は関係しないが、フィールドの用途を理解しておく。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | view()メソッド |

**主要処理フロー**:
1. **103-112行目**: `view()`メソッド - 詳細表示画面、noticeIdでデータ取得

#### Step 3: サービス層を理解する

ビジネスロジックの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | selectNoticeById()メソッド |

**主要処理フロー**:
- **29-33行目**: `selectNoticeById()` - 主キー検索

#### Step 4: テンプレート（View）を理解する

フロントエンドの構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | view.html | `ruoyi-admin/src/main/resources/templates/system/notice/view.html` | レイアウト構造、th:utext使用 |

**主要処理フロー**:
- **12行目**: タイトル表示（中央揃え）
- **14-15行目**: 発件人・発送時間表示
- **20行目**: 公告内容（th:utextでHTML表示）

### プログラム呼び出し階層図

```
view.html (View)
    │
    └─ 画面表示時 ← GET /system/notice/view/{noticeId}
           │
           └─ SysNoticeController.view()
                  │
                  └─ ISysNoticeService.selectNoticeById()
                         │
                         └─ SysNoticeMapper.selectNoticeById()
                                │
                                └─ sys_notice SELECT
                                       │
                                       └─ CAST(notice_content as char)
```

### データフロー図

```
[入力]               [処理]                    [出力]

noticeId ─────────▶ Controller ──────────────▶ view.html
(PathVariable)       │
                     ▼
                   Service
                     │
                     ▼
                   Mapper ──▶ sys_notice
                              │
                              ▼
                            CAST変換
                              │
                              ▼
                         SysNotice Entity
                              │
                              ▼
                         view.html
                              │
                              ├─▶ noticeTitle (h3)
                              ├─▶ createBy / createTime (h5)
                              └─▶ noticeContent (th:utext)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | ソース | 通知・公告エンティティ |
| SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | ソース | コントローラー |
| SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | ソース | サービス実装 |
| SysNoticeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml` | 設定 | SELECT文定義 |
| view.html | `ruoyi-admin/src/main/resources/templates/system/notice/view.html` | テンプレート | 詳細表示画面 |
