# 画面設計書 51-オンラインユーザー一覧

## 概要

本ドキュメントは、RuoYi後台管理システムのオンラインユーザー一覧画面の設計仕様を記述したものである。

### 本画面の処理概要

オンラインユーザー一覧画面は、システムに現在ログインしているユーザーのセッション情報を一覧表示し、管理者が不正アクセスや長時間放置されたセッションを監視・管理するための画面である。

**業務上の目的・背景**：システム運用においてセキュリティ監視は重要な業務である。不正なログインや、同一アカウントでの多重ログイン、長時間アイドル状態のセッションなどを検知し、必要に応じて強制ログアウト（強退）を実行することで、システムのセキュリティを維持する。また、現在のシステム利用状況を把握するためのダッシュボードとしても機能する。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム監視」→「オンラインユーザー」を選択することでアクセスできる。アクセスには`monitor:online:view`権限が必要である。

**主要な操作・処理内容**：
1. オンラインユーザー一覧の表示と検索（IPアドレス、ログイン名称での絞り込み）
2. ユーザーセッション情報の確認（会話編号、部門名称、ブラウザ、OS、ログイン時間など）
3. 単一ユーザーの強制ログアウト（強退）
4. 複数ユーザーの一括強制ログアウト
5. ユーザー一覧のExcelエクスポート

**画面遷移**：本画面は一覧形式のため、詳細画面への遷移は存在しない。システム首頁から遷移し、処理完了後は同画面に留まる。

**権限による表示制御**：`monitor:online:forceLogout`権限がない場合、個別の強退ボタンは非表示となる。`monitor:online:batchForceLogout`権限がない場合、一括強退ボタンは非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | オンラインユーザー | 主機能 | オンラインユーザー一覧表示と強制ログアウト処理 |

## 画面種別

一覧

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/online |
| 一覧データ取得 | POST | /monitor/online/list |
| 強制ログアウト | POST | /monitor/online/batchForceLogout |
| Excelエクスポート | POST | /monitor/online/export |

## 入出力項目

### 検索条件（入力項目）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 登録地址 | ipaddr | String | 任意 | IPアドレスの部分一致検索 |
| 登録名称 | loginName | String | 任意 | ログイン名の部分一致検索 |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 説明 |
|--------|--------|----------|--------|------|
| 選択チェックボックス | - | - | - | 一括操作用 |
| 序号 | - | Number | - | 表示番号（自動採番） |
| 会話編号 | sessionId | String | - | セッションID（ツールチップ表示） |
| 登録名称 | loginName | String | 可 | ユーザーログイン名 |
| 部門名称 | deptName | String | - | 所属部門名 |
| 主机 | ipaddr | String | - | クライアントIPアドレス |
| 登録地点 | loginLocation | String | - | ログイン地点（IP逆引き） |
| ブラウザ | browser | String | - | ブラウザ種別 |
| 操作系統 | os | String | - | オペレーティングシステム |
| 会話状態 | status | String | - | on_line（在線）/ off_line（離線） |
| 登録時間 | startTimestamp | DateTime | 可 | セッション開始時刻 |
| 最後アクセス時間 | lastAccessTime | DateTime | 可 | 最終アクセス時刻 |

## イベント仕様

### 1-検索ボタン押下

検索フォームの入力内容をパラメータとしてサーバーに送信し、一覧を再表示する。

### 2-重置（リセット）ボタン押下

検索フォームの入力内容をクリアし、一覧を初期状態に戻す。

### 3-強退（一括）ボタン押下

1. チェックボックスで選択されたユーザーを取得
2. 選択がない場合は警告メッセージを表示
3. 確認ダイアログ「確認要強退選中的X条数据吗?」を表示
4. OKの場合、選択された全セッションIDをカンマ区切りで送信
5. サーバー側で各セッションを削除し、ステータスをoff_lineに更新
6. 処理完了後、一覧を再読み込み

### 4-強退（個別）ボタン押下

1. 確認ダイアログ「確定要強制選中用戸下線吗?」を表示
2. OKの場合、該当セッションIDを送信
3. 自分自身のセッションの場合はエラー「当前登録用戸無法強退」
4. サーバー側でセッションを削除し、ステータスをoff_lineに更新
5. 処理完了後、一覧を再読み込み

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | sys_user_online | SELECT | オンラインユーザー情報の取得 |
| 強制ログアウト | sys_user_online | UPDATE | ステータスをoff_lineに更新 |

### テーブル別更新項目詳細

#### sys_user_online

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sessionId | 検索条件に合致 | 主キー |
| SELECT | login_name | LIKE '%検索値%' | 部分一致 |
| SELECT | ipaddr | LIKE '%検索値%' | 部分一致 |
| UPDATE | status | 'off_line' | 強制ログアウト時 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| 警告 | 請選択要強退的用戸 | 一括強退で未選択時 |
| 確認 | 確定要強制選中用戸下線吗? | 個別強退時 |
| 確認 | 確認要強退選中的X条数据吗? | 一括強退時 |
| エラー | 用戸已下線 | セッション未存在時 |
| エラー | 当前登録用戸無法強退 | 自分自身を強退しようとした時 |
| 成功 | 操作成功 | 処理正常完了時 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| セッション未存在 | エラーメッセージ「用戸已下線」を表示 |
| 自己セッション強退 | エラーメッセージ「当前登録用戸無法強退」を表示 |
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- デフォルトソートは最終アクセス時間の降順
- セッション情報はShiroのOnlineSessionDAOを通じてRedisキャッシュからも削除される
- 強制ログアウト処理はShiroのセッション管理と連携して動作する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、オンラインユーザー情報を表すドメインクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUserOnline.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserOnline.java` | セッションID、ログイン名、IPアドレス、ステータスなどのフィールド定義を確認 |
| 1-2 | OnlineStatus.java | `ruoyi-common/src/main/java/com/ruoyi/common/enums/OnlineStatus.java` | on_line/off_line列挙型の定義を確認 |

**読解のコツ**: SysUserOnlineクラスはBaseEntityを継承しており、共通フィールド（createBy、createTime等）はBaseEntityで定義されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラークラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysUserOnlineController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java` | 画面表示、一覧取得、強制ログアウトのエンドポイントを確認 |

**主要処理フロー**:
1. **42-47行目**: online()メソッドで画面表示（GET /monitor/online）
2. **49-57行目**: list()メソッドでページング付き一覧取得（POST /monitor/online/list）
3. **59-87行目**: batchForceLogout()メソッドで強制ログアウト処理

#### Step 3: サービス層を理解する

ビジネスロジックを処理するサービスクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysUserOnlineService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserOnlineService.java` | サービスインターフェースの定義 |
| 3-2 | SysUserOnlineServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserOnlineServiceImpl.java` | selectUserOnlineList、saveOnline、removeUserCacheメソッドの実装 |

**主要処理フロー**:
- **selectUserOnlineList**: 検索条件に基づくオンラインユーザー一覧取得
- **saveOnline**: ステータス更新時のDB保存
- **removeUserCache**: ユーザーキャッシュからセッション情報を削除

#### Step 4: データアクセス層を理解する

データベースアクセスを行うMapperを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysUserOnlineMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserOnlineMapper.xml` | SQLの定義（selectUserOnlineList、saveOnline） |
| 4-2 | SysUserOnlineMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserOnlineMapper.java` | Mapperインターフェース |

#### Step 5: ビュー層を理解する

画面テンプレートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | online.html | `ruoyi-admin/src/main/resources/templates/monitor/online/online.html` | Bootstrap Table初期化、検索フォーム、強退ボタンのイベントハンドラ |

**主要処理フロー**:
- **45-127行目**: Bootstrap Tableの初期化と列定義
- **130-135行目**: forceLogout関数（個別強退）
- **138-149行目**: batchForceLogout関数（一括強退）

### プログラム呼び出し階層図

```
SysUserOnlineController
    │
    ├─ list() → ISysUserOnlineService.selectUserOnlineList()
    │              └─ SysUserOnlineMapper.selectUserOnlineList()
    │
    └─ batchForceLogout()
           ├─ ISysUserOnlineService.selectOnlineById()
           ├─ OnlineSessionDAO.readSession()
           ├─ OnlineSessionDAO.delete()
           ├─ ISysUserOnlineService.saveOnline()
           └─ ISysUserOnlineService.removeUserCache()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysUserOnlineController ───▶ JSON(TableDataInfo)
(ipaddr,       └─▶ ISysUserOnlineService
 loginName)         └─▶ SysUserOnlineMapper
                         └─▶ sys_user_online

セッションID ───▶ batchForceLogout() ───▶ AjaxResult
                   ├─▶ OnlineSessionDAO
                   │    └─▶ Shiroセッション削除
                   └─▶ SysUserOnlineMapper
                        └─▶ sys_user_online(UPDATE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysUserOnlineController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java` | ソース | コントローラー |
| ISysUserOnlineService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserOnlineService.java` | ソース | サービスインターフェース |
| SysUserOnlineServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserOnlineServiceImpl.java` | ソース | サービス実装 |
| SysUserOnlineMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserOnlineMapper.java` | ソース | Mapperインターフェース |
| SysUserOnlineMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserOnlineMapper.xml` | 設定 | SQLマッピング |
| SysUserOnline.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserOnline.java` | ソース | ドメインクラス |
| OnlineSessionDAO.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/session/OnlineSessionDAO.java` | ソース | Shiroセッション管理 |
| online.html | `ruoyi-admin/src/main/resources/templates/monitor/online/online.html` | テンプレート | 画面テンプレート |
