# 画面設計書 52-定時任務管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムの定時任務管理一覧画面の設計仕様を記述したものである。

### 本画面の処理概要

定時任務管理一覧画面は、Quartzスケジューラを使用した定期実行タスクの管理を行う画面である。タスクの作成、編集、削除、有効化/無効化、即時実行などの操作を提供し、システム運用における自動処理を管理する。

**業務上の目的・背景**：業務システムにおいて、定期的なバッチ処理（データ集計、レポート生成、キャッシュクリア等）は不可欠である。本画面は、これらの定期タスクをGUIから一元管理し、運用担当者がスケジュール変更や緊急停止を迅速に行えるようにすることで、システム運用の効率化とトラブル対応の迅速化を実現する。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム監視」→「定時任務」を選択することでアクセスできる。アクセスには`monitor:job:view`権限が必要である。

**主要な操作・処理内容**：
1. 定時任務一覧の表示と検索（任務名称、任務分組、任務状態での絞り込み）
2. 新規タスクの登録（Cron式によるスケジュール設定）
3. 既存タスクの編集・削除
4. タスクの有効化（启用）/無効化（停用）
5. タスクの即時実行（执行一次）
6. タスク詳細情報の表示
7. 調度日志（実行ログ）への遷移
8. Cron式生成器の呼び出し
9. タスク一覧のExcelエクスポート

**画面遷移**：本画面から、定時任務新規登録、定時任務編集、定時任務詳細、定時任務ログ、Cron式生成器の各画面に遷移できる。

**権限による表示制御**：`monitor:job:add`がない場合は新増ボタン非表示、`monitor:job:edit`がない場合は修改ボタン非表示、`monitor:job:remove`がない場合は削除ボタン非表示、`monitor:job:changeStatus`がない場合は状態変更トグルと執行一次ボタン非表示、`monitor:job:export`がない場合は導出ボタン非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | 定期タスク管理 | 主機能 | タスク一覧の検索、表示、ステータス変更、即時実行処理 |
| 24 | ファイルダウンロード | 補助機能 | タスクデータのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/job |
| 一覧データ取得 | POST | /monitor/job/list |
| 新規登録画面 | GET | /monitor/job/add |
| 編集画面 | GET | /monitor/job/edit/{jobId} |
| 詳細画面 | GET | /monitor/job/detail/{jobId} |
| 削除 | POST | /monitor/job/remove |
| ステータス変更 | POST | /monitor/job/changeStatus |
| 即時実行 | POST | /monitor/job/run |
| Excelエクスポート | POST | /monitor/job/export |
| Cron式生成器 | GET | /monitor/job/cron |

## 入出力項目

### 検索条件（入力項目）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 任務名称 | jobName | String | 任意 | タスク名の部分一致検索 |
| 任務分組 | jobGroup | String | 任意 | タスクグループのプルダウン選択（辞書：sys_job_group） |
| 任務状態 | status | String | 任意 | ステータスのプルダウン選択（辞書：sys_job_status） |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 説明 |
|--------|--------|----------|--------|------|
| 選択チェックボックス | - | - | - | 一括操作用 |
| 任務編号 | jobId | Long | - | タスクID |
| 任務名称 | jobName | String | - | タスク名 |
| 任務分組 | jobGroup | String | - | グループ名（辞書変換） |
| 調用目標字符串 | invokeTarget | String | - | 呼び出し先（ツールチップ表示） |
| 執行表達式 | cronExpression | String | - | Cron式 |
| 任務状態 | status | String | - | トグルスイッチ表示（0:正常/1:暂停） |
| 創建時間 | createTime | DateTime | 可 | 作成日時 |

## イベント仕様

### 1-検索ボタン押下

検索フォームの入力内容をパラメータとしてサーバーに送信し、一覧を再表示する。

### 2-重置（リセット）ボタン押下

検索フォームの入力内容をクリアし、一覧を初期状態に戻す。

### 3-新増（新規追加）ボタン押下

モーダルダイアログで定時任務新規登録画面（/monitor/job/add）を表示する。

### 4-修改（編集）ボタン押下

選択されたタスクの編集画面（/monitor/job/edit/{jobId}）をモーダルダイアログで表示する。

### 5-削除ボタン押下

1. 確認ダイアログを表示
2. OKの場合、選択されたタスクIDをカンマ区切りで送信
3. サーバー側でQuartzスケジューラからタスクを削除し、DBからレコードを削除
4. 処理完了後、一覧を再読み込み

### 6-ステータストグル押下

1. 現在のステータスに応じて確認ダイアログを表示
   - 正常→暂停：「確認要停用任務吗?」
   - 暂停→正常：「確認要启用任務吗?」
2. OKの場合、ステータス変更をサーバーに送信
3. サーバー側でQuartzスケジューラのジョブを一時停止/再開し、DBを更新
4. 処理完了後、一覧を再読み込み

### 7-執行一次ボタン押下

1. 確認ダイアログ「確認要立即執行一次任務吗?」を表示
2. OKの場合、該当タスクを即時実行
3. Quartzスケジューラに対してtriggerJobを実行
4. 処理完了後、成功メッセージを表示

### 8-任務詳細ボタン押下

定時任務詳細画面（/monitor/job/detail/{jobId}）をモーダルダイアログで表示する。

### 9-調度日志ボタン押下

定時任務ログ画面（/monitor/jobLog?jobId={jobId}）を新規タブで表示する。

### 10-生成表達式ボタン押下

Cron式生成器画面（/monitor/job/cron）をレイヤーポップアップで表示する。

### 11-導出（エクスポート）ボタン押下

検索条件に合致するタスク一覧をExcelファイルとしてダウンロードする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | sys_job | SELECT | 定時任務情報の取得 |
| 削除 | sys_job | DELETE | タスクレコードの削除 |
| ステータス変更 | sys_job | UPDATE | statusフィールドの更新 |

### テーブル別更新項目詳細

#### sys_job

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | job_id | 主キー | - |
| SELECT | job_name | LIKE '%検索値%' | 部分一致 |
| SELECT | job_group | = 検索値 | 完全一致 |
| SELECT | status | = 検索値 | 完全一致 |
| UPDATE | status | '0' or '1' | ステータス変更時 |
| DELETE | job_id | IN (選択ID) | 削除時 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| 確認 | 確認要停用任務吗? | タスク停止時 |
| 確認 | 確認要启用任務吗? | タスク有効化時 |
| 確認 | 確認要立即執行一次任務吗? | 即時実行時 |
| エラー | 任務不存在或已過期！ | 即時実行失敗時 |
| 成功 | 操作成功 | 処理正常完了時 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| タスク未存在 | エラーメッセージ「任務不存在或已過期！」を表示 |
| Cron式無効 | エラーメッセージを表示 |
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- デフォルトソートは作成日時の降順
- Quartzスケジューラとの連携により、DBとスケジューラの整合性を保つ
- タスクグループ、ステータスは辞書データ（sys_dict_data）から取得
- 即時実行はスケジュールに関係なく1回だけ実行される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、定時任務情報を表すドメインクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | jobId、jobName、jobGroup、invokeTarget、cronExpression、misfirePolicy、concurrent、statusなどのフィールド定義を確認 |

**読解のコツ**: SysJobクラスはBaseEntityを継承している。@NotBlank、@Sizeなどのバリデーションアノテーションに注目。getNextValidTime()メソッドはCronUtilsを使って次回実行時刻を計算している。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラークラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | 画面表示、一覧取得、CRUD、ステータス変更、即時実行のエンドポイントを確認 |

**主要処理フロー**:
1. **44-49行目**: job()メソッドで画面表示（GET /monitor/job）
2. **51-59行目**: list()メソッドでページング付き一覧取得（POST /monitor/job/list）
3. **72-80行目**: remove()メソッドでタスク削除
4. **94-103行目**: changeStatus()メソッドでステータス変更
5. **108-116行目**: run()メソッドで即時実行

#### Step 3: サービス層を理解する

ビジネスロジックを処理するサービスクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysJobService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java` | サービスインターフェースの定義 |
| 3-2 | SysJobServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java` | Quartzスケジューラとの連携ロジック |

**主要処理フロー**:
- **selectJobList**: 検索条件に基づくタスク一覧取得
- **changeStatus**: ステータス変更とQuartzジョブの一時停止/再開
- **run**: triggerJobによる即時実行
- **deleteJobByIds**: Quartzからのジョブ削除とDB削除

#### Step 4: Quartz連携を理解する

Quartzスケジューラとの連携ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ScheduleUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/ScheduleUtils.java` | Quartzジョブの作成、削除、一時停止、再開のユーティリティ |
| 4-2 | CronUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java` | Cron式の検証と次回実行時刻の計算 |

#### Step 5: ビュー層を理解する

画面テンプレートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | job.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/job.html` | Bootstrap Table初期化、検索フォーム、各種ボタンのイベントハンドラ |

**主要処理フロー**:
- **72-142行目**: Bootstrap Tableの初期化と列定義
- **145-151行目**: statusTools関数（ステータストグルの表示）
- **154-158行目**: run関数（即時実行）
- **161-165行目**: stop関数（タスク停止）
- **168-172行目**: start関数（タスク有効化）
- **175-181行目**: jobLog関数（ログ画面遷移）
- **184-195行目**: cron関数（Cron式生成器表示）

### プログラム呼び出し階層図

```
SysJobController
    │
    ├─ list() → ISysJobService.selectJobList()
    │              └─ SysJobMapper.selectJobList()
    │
    ├─ changeStatus() → ISysJobService.changeStatus()
    │                      ├─ SysJobMapper.updateJob()
    │                      └─ Scheduler.pauseJob() / resumeJob()
    │
    ├─ run() → ISysJobService.run()
    │             └─ Scheduler.triggerJob()
    │
    └─ remove() → ISysJobService.deleteJobByIds()
                    ├─ ScheduleUtils.deleteScheduleJob()
                    │     └─ Scheduler.deleteJob()
                    └─ SysJobMapper.deleteJobByIds()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysJobController ───▶ JSON(TableDataInfo)
(jobName,      └─▶ ISysJobService
 jobGroup,          └─▶ SysJobMapper
 status)                 └─▶ sys_job

ステータス変更 ───▶ changeStatus() ───▶ AjaxResult
(jobId,status)      ├─▶ SysJobMapper
                    │    └─▶ sys_job(UPDATE)
                    └─▶ Quartz Scheduler
                         └─▶ pauseJob/resumeJob
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | ソース | コントローラー |
| ISysJobService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java` | ソース | サービスインターフェース |
| SysJobServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java` | ソース | サービス実装 |
| SysJobMapper.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/mapper/SysJobMapper.java` | ソース | Mapperインターフェース |
| SysJobMapper.xml | `ruoyi-quartz/src/main/resources/mapper/quartz/SysJobMapper.xml` | 設定 | SQLマッピング |
| SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | ソース | ドメインクラス |
| ScheduleUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/ScheduleUtils.java` | ソース | Quartzユーティリティ |
| CronUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java` | ソース | Cronユーティリティ |
| job.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/job.html` | テンプレート | 画面テンプレート |
