# 画面設計書 53-定時任務新規登録

## 概要

本ドキュメントは、RuoYi後台管理システムの定時任務新規登録画面の設計仕様を記述したものである。

### 本画面の処理概要

定時任務新規登録画面は、新しい定期実行タスクをシステムに登録するための入力フォーム画面である。タスク名、呼び出し先、Cron式、実行ポリシーなどを設定し、Quartzスケジューラに新規ジョブを追加する。

**業務上の目的・背景**：システム運用において新たな定期バッチ処理が必要になった場合、本画面から設定を行うことで、コードの変更なしに新規タスクを追加できる。これにより、運用担当者が迅速にタスクスケジュールを構築でき、システムの柔軟性を高める。

**画面へのアクセス方法**：定時任務管理一覧画面から「新増」ボタンをクリックすることでモーダルダイアログとして表示される。アクセスには`monitor:job:add`権限が必要である。

**主要な操作・処理内容**：
1. タスク情報の入力（必須項目：任務名称、調用目標字符串、cron表達式）
2. 任務分組の選択（辞書データから選択）
3. 執行策略（Misfire Policy）の選択
4. 並発執行の許可/禁止の選択
5. 備考の入力
6. Cron式のリアルタイムバリデーション
7. 保存処理の実行

**画面遷移**：定時任務管理一覧画面から遷移し、保存成功後は一覧画面に戻る。

**権限による表示制御**：`monitor:job:add`権限がない場合、本画面にはアクセスできない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | 定期タスク管理 | 主機能 | 新規タスク情報入力と登録保存処理 |

## 画面種別

登録

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/job/add |
| 保存 | POST | /monitor/job/add |
| Cron式検証 | POST | /monitor/job/checkCronExpressionIsValid |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| 作成者 | createBy | String | - | - | hidden項目（ログインユーザー名を自動設定） |
| 任務名称 | jobName | String | 必須 | 64 | タスク名 |
| 任務分組 | jobGroup | String | 任意 | - | タスクグループ（辞書：sys_job_group） |
| 調用目標字符串 | invokeTarget | String | 必須 | 1000 | 呼び出し対象（Bean名.メソッド名またはクラス名.メソッド名） |
| cron表達式 | cronExpression | String | 必須 | 255 | Cron式 |
| 執行策略 | misfirePolicy | String | 任意 | - | 1:立即執行、2:執行一次、3:放棄執行 |
| 並発執行 | concurrent | String | 任意 | - | 0:允許、1:禁止（デフォルト:1） |
| 備注 | remark | String | 任意 | - | 備考欄 |

## 表示項目

なし（入力フォームのみ）

## イベント仕様

### 1-確定（保存）ボタン押下

1. クライアント側でフォームバリデーションを実行
2. Cron式のサーバーサイドバリデーションを実行
3. 検証成功の場合、フォームデータをサーバーに送信
4. サーバー側でセキュリティチェック（RMI、LDAP、HTTP呼び出し禁止、ホワイトリストチェック）
5. Quartzスケジューラに新規ジョブを追加
6. DBにタスク情報を保存
7. 処理成功の場合、モーダルを閉じて一覧を再読み込み
8. 処理失敗の場合、エラーメッセージを表示

### 2-Cron式入力時

入力内容が変更されるたびに、サーバーにCron式の検証リクエストを送信し、無効な場合はエラーメッセージ「表達式不正確」を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | sys_job | INSERT | タスクレコードの新規作成 |

### テーブル別更新項目詳細

#### sys_job

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | job_id | 自動採番 | 主キー |
| INSERT | job_name | 入力値 | 必須 |
| INSERT | job_group | 入力値 | - |
| INSERT | invoke_target | 入力値 | 必須 |
| INSERT | cron_expression | 入力値 | 必須 |
| INSERT | misfire_policy | 入力値（デフォルト:1） | - |
| INSERT | concurrent | 入力値（デフォルト:1） | - |
| INSERT | status | '1'（暂停） | 新規作成時は暂停状態 |
| INSERT | create_by | ログインユーザー名 | - |
| INSERT | create_time | 現在日時 | - |
| INSERT | remark | 入力値 | - |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| エラー | 表達式不正確 | Cron式が無効な場合 |
| エラー | 新增任務'XXX'失敗，Cron表達式不正確 | 保存時にCron式が無効 |
| エラー | 新增任務'XXX'失敗，目標字符串不允許'rmi'調用 | RMI呼び出しを含む場合 |
| エラー | 新増任務'XXX'失敗，目標字符串不允許'ldap(s)'調用 | LDAP呼び出しを含む場合 |
| エラー | 新增任務'XXX'失敗，目標字符串不允許'http(s)'調用 | HTTP呼び出しを含む場合 |
| エラー | 新增任務'XXX'失敗，目標字符串存在違規 | 禁止文字列を含む場合 |
| エラー | 新増任務'XXX'失敗，目標字符串不在白名單内 | ホワイトリスト外の場合 |
| 成功 | 操作成功 | 処理正常完了時 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| Cron式無効 | エラーメッセージを表示、保存を中断 |
| セキュリティ違反 | エラーメッセージを表示、保存を中断 |
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- 調用目標字符串の形式
  - Bean呼び出し：`ryTask.ryParams('ry')`
  - Class呼び出し：`com.ruoyi.quartz.task.RyTask.ryParams('ry')`
- パラメータは文字列、ブール型、長整数型、浮動小数点型、整数型をサポート
- 新規作成時のステータスは暂停（1）で、作成後に手動で有効化する必要がある
- セキュリティ対策として、RMI、LDAP、HTTP呼び出しは禁止されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | バリデーションアノテーション（@NotBlank、@Size）を確認 |

**読解のコツ**: jobName（最大64文字）、invokeTarget（最大1000文字）、cronExpression（最大255文字）の制約を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | addメソッド（GET/POST）、セキュリティチェックロジックを確認 |

**主要処理フロー**:
1. **121-126行目**: add()メソッドで画面表示（GET /monitor/job/add）
2. **131-163行目**: addSave()メソッドで保存処理（POST /monitor/job/add）
3. **137-159行目**: セキュリティチェック（Cron式検証、禁止文字列チェック、ホワイトリストチェック）
4. **215-220行目**: checkCronExpressionIsValid()でCron式検証

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysJobService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java` | insertJob、checkCronExpressionIsValidメソッドの定義 |
| 3-2 | SysJobServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java` | Quartzへのジョブ登録とDB保存の実装 |

#### Step 4: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | add.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/add.html` | フォーム構成、バリデーション設定、submitHandler関数 |

**主要処理フロー**:
- **8-60行目**: フォーム定義（各入力項目）
- **66-91行目**: jQuery Validateによるバリデーション設定
- **93-97行目**: submitHandler関数（保存処理）

### プログラム呼び出し階層図

```
SysJobController.addSave()
    │
    ├─ CronUtils.isValid() ─── Cron式検証
    │
    ├─ セキュリティチェック
    │   ├─ RMI禁止チェック
    │   ├─ LDAP禁止チェック
    │   ├─ HTTP禁止チェック
    │   └─ ホワイトリストチェック
    │
    └─ ISysJobService.insertJob()
           ├─ SysJobMapper.insertJob() ─── DB INSERT
           └─ ScheduleUtils.createScheduleJob() ─── Quartz登録
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ SysJobController.addSave() ───▶ AjaxResult
(jobName,          │
 invokeTarget,     ├─▶ バリデーション
 cronExpression,   │
 misfirePolicy,    ├─▶ セキュリティチェック
 concurrent,       │
 remark)           ├─▶ ISysJobService.insertJob()
                   │    ├─▶ SysJobMapper
                   │    │    └─▶ sys_job(INSERT)
                   │    └─▶ Quartz Scheduler
                   │         └─▶ ジョブ登録
                   │
                   └─▶ 成功/エラーレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | ソース | コントローラー |
| ISysJobService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java` | ソース | サービスインターフェース |
| SysJobServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java` | ソース | サービス実装 |
| SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | ソース | ドメインクラス |
| CronUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java` | ソース | Cronユーティリティ |
| ScheduleUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/ScheduleUtils.java` | ソース | Quartzユーティリティ |
| add.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/add.html` | テンプレート | 画面テンプレート |
