# 画面設計書 55-定時任務詳細

## 概要

本ドキュメントは、RuoYi後台管理システムの定時任務詳細画面の設計仕様を記述したものである。

### 本画面の処理概要

定時任務詳細画面は、定期実行タスクの詳細情報を参照専用で表示する画面である。タスク設定の確認や、次回実行時刻の把握、実行ポリシーの確認などに使用する。

**業務上の目的・背景**：運用担当者がタスクの設定内容を確認する際、編集画面を開くと誤って変更してしまうリスクがある。本画面は参照専用であるため、設定内容の確認を安全に行うことができる。また、次回実行時刻をCron式から計算して表示することで、スケジュールの確認が容易になる。

**画面へのアクセス方法**：定時任務管理一覧画面から対象タスクの「任務詳細」ボタンをクリックすることでモーダルダイアログとして表示される。アクセスには`monitor:job:detail`権限が必要である。

**主要な操作・処理内容**：
1. タスク基本情報の表示（任務序号、任務名称、任務分組）
2. 実行設定の表示（調用目標字符串、執行表達式、下次執行時間）
3. 実行ポリシーの表示（執行策略、並発執行）
4. ステータスの表示（執行状態）

**画面遷移**：定時任務管理一覧画面から遷移し、閉じると一覧画面に戻る。

**権限による表示制御**：`monitor:job:detail`権限がない場合、本画面にはアクセスできない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | 定期タスク管理 | 主機能 | タスク情報の詳細表示処理 |

## 画面種別

詳細

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/job/detail/{jobId} |

## 入出力項目

### 入力項目

なし（参照専用画面）

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 任務序号 | jobId | Long | タスクID |
| 任務名称 | jobName | String | タスク名 |
| 任務分組 | jobGroup | String | タスクグループ |
| 調用目標字符串 | invokeTarget | String | 呼び出し対象 |
| 執行表達式 | cronExpression | String | Cron式 |
| 下次執行時間 | nextValidTime | DateTime | 次回実行予定時刻（Cron式から計算） |
| 執行策略 | misfirePolicy | String | 0:默認策略、1:立即執行、2:執行一次、3:放棄執行 |
| 並発執行 | concurrent | String | 0:允許（緑ラベル）、1:禁止（赤ラベル） |
| 執行状態 | status | String | 0:正常（緑ラベル）、1:暂停（赤ラベル） |

## イベント仕様

本画面は参照専用のため、ユーザー操作によるイベントは存在しない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | sys_job | SELECT | タスク情報の取得 |

### テーブル別更新項目詳細

#### sys_job

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | job_id | = パスパラメータ | 主キー |
| SELECT | job_name | 表示用 | - |
| SELECT | job_group | 表示用 | - |
| SELECT | invoke_target | 表示用 | - |
| SELECT | cron_expression | 表示用、次回実行時刻計算に使用 | - |
| SELECT | misfire_policy | 表示用 | - |
| SELECT | concurrent | 表示用 | - |
| SELECT | status | 表示用 | - |

## メッセージ仕様

本画面は参照専用のため、メッセージは存在しない。

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| タスク未存在 | エラー画面に遷移 |
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- 次回実行時刻（nextValidTime）はSysJob.getNextValidTime()メソッドでCronUtilsを使用して計算される
- この画面はジョブ詳細（name=job）とジョブログ詳細（name=jobLog）の両方を表示できる共通テンプレートを使用
- 本仕様はジョブ詳細（name=job）の場合のみを記述

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | getNextValidTime()メソッドに注目 |

**読解のコツ**: getNextValidTime()はCronUtils.getNextExecution()を呼び出して次回実行時刻を計算している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | detailメソッドを確認 |

**主要処理フロー**:
1. **82-89行目**: detail()メソッドで画面表示（GET /monitor/job/detail/{jobId}）
2. **86行目**: ModelMapに"name"="job"を設定
3. **87行目**: ModelMapにjobオブジェクトを設定

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | detail.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/detail.html` | th:if="${name == 'job'}"で条件分岐 |

**主要処理フロー**:
- **47-95行目**: ジョブ詳細フォーム（th:if="${name == 'job'}"）
- **74-77行目**: 次回実行時刻の表示
- **79-84行目**: 執行策略の条件分岐表示
- **86-88行目**: 並発執行のラベル表示
- **90-92行目**: 執行状態のラベル表示

### プログラム呼び出し階層図

```
SysJobController.detail()
    │
    └─ ISysJobService.selectJobById()
           └─ SysJobMapper.selectJobById()
                 └─ sys_job(SELECT)
```

### データフロー図

```
[入力]               [処理]                    [出力]

jobId(パス) ───▶ SysJobController.detail() ───▶ 画面表示
                  │
                  └─▶ ISysJobService.selectJobById()
                       └─▶ SysJobMapper
                            └─▶ sys_job
                                 │
                                 └─▶ SysJob.getNextValidTime()
                                      └─▶ CronUtils.getNextExecution()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | ソース | コントローラー |
| ISysJobService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java` | ソース | サービスインターフェース |
| SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | ソース | ドメインクラス |
| CronUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java` | ソース | Cronユーティリティ |
| detail.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/detail.html` | テンプレート | 画面テンプレート |
