# 画面設計書 56-定時任務ログ

## 概要

本ドキュメントは、RuoYi後台管理システムの定時任務ログ画面の設計仕様を記述したものである。

### 本画面の処理概要

定時任務ログ画面は、定期実行タスクの実行履歴を一覧表示する画面である。タスクの実行結果（成功/失敗）、実行時刻、例外情報などを確認でき、タスク運用のモニタリングとトラブルシューティングに使用する。

**業務上の目的・背景**：定期バッチ処理の実行状況を監視することは運用において重要である。本画面では、タスクごとの実行履歴を時系列で確認でき、失敗したタスクの例外情報を確認してトラブルシューティングを行うことができる。また、不要になった古いログの一括削除や清空も可能である。

**画面へのアクセス方法**：定時任務管理一覧画面から「調度日志」ボタンをクリック、または対象タスクの「日志」ボタンをクリックすることで新規タブとして表示される。アクセスには`monitor:job:view`権限が必要である。

**主要な操作・処理内容**：
1. ログ一覧の表示と検索（任務名称、任務分組、執行状態、執行時間での絞り込み）
2. ログ詳細の表示（実行情報、例外情報の確認）
3. ログの削除（個別/一括）
4. ログの全件清空
5. ログ一覧のExcelエクスポート

**画面遷移**：定時任務管理一覧画面から遷移し、ログ詳細画面（モーダル）への遷移が可能。

**権限による表示制御**：`monitor:job:remove`がない場合は削除・清空ボタン非表示、`monitor:job:export`がない場合は導出ボタン非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | 定期タスク管理 | 主機能 | タスク実行ログの一覧表示、削除、清空処理 |
| 24 | ファイルダウンロード | 補助機能 | ログデータのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/jobLog |
| 一覧データ取得 | POST | /monitor/jobLog/list |
| 詳細画面 | GET | /monitor/jobLog/detail/{jobLogId} |
| 削除 | POST | /monitor/jobLog/remove |
| 清空 | POST | /monitor/jobLog/clean |
| Excelエクスポート | POST | /monitor/jobLog/export |

## 入出力項目

### 検索条件（入力項目）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 任務名称 | jobName | String | 任意 | タスク名の部分一致検索 |
| 任務分組 | jobGroup | String | 任意 | タスクグループのプルダウン選択（辞書：sys_job_group） |
| 執行状態 | status | String | 任意 | ステータスのプルダウン選択（辞書：sys_common_status） |
| 開始時間 | beginTime | Date | 任意 | 実行時間の範囲検索（開始） |
| 終了時間 | endTime | Date | 任意 | 実行時間の範囲検索（終了） |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 説明 |
|--------|--------|----------|--------|------|
| 選択チェックボックス | - | - | - | 一括操作用 |
| 日志編号 | jobLogId | Long | 可 | ログID |
| 任務名称 | jobName | String | - | タスク名 |
| 任務分組 | jobGroup | String | - | グループ名（辞書変換） |
| 調用目標字符串 | invokeTarget | String | - | 呼び出し先（ツールチップ表示） |
| 日志信息 | jobMessage | String | - | ログメッセージ |
| 執行状態 | status | String | - | 0:成功（緑ラベル）、1:失敗（赤ラベル） |
| 執行時間 | createTime | DateTime | 可 | タスク実行時刻 |

## イベント仕様

### 1-検索ボタン押下

検索フォームの入力内容をパラメータとしてサーバーに送信し、一覧を再表示する。

### 2-重置（リセット）ボタン押下

検索フォームの入力内容をクリアし、一覧を初期状態に戻す。

### 3-削除ボタン押下

1. チェックボックスで選択されたログを取得
2. 確認ダイアログを表示
3. OKの場合、選択されたログIDをカンマ区切りで送信
4. サーバー側でログレコードを削除
5. 処理完了後、一覧を再読み込み

### 4-清空ボタン押下

1. 確認ダイアログ「是否確認清空所有調度日志数据項?」を表示
2. OKの場合、全ログを削除
3. 処理完了後、一覧を再読み込み

### 5-詳細ボタン押下

定時任務詳細画面（共通テンプレート、name=jobLog）をモーダルダイアログで表示する。

### 6-導出（エクスポート）ボタン押下

検索条件に合致するログ一覧をExcelファイルとしてダウンロードする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | sys_job_log | SELECT | ログ情報の取得 |
| 削除 | sys_job_log | DELETE | ログレコードの削除 |
| 清空 | sys_job_log | TRUNCATE | 全ログレコードの削除 |

### テーブル別更新項目詳細

#### sys_job_log

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | job_log_id | 主キー | - |
| SELECT | job_name | LIKE '%検索値%' | 部分一致 |
| SELECT | job_group | = 検索値 | 完全一致 |
| SELECT | status | = 検索値 | 完全一致 |
| SELECT | create_time | BETWEEN 開始 AND 終了 | 範囲検索 |
| DELETE | job_log_id | IN (選択ID) | 削除時 |
| TRUNCATE | - | - | 清空時 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| 確認 | 是否確認清空所有調度日志数据項? | 清空ボタン押下時 |
| 成功 | 操作成功 | 処理正常完了時 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- 特定タスクのログのみ表示する場合はクエリパラメータ`jobId`を指定
- デフォルトソートは作成日時の降順
- 清空操作はTRUNCATE TABLEを使用するため、ロールバック不可

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJobLog.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` | jobLogId、jobName、jobGroup、invokeTarget、jobMessage、status、exceptionInfoなどのフィールド定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysJobLogController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java` | 画面表示、一覧取得、削除、清空のエンドポイントを確認 |

**主要処理フロー**:
1. **43-53行目**: jobLog()メソッドで画面表示（GET /monitor/jobLog）
2. **55-63行目**: list()メソッドでページング付き一覧取得（POST /monitor/jobLog/list）
3. **76-83行目**: remove()メソッドでログ削除
4. **85-92行目**: detail()メソッドでログ詳細表示
5. **94-102行目**: clean()メソッドで全ログ清空

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysJobLogService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobLogService.java` | サービスインターフェースの定義 |
| 3-2 | SysJobLogServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobLogServiceImpl.java` | 各メソッドの実装 |

#### Step 4: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | jobLog.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/jobLog.html` | Bootstrap Table初期化、検索フォーム、各種ボタンのイベントハンドラ |

**主要処理フロー**:
- **60-111行目**: Bootstrap Tableの初期化と列定義
- **96-103行目**: statusのラベル表示

### プログラム呼び出し階層図

```
SysJobLogController
    │
    ├─ list() → ISysJobLogService.selectJobLogList()
    │              └─ SysJobLogMapper.selectJobLogList()
    │
    ├─ remove() → ISysJobLogService.deleteJobLogByIds()
    │              └─ SysJobLogMapper.deleteJobLogByIds()
    │
    └─ clean() → ISysJobLogService.cleanJobLog()
                   └─ SysJobLogMapper.cleanJobLog()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysJobLogController ───▶ JSON(TableDataInfo)
(jobName,       └─▶ ISysJobLogService
 jobGroup,           └─▶ SysJobLogMapper
 status,                  └─▶ sys_job_log
 beginTime,
 endTime)

ログID ───▶ remove() ───▶ AjaxResult
            └─▶ SysJobLogMapper
                 └─▶ sys_job_log(DELETE)

清空要求 ───▶ clean() ───▶ AjaxResult
             └─▶ SysJobLogMapper
                  └─▶ sys_job_log(TRUNCATE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobLogController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java` | ソース | コントローラー |
| ISysJobLogService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobLogService.java` | ソース | サービスインターフェース |
| SysJobLogServiceImpl.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobLogServiceImpl.java` | ソース | サービス実装 |
| SysJobLogMapper.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/mapper/SysJobLogMapper.java` | ソース | Mapperインターフェース |
| SysJobLogMapper.xml | `ruoyi-quartz/src/main/resources/mapper/quartz/SysJobLogMapper.xml` | 設定 | SQLマッピング |
| SysJobLog.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` | ソース | ドメインクラス |
| jobLog.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/jobLog.html` | テンプレート | 画面テンプレート |
| detail.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/detail.html` | テンプレート | 詳細画面テンプレート（共通） |
