# 画面設計書 57-Cron式生成器

## 概要

本ドキュメントは、RuoYi後台管理システムのCron式生成器画面の設計仕様を記述したものである。

### 本画面の処理概要

Cron式生成器画面は、定時任務のスケジュール設定で使用するCron表現式をGUIから生成するための補助ツール画面である。秒、分、時、日、月、週の各フィールドをタブで切り替えながら設定し、最終的なCron式を生成する。

**業務上の目的・背景**：Cron式は強力なスケジュール表現方法であるが、その記法は複雑で覚えにくい。本画面は、GUIベースでスケジュールを設定することで、Cron式の知識がなくても正確なスケジュール設定を行えるようにする。また、生成したCron式の次回10回の実行時刻をプレビュー表示することで、設定の正確性を確認できる。

**画面へのアクセス方法**：定時任務新規登録画面または編集画面から「生成表達式」リンクをクリックすることでレイヤーポップアップとして表示される。特定の権限は不要（任務登録/編集権限があれば使用可能）。

**主要な操作・処理内容**：
1. 秒（0-59）の設定
2. 分（0-59）の設定
3. 時（0-23）の設定
4. 日（1-31）の設定
5. 月（1-12）の設定
6. 週（1-7）の設定
7. Cron式の反向解析（既存Cron式からの設定読み込み）
8. 次回10回の実行時刻プレビュー
9. Cron式の確定と呼び出し元への反映

**画面遷移**：定時任務新規登録画面または編集画面からポップアップ表示され、確定後は呼び出し元画面に戻る。

**権限による表示制御**：特になし（呼び出し元画面の権限に依存）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | 定期タスク管理 | 補助機能 | Cron式の生成と次回実行時刻のプレビュー処理 |

## 画面種別

その他（ツール）

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/job/cron |
| 次回実行時刻取得 | GET | /monitor/job/queryCronExpression |

## 入出力項目

### 入力項目（タブ別）

#### 秒タブ
| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 秒種別 | second | radio | 毎秒/周期/起始/指定 |
| 周期開始 | secondStart | Number | 周期の開始秒（0-59） |
| 周期終了 | secondEnd | Number | 周期の終了秒（0-59） |
| 起始秒 | secondStart2 | Number | 開始秒 |
| 間隔 | secondEnd2 | Number | 間隔秒数 |
| 指定秒 | secondList | checkbox[] | 個別秒の選択（0-59） |

#### 分タブ
| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 分種別 | minute | radio | 毎分/周期/起始/指定 |
| 周期開始 | minuteStart | Number | 周期の開始分（0-59） |
| 周期終了 | minuteEnd | Number | 周期の終了分（0-59） |
| 起始分 | minuteStart2 | Number | 開始分 |
| 間隔 | minuteEnd2 | Number | 間隔分数 |
| 指定分 | minuteList | checkbox[] | 個別分の選択（0-59） |

#### 時タブ
| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 時種別 | hour | radio | 毎時/周期/起始/指定 |
| 周期開始 | hourStart | Number | 周期の開始時（0-23） |
| 周期終了 | hourEnd | Number | 周期の終了時（0-23） |
| 起始時 | hourStart2 | Number | 開始時 |
| 間隔 | hourEnd2 | Number | 間隔時間数 |
| 指定時 | hourList | checkbox[] | 個別時の選択（0-23） |

#### 日タブ
| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 日種別 | day | radio | 毎日/周期/起始/不指定/月末日/指定 |
| 周期開始 | dayStart | Number | 周期の開始日（1-31） |
| 周期終了 | dayEnd | Number | 周期の終了日（1-31） |
| 起始日 | dayStart2 | Number | 開始日 |
| 間隔 | dayEnd2 | Number | 間隔日数 |
| 指定日 | dayList | checkbox[] | 個別日の選択（1-31） |

#### 月タブ
| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 月種別 | month | radio | 毎月/周期/起始/不指定/指定 |
| 周期開始 | monthStart | Number | 周期の開始月（1-12） |
| 周期終了 | monthEnd | Number | 周期の終了月（1-12） |
| 起始月 | monthStart2 | Number | 開始月 |
| 間隔 | monthEnd2 | Number | 間隔月数 |
| 指定月 | monthList | checkbox[] | 個別月の選択（1-12） |

#### 週タブ
| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 週種別 | week | radio | 毎週/周期/起始/不指定/本月最後週/指定 |
| 周期開始 | weekStart | Number | 周期の開始曜日（1-7） |
| 周期終了 | weekEnd | Number | 周期の終了曜日（1-7） |
| 第N週 | weekStart2 | Number | 第何週（1-4） |
| 曜日 | weekEnd2 | Number | 曜日（1-7） |
| 指定曜日 | weekList | checkbox[] | 個別曜日の選択（1-7） |

### 出力項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| Cron表達式 | cron | String | 生成されたCron式 |
| 最近10次運行時間 | - | List<DateTime> | 次回10回の実行予定時刻 |

## イベント仕様

### 1-タブ切り替え

各タブ（秒/分/時/日/月/週）を切り替えると、対応する設定パネルが表示される。

### 2-設定変更時

各フィールドの設定を変更すると、リアルタイムでCron式が生成され、「Cron表達式」テキストボックスに表示される。

### 3-反向解析ボタン押下

「Cron表達式」テキストボックスに入力されたCron式を解析し、各タブの設定に反映する。

### 4-確認ボタン押下

1. 生成されたCron式をサーバーに送信して検証
2. 検証成功の場合、次回10回の実行時刻を取得して表示
3. ユーザーが確定すると、呼び出し元画面のCron式フィールドに反映
4. ポップアップを閉じる

### 5-執行預覧（実行プレビュー）ボタン押下

1. 現在のCron式をサーバーに送信
2. 次回10回の実行予定時刻を取得
3. 結果をリストに表示

## データベース更新仕様

本画面はCron式生成のためのツール画面であり、データベースの更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| エラー | 表達式無効 | Cron式が無効な場合 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| Cron式無効 | エラーメッセージを表示 |
| サーバーエラー | エラーメッセージを表示 |

## 備考

- Cron式は6フィールド形式（秒 分 時 日 月 週）を使用
- 「?」は日と週の「不指定」を表す（日と週は相互排他的）
- 「L」は月末日または月の最後の曜日を表す
- 「#」は第N週の曜日を表す（例：2#3 = 第3火曜日）
- 「/」は間隔を表す（例：0/5 = 0から5間隔）
- 「-」は範囲を表す（例：10-20 = 10から20まで）
- 「,」は複数指定を表す（例：1,3,5 = 1と3と5）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | cronメソッドとqueryCronExpressionメソッドを確認 |

**主要処理フロー**:
1. **225-229行目**: cron()メソッドで画面表示（GET /monitor/job/cron）
2. **234-247行目**: queryCronExpression()メソッドで次回実行時刻取得

#### Step 2: Cronユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CronUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java` | getRecentTriggerTimeメソッドを確認 |

**読解のコツ**: getRecentTriggerTimeは指定されたCron式から次回10回の実行時刻を計算する。

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cron.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/cron.html` | タブ構成、各フィールドの入力フォーム、JavaScript関数を確認 |

**主要処理フロー**:
- タブ構成（秒/分/時/日/月/週）
- 各フィールドの設定オプション
- Cron式の動的生成ロジック
- 反向解析ロジック

### プログラム呼び出し階層図

```
SysJobController
    │
    ├─ cron() ─── 画面表示
    │
    └─ queryCronExpression()
           └─ CronUtils.getRecentTriggerTime()
                 └─ 次回10回実行時刻計算
```

### データフロー図

```
[入力]               [処理]                    [出力]

タブ設定 ───▶ JavaScript ───▶ Cron式生成
(秒/分/時/    └─▶ リアルタイム
 日/月/週)         表示更新

Cron式 ───▶ queryCronExpression() ───▶ 次回10回実行時刻
            └─▶ CronUtils
                 └─▶ Quartzライブラリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | ソース | コントローラー |
| CronUtils.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java` | ソース | Cronユーティリティ |
| cron.html | `ruoyi-quartz/src/main/resources/templates/monitor/job/cron.html` | テンプレート | 画面テンプレート |
