# 画面設計書 58-操作ログ一覧

## 概要

本ドキュメントは、RuoYi後台管理システムの操作ログ一覧画面の設計仕様を記述したものである。

### 本画面の処理概要

操作ログ一覧画面は、システム内で行われた各種操作（新増、修改、削除、導出など）の履歴を一覧表示する画面である。誰が、いつ、どの機能で、どのような操作を行ったかを追跡でき、セキュリティ監査やトラブルシューティングに使用する。

**業務上の目的・背景**：システム運用において操作の追跡可能性（トレーサビリティ）は重要である。本画面では、全ての重要な操作がログとして記録され、管理者が操作履歴を確認できる。これにより、不正操作の検知、問題発生時の原因究明、監査対応などが可能となる。

**画面へのアクセス方法**：システム首頁の左側メニューから「日志管理」→「操作日志」を選択することでアクセスできる。アクセスには`monitor:operlog:view`権限が必要である。

**主要な操作・処理内容**：
1. 操作ログ一覧の表示と検索（操作地址、系統模塊、操作人員、操作類型、操作状態、操作時間での絞り込み）
2. ログ詳細の表示（請求参数、返回参数、異常信息の確認）
3. ログの削除（個別/一括）
4. ログの全件清空
5. ログ一覧のExcelエクスポート

**画面遷移**：システム首頁から遷移し、操作ログ詳細画面（モーダル）への遷移が可能。

**権限による表示制御**：`monitor:operlog:remove`がない場合は削除・清空ボタン非表示、`monitor:operlog:export`がない場合は導出ボタン非表示、`monitor:operlog:detail`がない場合は詳細ボタン非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | 操作ログ | 主機能 | 操作ログ一覧表示、検索、詳細表示、削除、清空処理 |
| 24 | ファイルダウンロード | 補助機能 | ログデータのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/operlog |
| 一覧データ取得 | POST | /monitor/operlog/list |
| 詳細画面 | GET | /monitor/operlog/detail/{operId} |
| 削除 | POST | /monitor/operlog/remove |
| 清空 | POST | /monitor/operlog/clean |
| Excelエクスポート | POST | /monitor/operlog/export |

## 入出力項目

### 検索条件（入力項目）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 操作地址 | operIp | String | 任意 | IPアドレスの部分一致検索 |
| 系統模塊 | title | String | 任意 | モジュール名の部分一致検索 |
| 操作人員 | operName | String | 任意 | 操作者名の部分一致検索 |
| 操作類型 | businessTypes | String[] | 任意 | 操作種別の複数選択（辞書：sys_oper_type） |
| 操作状態 | status | String | 任意 | ステータスのプルダウン選択（辞書：sys_common_status） |
| 開始時間 | beginTime | Date | 任意 | 操作時間の範囲検索（開始） |
| 終了時間 | endTime | Date | 任意 | 操作時間の範囲検索（終了） |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 説明 |
|--------|--------|----------|--------|------|
| 選択チェックボックス | - | - | - | 一括操作用 |
| 日志編号 | operId | Long | - | ログID |
| 系統模塊 | title | String | - | 操作対象モジュール名（ツールチップ表示） |
| 操作類型 | businessType | Integer | - | 操作種別（辞書変換） |
| 操作人員 | operName | String | 可 | 操作者名 |
| 部門名称 | deptName | String | - | 操作者所属部門 |
| 操作地址 | operIp | String | - | クライアントIPアドレス |
| 操作地点 | operLocation | String | - | 操作地点（IP逆引き） |
| 操作状態 | status | Integer | - | 0:成功（緑ラベル）、1:失敗（赤ラベル） |
| 操作時間 | operTime | DateTime | 可 | 操作実行時刻 |
| 消耗時間 | costTime | Long | 可 | 処理時間（ミリ秒） |

## イベント仕様

### 1-検索ボタン押下

検索フォームの入力内容をパラメータとしてサーバーに送信し、一覧を再表示する。

### 2-重置（リセット）ボタン押下

検索フォームの入力内容をクリアし、一覧を初期状態に戻す。

### 3-削除ボタン押下

1. チェックボックスで選択されたログを取得
2. 確認ダイアログを表示
3. OKの場合、選択されたログIDをカンマ区切りで送信
4. サーバー側でログレコードを削除
5. 処理完了後、一覧を再読み込み

### 4-清空ボタン押下

1. 確認ダイアログ「是否確認清空所有操作日志数据項?」を表示
2. OKの場合、全ログを削除
3. 処理完了後、一覧を再読み込み

### 5-詳細ボタン押下

操作ログ詳細画面（/monitor/operlog/detail/{operId}）をモーダルダイアログで表示する。

### 6-導出（エクスポート）ボタン押下

検索条件に合致するログ一覧をExcelファイルとしてダウンロードする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | sys_oper_log | SELECT | ログ情報の取得 |
| 削除 | sys_oper_log | DELETE | ログレコードの削除 |
| 清空 | sys_oper_log | TRUNCATE | 全ログレコードの削除 |

### テーブル別更新項目詳細

#### sys_oper_log

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | oper_id | 主キー | - |
| SELECT | oper_ip | LIKE '%検索値%' | 部分一致 |
| SELECT | title | LIKE '%検索値%' | 部分一致 |
| SELECT | oper_name | LIKE '%検索値%' | 部分一致 |
| SELECT | business_type | IN (選択値) | 複数選択 |
| SELECT | status | = 検索値 | 完全一致 |
| SELECT | oper_time | BETWEEN 開始 AND 終了 | 範囲検索 |
| DELETE | oper_id | IN (選択ID) | 削除時 |
| TRUNCATE | - | - | 清空時 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| 確認 | 是否確認清空所有操作日志数据項? | 清空ボタン押下時 |
| 成功 | 操作成功 | 処理正常完了時 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- デフォルトソートは操作時間の降順
- 操作類型は辞書（sys_oper_type）から取得：0=其它、1=新増、2=修改、3=削除、4=授権、5=導出、6=導入、7=強退、8=生成代碼、9=清空数据
- 清空操作はTRUNCATE TABLEを使用するため、ロールバック不可
- 消耗時間はミリ秒単位で表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | operId、title、businessType、method、requestMethod、operatorType、operName、deptName、operUrl、operIp、operLocation、operParam、jsonResult、status、errorMsg、operTime、costTimeなどのフィールド定義を確認 |

**読解のコツ**: @Excel注釈はExcelエクスポート時の列定義を表す。businessTypesフィールドは検索用の配列。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | 画面表示、一覧取得、詳細表示、削除、清空のエンドポイントを確認 |

**主要処理フロー**:
1. **36-41行目**: operlog()メソッドで画面表示（GET /monitor/operlog）
2. **43-51行目**: list()メソッドでページング付き一覧取得（POST /monitor/operlog/list）
3. **64-71行目**: remove()メソッドでログ削除
4. **73-78行目**: detail()メソッドでログ詳細表示
5. **81-89行目**: clean()メソッドで全ログ清空

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysOperLogService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysOperLogService.java` | サービスインターフェースの定義 |
| 3-2 | SysOperLogServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysOperLogServiceImpl.java` | 各メソッドの実装 |

#### Step 4: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | operlog.html | `ruoyi-admin/src/main/resources/templates/monitor/operlog/operlog.html` | Bootstrap Table初期化、検索フォーム、各種ボタンのイベントハンドラ |

**主要処理フロー**:
- **69-164行目**: Bootstrap Tableの初期化と列定義
- **107-109行目**: businessTypeの辞書変換
- **129-137行目**: statusのラベル表示
- **149-151行目**: costTimeのフォーマット

### プログラム呼び出し階層図

```
SysOperlogController
    │
    ├─ list() → ISysOperLogService.selectOperLogList()
    │              └─ SysOperLogMapper.selectOperLogList()
    │
    ├─ detail() → ISysOperLogService.selectOperLogById()
    │               └─ SysOperLogMapper.selectOperLogById()
    │
    ├─ remove() → ISysOperLogService.deleteOperLogByIds()
    │              └─ SysOperLogMapper.deleteOperLogByIds()
    │
    └─ clean() → ISysOperLogService.cleanOperLog()
                   └─ SysOperLogMapper.cleanOperLog()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysOperlogController ───▶ JSON(TableDataInfo)
(operIp,       └─▶ ISysOperLogService
 title,             └─▶ SysOperLogMapper
 operName,               └─▶ sys_oper_log
 businessTypes,
 status,
 beginTime,
 endTime)

ログID ───▶ detail() ───▶ 詳細画面(HTML)
            └─▶ ISysOperLogService
                 └─▶ SysOperLogMapper
                      └─▶ sys_oper_log

ログID ───▶ remove() ───▶ AjaxResult
            └─▶ SysOperLogMapper
                 └─▶ sys_oper_log(DELETE)

清空要求 ───▶ clean() ───▶ AjaxResult
             └─▶ SysOperLogMapper
                  └─▶ sys_oper_log(TRUNCATE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | ソース | コントローラー |
| ISysOperLogService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysOperLogService.java` | ソース | サービスインターフェース |
| SysOperLogServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysOperLogServiceImpl.java` | ソース | サービス実装 |
| SysOperLogMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysOperLogMapper.java` | ソース | Mapperインターフェース |
| SysOperLogMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysOperLogMapper.xml` | 設定 | SQLマッピング |
| SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | ソース | ドメインクラス |
| operlog.html | `ruoyi-admin/src/main/resources/templates/monitor/operlog/operlog.html` | テンプレート | 画面テンプレート |
| detail.html | `ruoyi-admin/src/main/resources/templates/monitor/operlog/detail.html` | テンプレート | 詳細画面テンプレート |
