# 画面設計書 59-操作ログ詳細

## 概要

本ドキュメントは、RuoYi後台管理システムの操作ログ詳細画面の設計仕様を記述したものである。

### 本画面の処理概要

操作ログ詳細画面は、特定の操作ログの詳細情報を参照専用で表示する画面である。操作モジュール、ログイン情報、請求地址、操作方法、請求参数、返回参数、状態、異常信息などを確認でき、トラブルシューティングや監査対応に使用する。

**業務上の目的・背景**：操作ログ一覧では概要情報のみが表示されるが、詳細な調査が必要な場合は、請求参数や返回参数、異常情報を確認する必要がある。本画面では、これらの詳細情報をJSON形式で見やすく表示することで、問題の原因究明を支援する。

**画面へのアクセス方法**：操作ログ一覧画面から対象ログの「詳細」ボタンをクリックすることでモーダルダイアログとして表示される。アクセスには`monitor:operlog:detail`権限が必要である。

**主要な操作・処理内容**：
1. 操作モジュール情報の表示（タイトル/操作類型）
2. ログイン情報の表示（操作人員/部門名称/IPアドレス/操作地点）
3. 請求情報の表示（請求方式/URL/消耗時間）
4. 操作方法の表示（Javaメソッド名）
5. 請求参数のJSON表示
6. 返回参数のJSON表示
7. 状態の表示（正常/異常）
8. 異常信息の表示（エラー時のみ）

**画面遷移**：操作ログ一覧画面から遷移し、閉じると一覧画面に戻る。

**権限による表示制御**：`monitor:operlog:detail`権限がない場合、本画面にはアクセスできない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | 操作ログ | 主機能 | 操作ログ詳細情報の表示処理 |

## 画面種別

詳細

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/operlog/detail/{operId} |

## 入出力項目

### 入力項目

なし（参照専用画面）

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 操作模塊 | title + businessType | String | 「タイトル / 操作類型」形式で表示 |
| 登録信息 | operName + deptName + operIp + operLocation | String | 「操作人員 / 部門名称 / IP / 操作地点」形式で表示 |
| 請求地址 | requestMethod + operUrl + costTime | String | 「請求方式 - URL (耗時Xミリ秒)」形式で表示 |
| 操作方法 | method | String | Javaクラス.メソッド名 |
| 請求参数 | operParam | String(JSON) | JSONViewで整形表示（2000文字以上は生テキスト） |
| 返回参数 | jsonResult | String(JSON) | JSONViewで整形表示（2000文字以上は生テキスト） |
| 状態 | status | Integer | 0:正常（緑ラベル）、1:異常（赤ラベル） |
| 異常信息 | errorMsg | String | エラーメッセージ（異常時のみ表示） |

## イベント仕様

本画面は参照専用のため、ユーザー操作によるイベントは存在しない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | sys_oper_log | SELECT | ログ情報の取得 |

### テーブル別更新項目詳細

#### sys_oper_log

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | oper_id | = パスパラメータ | 主キー |
| SELECT | title | 表示用 | 操作モジュール名 |
| SELECT | business_type | 表示用 | 辞書変換して表示 |
| SELECT | oper_name | 表示用 | 操作人員 |
| SELECT | dept_name | 表示用 | 部門名称 |
| SELECT | oper_ip | 表示用 | IPアドレス |
| SELECT | oper_location | 表示用 | 操作地点 |
| SELECT | request_method | 表示用 | 請求方式 |
| SELECT | oper_url | 表示用 | URL |
| SELECT | cost_time | 表示用 | 消耗時間 |
| SELECT | method | 表示用 | 操作方法 |
| SELECT | oper_param | 表示用 | 請求参数 |
| SELECT | json_result | 表示用 | 返回参数 |
| SELECT | status | 表示用 | 状態 |
| SELECT | error_msg | 表示用 | 異常信息 |

## メッセージ仕様

本画面は参照専用のため、メッセージは存在しない。

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| ログ未存在 | エラー画面に遷移 |
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- 請求参数（operParam）と返回参数（jsonResult）はJSONViewライブラリで整形表示される
- 2000文字以上の場合は生テキストで表示される（パフォーマンス対策）
- 異常信息（errorMsg）はstatus=1（異常）の場合のみ表示される
- 操作類型は辞書（sys_oper_type）から取得してラベル表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | 全フィールドを確認。特にoperParam、jsonResult、errorMsgに注目 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | detailメソッドを確認 |

**主要処理フロー**:
1. **73-78行目**: detail()メソッドで画面表示（GET /monitor/operlog/detail/{operId}）
2. **77行目**: ModelMapにoperLogオブジェクトを設定

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | detail.html | `ruoyi-admin/src/main/resources/templates/monitor/operlog/detail.html` | フォーム構成、JSONView表示ロジック |

**主要処理フロー**:
- **9-14行目**: 操作模塊の表示（@dict.getLabelで辞書変換）
- **15-18行目**: 登録信息の連結表示
- **19-23行目**: 請求地址の連結表示
- **24-28行目**: 操作方法の表示
- **29-32行目**: 請求参数のJSON表示領域
- **33-36行目**: 返回参数のJSON表示領域
- **37-41行目**: 状態のラベル表示
- **42-46行目**: 異常信息の条件付き表示
- **52-66行目**: JSONViewの初期化ロジック（2000文字チェック）

### プログラム呼び出し階層図

```
SysOperlogController.detail()
    │
    └─ ISysOperLogService.selectOperLogById()
           └─ SysOperLogMapper.selectOperLogById()
                 └─ sys_oper_log(SELECT)
```

### データフロー図

```
[入力]               [処理]                    [出力]

operId(パス) ───▶ SysOperlogController.detail() ───▶ 画面表示
                  │
                  └─▶ ISysOperLogService.selectOperLogById()
                       └─▶ SysOperLogMapper
                            └─▶ sys_oper_log
                                 │
                                 └─▶ Thymeleaf
                                      ├─▶ @dict.getLabel（辞書変換）
                                      └─▶ JSONView（JSON整形）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | ソース | コントローラー |
| ISysOperLogService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysOperLogService.java` | ソース | サービスインターフェース |
| SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | ソース | ドメインクラス |
| detail.html | `ruoyi-admin/src/main/resources/templates/monitor/operlog/detail.html` | テンプレート | 画面テンプレート |
