# 画面設計書 6-メインコンテンツ

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「メインコンテンツ」の設計仕様を定義する。

### 本画面の処理概要

システム首頁のデフォルトコンテンツ領域として表示されるダッシュボード画面。システムの紹介情報、技術スタック、更新履歴、連絡先情報などを表示する。

**業務上の目的・背景**：ログイン直後にユーザーに表示される最初のコンテンツとして、システムの概要や更新情報を伝える役割を持つ。また、開発者向けの技術情報や連絡先も提供し、サポートへのアクセスを容易にしている。システムのバージョン情報やQRコード（モバイルアクセス用）も表示され、システム全体の入口として機能する。

**画面へのアクセス方法**：システム首頁のiframe内にデフォルトで表示される。サイドバーメニューの「首页」をクリックしても表示される。URL直接アクセスは `/system/main`。

**主要な操作・処理内容**：
1. システム情報の閲覧（バージョン、技術スタック）
2. 更新履歴の確認（アコーディオン形式で展開/折りたたみ）
3. 外部リンクへのアクセス（Gitee、公式サイト）
4. 連絡先情報の確認（QQ群、WeChat、支付宝）

**画面遷移**：
- 遷移元：システム首頁（デフォルト表示またはメニュー選択）
- 遷移先：外部サイト（Gitee、公式サイト）へのリンクのみ

**権限による表示制御**：本画面は表示専用であり、特別な権限制御は行われない。ログイン済みユーザーであれば誰でもアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログイン | 補助機能 | ログインユーザー情報の表示 |

## 画面種別

ダッシュボード（情報表示）

## URL/ルーティング

- GET `/system/main` - メインコンテンツの表示

## 入出力項目

本画面は入力項目を持たない（表示専用）。

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 挨拶 | 「Hello,Guest」 |
| QRコード | モバイルデバイス用アクセスQRコード |
| システム説明 | 若依後台管理框架の説明文 |
| バージョン | 現在のシステムバージョン（v4.x.x） |
| 無料オープンソースラベル | 「¥免費開源」バッジ |
| 外部リンク | 码云（Gitee）、公式サイトへのリンク |
| 技術選型 | 使用技術スタックの一覧 |
| 連絡情報 | 官网URL、QQ群一覧、WeChat、支付宝 |
| 更新日志 | バージョンごとの更新履歴（アコーディオン形式） |

## イベント仕様

### 1-外部リンククリック

1. 「访问码云」ボタン：新しいタブでGiteeリポジトリを開く
2. 「访问主页」ボタン：新しいタブでruoyi.vipを開く

### 2-更新日志アコーディオン操作

1. バージョン見出しをクリック
2. 対応するパネルを展開/折りたたみ
3. Bootstrapのcollapse機能による制御

### 3-ibox折りたたみ

1. ibox-titleの折りたたみアイコンをクリック
2. 対応するibox-contentを展開/折りたたみ

### 4-iboxクローズ

1. ibox-titleの×アイコンをクリック
2. 対応するibox全体を非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

本画面はデータベースを参照・更新しない。

## メッセージ仕様

本画面にメッセージ表示はない。

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| セッションタイムアウト | 親フレーム（システム首頁）がログイン画面にリダイレクト |

## 備考

- バージョン番号はRuoYiConfigから動的に取得される
- 更新履歴はHTMLに静的に記述されている
- QQ群のリンクは満員のグループは取り消し線で表示
- モバイル用QRコードは静的画像として配置

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | /system/mainのハンドリング |

**主要処理フロー**:
1. **133-138行目**: GET /system/main - バージョン情報をモデルに設定

#### Step 2: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.html | `ruoyi-admin/src/main/resources/templates/main.html` | ダッシュボードレイアウト、更新履歴 |

**主要処理フロー**:
- **1-57行目**: ヘッダー部（システム説明、技術スタック）
- **58-213行目**: コンテンツ部（連絡情報、更新履歴）

### プログラム呼び出し階層図

```
Browser: GET /system/main
    │
    └─ SysIndexController.main()
           │
           ├─ RuoYiConfig.getVersion() - バージョン取得
           │
           └─ return "main"
```

### データフロー図

```
[入力]               [処理]                    [出力]

(なし) ──────────▶ SysIndexController ──▶ Model {version}
                        │                          │
                        └─ RuoYiConfig             └──▶ main.html
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.html | `ruoyi-admin/src/main/resources/templates/main.html` | テンプレート | ダッシュボード画面 |
| SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | コントローラー | /system/mainエンドポイント |
| RuoYiConfig.java | `ruoyi-common/src/main/java/com/ruoyi/common/config/RuoYiConfig.java` | 設定 | バージョン情報等 |
| style.min.css | `ruoyi-admin/src/main/resources/static/css/style.min.css` | スタイル | iboxスタイル等 |
| qr_code.png | `ruoyi-admin/src/main/resources/static/img/qr_code.png` | 画像 | モバイル用QRコード |
