# 画面設計書 60-ログインログ一覧

## 概要

本ドキュメントは、RuoYi後台管理システムのログインログ一覧画面の設計仕様を記述したものである。

### 本画面の処理概要

ログインログ一覧画面は、システムへのログイン試行履歴を一覧表示する画面である。成功・失敗を問わず全てのログイン試行が記録され、セキュリティ監視や不正アクセスの検知に使用する。また、ロックされたアカウントの解除機能も提供する。

**業務上の目的・背景**：システムセキュリティにおいてログインの監視は最も重要な要素の一つである。本画面では、誰が、いつ、どこから、どのブラウザ・OSでログインを試みたかを追跡できる。連続したログイン失敗はアカウントロックにつながるため、正当なユーザーがロックされた場合の解除機能も提供する。

**画面へのアクセス方法**：システム首頁の左側メニューから「日志管理」→「登録日志」を選択することでアクセスできる。アクセスには`monitor:logininfor:view`権限が必要である。

**主要な操作・処理内容**：
1. ログインログ一覧の表示と検索（登録地址、登録名称、登録状態、登録時間での絞り込み）
2. ログの削除（個別/一括）
3. ログの全件清空
4. アカウントのロック解除
5. ログ一覧のExcelエクスポート

**画面遷移**：システム首頁から遷移し、画面内で全ての操作が完結する（詳細画面なし）。

**権限による表示制御**：`monitor:logininfor:remove`がない場合は削除・清空ボタン非表示、`monitor:logininfor:unlock`がない場合は解鎖ボタン非表示、`monitor:logininfor:export`がない場合は導出ボタン非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログインログ | 主機能 | ログインログ一覧表示、検索、削除、清空、アカウント解除処理 |
| 24 | ファイルダウンロード | 補助機能 | ログデータのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

| 操作 | メソッド | URL |
|------|----------|-----|
| 画面表示 | GET | /monitor/logininfor |
| 一覧データ取得 | POST | /monitor/logininfor/list |
| 削除 | POST | /monitor/logininfor/remove |
| 清空 | POST | /monitor/logininfor/clean |
| アカウント解鎖 | POST | /monitor/logininfor/unlock |
| Excelエクスポート | POST | /monitor/logininfor/export |

## 入出力項目

### 検索条件（入力項目）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 登録地址 | ipaddr | String | 任意 | IPアドレスの部分一致検索 |
| 登録名称 | loginName | String | 任意 | ログイン名の部分一致検索 |
| 登録状態 | status | String | 任意 | ステータスのプルダウン選択（辞書：sys_common_status） |
| 開始時間 | beginTime | Date | 任意 | ログイン時間の範囲検索（開始） |
| 終了時間 | endTime | Date | 任意 | ログイン時間の範囲検索（終了） |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 説明 |
|--------|--------|----------|--------|------|
| 選択チェックボックス | - | - | - | 一括操作用 |
| 訪問編号 | infoId | Long | - | ログID |
| 登録名称 | loginName | String | 可 | ログインユーザー名 |
| 登録地址 | ipaddr | String | - | クライアントIPアドレス（ツールチップ表示） |
| 登録地点 | loginLocation | String | - | ログイン地点（IP逆引き） |
| ブラウザ | browser | String | - | ブラウザ種別 |
| 操作系統 | os | String | - | オペレーティングシステム |
| 登録状態 | status | String | - | 0:成功（辞書ラベル）、1:失敗（辞書ラベル） |
| 操作信息 | msg | String | - | 結果メッセージ |
| 登録時間 | loginTime | DateTime | 可 | ログイン試行時刻 |

## イベント仕様

### 1-検索ボタン押下

検索フォームの入力内容をパラメータとしてサーバーに送信し、一覧を再表示する。

### 2-重置（リセット）ボタン押下

検索フォームの入力内容をクリアし、一覧を初期状態に戻す。

### 3-削除ボタン押下

1. チェックボックスで選択されたログを取得
2. 確認ダイアログを表示
3. OKの場合、選択されたログIDをカンマ区切りで送信
4. サーバー側でログレコードを削除
5. 処理完了後、一覧を再読み込み

### 4-清空ボタン押下

1. 確認ダイアログ「是否確認清空所有登録日志数据項?」を表示
2. OKの場合、全ログを削除
3. 処理完了後、一覧を再読み込み

### 5-解鎖（アカウント解除）ボタン押下

1. チェックボックスで選択されたレコードのloginNameを取得
2. 確認ダイアログを表示
3. OKの場合、該当ユーザーのログイン失敗キャッシュをクリア
4. 処理完了後、成功メッセージを表示

### 6-導出（エクスポート）ボタン押下

検索条件に合致するログ一覧をExcelファイルとしてダウンロードする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | sys_logininfor | SELECT | ログ情報の取得 |
| 削除 | sys_logininfor | DELETE | ログレコードの削除 |
| 清空 | sys_logininfor | TRUNCATE | 全ログレコードの削除 |
| 解鎖 | - | - | キャッシュクリアのみ（DB更新なし） |

### テーブル別更新項目詳細

#### sys_logininfor

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | info_id | 主キー | - |
| SELECT | ipaddr | LIKE '%検索値%' | 部分一致 |
| SELECT | login_name | LIKE '%検索値%' | 部分一致 |
| SELECT | status | = 検索値 | 完全一致 |
| SELECT | login_time | BETWEEN 開始 AND 終了 | 範囲検索 |
| DELETE | info_id | IN (選択ID) | 削除時 |
| TRUNCATE | - | - | 清空時 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| 確認 | 是否確認清空所有登録日志数据項? | 清空ボタン押下時 |
| 成功 | 操作成功 | 処理正常完了時 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| 権限不足 | 403エラー画面に遷移 |
| サーバーエラー | 500エラー画面に遷移 |

## 備考

- デフォルトソートはログイン時間の降順
- 解鎖機能はSysPasswordServiceのclearLoginRecordCacheメソッドを呼び出してキャッシュをクリア
- ログイン失敗が一定回数を超えるとアカウントがロックされる（キャッシュベース）
- 清空操作はTRUNCATE TABLEを使用するため、ロールバック不可
- 本画面には詳細画面が存在しない（一覧で全情報が確認可能）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | infoId、loginName、status、ipaddr、loginLocation、browser、os、msg、loginTimeなどのフィールド定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysLogininforController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java` | 画面表示、一覧取得、削除、清空、解鎖のエンドポイントを確認 |

**主要処理フロー**:
1. **38-43行目**: logininfor()メソッドで画面表示（GET /monitor/logininfor）
2. **45-53行目**: list()メソッドでページング付き一覧取得（POST /monitor/logininfor/list）
3. **66-73行目**: remove()メソッドでログ削除
4. **75-82行目**: clean()メソッドで全ログ清空
5. **85-93行目**: unlock()メソッドでアカウント解鎖

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysLogininforService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysLogininforService.java` | サービスインターフェースの定義 |
| 3-2 | SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | clearLoginRecordCacheメソッドを確認 |

#### Step 4: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | logininfor.html | `ruoyi-admin/src/main/resources/templates/monitor/logininfor/logininfor.html` | Bootstrap Table初期化、検索フォーム、各種ボタンのイベントハンドラ、unlock関数 |

**主要処理フロー**:
- **66-130行目**: Bootstrap Tableの初期化と列定義
- **112-117行目**: statusの辞書変換表示
- **141-143行目**: unlock関数（アカウント解鎖）

### プログラム呼び出し階層図

```
SysLogininforController
    │
    ├─ list() → ISysLogininforService.selectLogininforList()
    │              └─ SysLogininforMapper.selectLogininforList()
    │
    ├─ remove() → ISysLogininforService.deleteLogininforByIds()
    │              └─ SysLogininforMapper.deleteLogininforByIds()
    │
    ├─ clean() → ISysLogininforService.cleanLogininfor()
    │              └─ SysLogininforMapper.cleanLogininfor()
    │
    └─ unlock() → SysPasswordService.clearLoginRecordCache()
                    └─ Redis/Ehcache キャッシュクリア
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysLogininforController ───▶ JSON(TableDataInfo)
(ipaddr,       └─▶ ISysLogininforService
 loginName,         └─▶ SysLogininforMapper
 status,                 └─▶ sys_logininfor
 beginTime,
 endTime)

ログID ───▶ remove() ───▶ AjaxResult
            └─▶ SysLogininforMapper
                 └─▶ sys_logininfor(DELETE)

清空要求 ───▶ clean() ───▶ AjaxResult
             └─▶ SysLogininforMapper
                  └─▶ sys_logininfor(TRUNCATE)

loginName ───▶ unlock() ───▶ AjaxResult
              └─▶ SysPasswordService
                   └─▶ キャッシュクリア
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysLogininforController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java` | ソース | コントローラー |
| ISysLogininforService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysLogininforService.java` | ソース | サービスインターフェース |
| SysLogininforServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysLogininforServiceImpl.java` | ソース | サービス実装 |
| SysLogininforMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysLogininforMapper.java` | ソース | Mapperインターフェース |
| SysLogininforMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysLogininforMapper.xml` | 設定 | SQLマッピング |
| SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ソース | ドメインクラス |
| SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | ソース | パスワードサービス |
| logininfor.html | `ruoyi-admin/src/main/resources/templates/monitor/logininfor/logininfor.html` | テンプレート | 画面テンプレート |
