# 画面設計書 61-サーバー監視

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるサーバー監視画面の設計仕様を定義するものである。

### 本画面の処理概要

サーバー監視画面は、システム管理者がサーバーのリソース状況をリアルタイムで把握するための監視画面である。

**業務上の目的・背景**：システム運用において、サーバーのリソース使用状況（CPU、メモリ、ディスク等）を監視することは、パフォーマンス問題の早期発見や障害予防に不可欠である。本画面では、OSHIライブラリを活用してサーバー情報を取得し、直感的なUIで表示することで、運用担当者が迅速に状況を把握できるようにしている。使用率が80%を超える項目は赤字で警告表示される。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム監視」→「サーバー監視」を選択してアクセスする。アクセスには`monitor:server:view`権限が必要である。

**主要な操作・処理内容**：
1. CPU情報の確認（コア数、ユーザー使用率、システム使用率、空き率）
2. メモリ情報の確認（物理メモリとJVMメモリの総量、使用量、空き量、使用率）
3. サーバー情報の確認（サーバー名、OS名、IP、アーキテクチャ）
4. JVM情報の確認（Java名称、バージョン、起動時間、運行時間、パス等）
5. ディスク情報の確認（各ドライブの容量、使用状況）
6. パネルの折りたたみ・展開（各情報ブロックの表示切替）
7. パネルの非表示（閉じるボタンで一時的に非表示）

**画面遷移**：本画面は参照専用であり、他画面への遷移機能は持たない。システム首頁のメニューから本画面に遷移する。

**権限による表示制御**：`monitor:server:view`権限を持つユーザーのみがこの画面にアクセス可能。権限がない場合はアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | サーバー監視 | 主機能 | CPU、メモリ、JVM、ディスク情報の表示処理 |

## 画面種別

参照（監視ダッシュボード）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /monitor/server | サーバー監視画面表示 |

## 入出力項目

本画面は参照専用であり、入力項目は存在しない。

## 表示項目

### CPU情報パネル

| 項目名 | データ型 | 説明 | 対応フィールド |
|--------|---------|------|---------------|
| 核心数 | 整数 | CPUの論理プロセッサ数 | server.cpu.cpuNum |
| 用户使用率 | パーセント | ユーザー空間でのCPU使用率 | server.cpu.used |
| 系统使用率 | パーセント | システム空間でのCPU使用率 | server.cpu.sys |
| 当前空闲率 | パーセント | CPUのアイドル率 | server.cpu.free |

### メモリ情報パネル

| 項目名 | データ型 | 説明 | 対応フィールド |
|--------|---------|------|---------------|
| 总内存（メモリ） | 文字列 | 物理メモリ総量（GB単位） | server.mem.total |
| 总内存（JVM） | 文字列 | JVMメモリ総量（MB単位） | server.jvm.total |
| 已用内存（メモリ） | 文字列 | 使用中の物理メモリ | server.mem.used |
| 已用内存（JVM） | 文字列 | 使用中のJVMメモリ | server.jvm.used |
| 剩余内存（メモリ） | 文字列 | 空き物理メモリ | server.mem.free |
| 剩余内存（JVM） | 文字列 | 空きJVMメモリ | server.jvm.free |
| 使用率（メモリ） | パーセント | 物理メモリ使用率（80%超で赤表示） | server.mem.usage |
| 使用率（JVM） | パーセント | JVMメモリ使用率（80%超で赤表示） | server.jvm.usage |

### サーバー情報パネル

| 項目名 | データ型 | 説明 | 対応フィールド |
|--------|---------|------|---------------|
| 服务器名称 | 文字列 | ホスト名 | server.sys.computerName |
| 操作系统 | 文字列 | OS名称 | server.sys.osName |
| 服务器IP | 文字列 | サーバーのIPアドレス | server.sys.computerIp |
| 系统架构 | 文字列 | OSアーキテクチャ | server.sys.osArch |

### JVM情報パネル

| 項目名 | データ型 | 説明 | 対応フィールド |
|--------|---------|------|---------------|
| Java名称 | 文字列 | JVMの名称 | server.jvm.name |
| Java版本 | 文字列 | Javaバージョン | server.jvm.version |
| 启动时间 | 日時 | JVM起動日時 | server.jvm.startTime |
| 运行时长 | 文字列 | JVM稼働時間 | server.jvm.runTime |
| 安装路径 | 文字列 | Javaインストールパス | server.jvm.home |
| 项目路径 | 文字列 | プロジェクトディレクトリ | server.sys.userDir |
| 运行参数 | 文字列 | JVM起動引数 | server.jvm.inputArgs |

### ディスク情報パネル

| 項目名 | データ型 | 説明 | 対応フィールド |
|--------|---------|------|---------------|
| 盘符路径 | 文字列 | マウントパス | sysFile.dirName |
| 文件系统 | 文字列 | ファイルシステム種別 | sysFile.sysTypeName |
| 盘符类型 | 文字列 | ドライブタイプ | sysFile.typeName |
| 总大小 | 文字列 | ディスク総容量 | sysFile.total |
| 可用大小 | 文字列 | 空き容量 | sysFile.free |
| 已用大小 | 文字列 | 使用容量 | sysFile.used |
| 已用百分比 | パーセント | 使用率（80%超で赤表示） | sysFile.usage |

## イベント仕様

### 1-パネル折りたたみ

パネルのタイトル右側にある折りたたみアイコン（chevron-up/down）をクリックすると、パネルのコンテンツ部分がスライドトグルで表示/非表示を切り替える。

- **トリガー**: `.collapse-link`クリック
- **処理**: `ibox-content`要素を`slideToggle(200)`でアニメーション表示切替
- **アイコン切替**: `fa-chevron-up` ⇔ `fa-chevron-down`

### 2-パネル閉じる

パネルのタイトル右側にある×アイコンをクリックすると、パネル全体がDOM上から削除される。

- **トリガー**: `.close-link`クリック
- **処理**: 最も近い`.ibox`要素を`remove()`で削除
- **注意**: ページ再読み込みで復元

## データベース更新仕様

### 操作別データベース影響一覧

本画面はサーバー情報をリアルタイムで取得・表示するのみで、データベースへのアクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | OSHIライブラリでシステム情報取得（DBアクセスなし） |

## メッセージ仕様

本画面は参照専用のため、特定のメッセージ表示機能は実装されていない。

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 権限不足 | 403エラー画面へリダイレクト |
| サーバー情報取得エラー | Exception発生時は500エラー |

## 備考

- 本画面はOSHIライブラリを使用してシステム情報を取得している
- CPU使用率取得時に1秒のウェイトが発生する（`OSHI_WAIT_SECOND = 1000`）
- メモリ・ディスク使用率が80%を超える場合、赤字（`text-danger`クラス）で警告表示される
- 各パネルは折りたたみ可能で、閉じるボタンで非表示にできる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

サーバー情報を格納するドメインクラス群を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Server.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java` | サーバー情報のルートクラス。CPU, Mem, Jvm, Sys, SysFile各オブジェクトを保持 |
| 1-2 | Cpu.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Cpu.java` | CPU情報クラス（コア数、使用率等） |
| 1-3 | Mem.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Mem.java` | メモリ情報クラス（総量、使用量等） |
| 1-4 | Jvm.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Jvm.java` | JVM情報クラス（バージョン、パス等） |
| 1-5 | Sys.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Sys.java` | システム情報クラス（ホスト名、OS等） |
| 1-6 | SysFile.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/SysFile.java` | ディスク情報クラス（容量、使用率等） |

**読解のコツ**: `Server.java`の`copyTo()`メソッドがエントリーポイントとなり、各種情報を収集してプロパティに設定する流れを追う。

#### Step 2: エントリーポイントを理解する

コントローラクラスでリクエストを受け付け、サーバー情報を収集する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ServerController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/ServerController.java` | サーバー監視のコントローラ。`@RequiresPermissions`で権限チェック |

**主要処理フロー**:
1. **24行目**: `server()`メソッドがGETリクエストを処理
2. **26行目**: `new Server()`でサーバー情報オブジェクトを生成
3. **27行目**: `server.copyTo()`でシステム情報を収集
4. **28行目**: `mmap.put("server", server)`でテンプレートにデータを渡す
5. **29行目**: `server.html`テンプレートを返却

#### Step 3: サーバー情報収集処理を理解する

OSHIライブラリを使用してシステム情報を収集する処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Server.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java` | `copyTo()`メソッドで各種情報を収集 |

**主要処理フロー**:
- **111行目**: `SystemInfo`を生成し、ハードウェア情報を取得
- **114行目**: `setCpuInfo()`でCPU使用率を計算
- **116行目**: `setMemInfo()`で物理メモリ情報を取得
- **118行目**: `setSysInfo()`でOS・ホスト情報を取得
- **120行目**: `setJvmInfo()`でJVM情報を取得
- **122行目**: `setSysFiles()`でディスク情報を取得

#### Step 4: ビューテンプレートを理解する

Thymeleafテンプレートで画面を構成する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | server.html | `ruoyi-admin/src/main/resources/templates/monitor/server/server.html` | Thymeleafテンプレート。`th:text`でサーバー情報を表示 |

**主要処理フロー**:
- **31行目**: `${server.cpu.cpuNum}`でCPUコア数を表示
- **87-88行目**: 使用率が80%超の場合に`text-danger`クラスを適用（条件付きスタイル）
- **221行目**: `th:each`でディスク情報をループ表示
- **243-256行目**: パネル折りたたみ/閉じるのJavaScript処理

### プログラム呼び出し階層図

```
GET /monitor/server
    │
    └─ ServerController.server()
           │
           ├─ new Server()
           │
           └─ Server.copyTo()
                  │
                  ├─ setCpuInfo(processor)    ← OSHI: CentralProcessor
                  │      └─ CPU tick値を取得・使用率計算
                  │
                  ├─ setMemInfo(memory)       ← OSHI: GlobalMemory
                  │      └─ 物理メモリ総量・空き容量取得
                  │
                  ├─ setSysInfo()             ← System.getProperties()
                  │      └─ OS名、ホスト名、IP取得
                  │
                  ├─ setJvmInfo()             ← Runtime.getRuntime()
                  │      └─ JVMメモリ、バージョン取得
                  │
                  └─ setSysFiles(os)          ← OSHI: FileSystem
                         └─ 各ドライブの容量・使用率取得
```

### データフロー図

```
[入力]               [処理]                    [出力]

なし ─────────▶ ServerController ─────────▶ server.html
                     │
                     ▼
                Server.copyTo()
                     │
      ┌──────────────┼──────────────┐
      ▼              ▼              ▼
 OSHIライブラリ  System.getProperties  Runtime
      │              │              │
      ▼              ▼              ▼
  ハードウェア情報  システム情報     JVM情報
      │              │              │
      └──────────────┼──────────────┘
                     ▼
              Serverオブジェクト
                     │
                     ▼
             Thymeleafテンプレート
                     │
                     ▼
               HTML画面出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ServerController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/ServerController.java` | ソース | コントローラ（画面表示処理） |
| Server.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java` | ソース | サーバー情報ドメイン（メイン） |
| Cpu.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Cpu.java` | ソース | CPU情報ドメイン |
| Mem.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Mem.java` | ソース | メモリ情報ドメイン |
| Jvm.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Jvm.java` | ソース | JVM情報ドメイン |
| Sys.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Sys.java` | ソース | システム情報ドメイン |
| SysFile.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/SysFile.java` | ソース | ディスク情報ドメイン |
| server.html | `ruoyi-admin/src/main/resources/templates/monitor/server/server.html` | テンプレート | 画面テンプレート |
| IpUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/IpUtils.java` | ソース | IP/ホスト名取得ユーティリティ |
| Arith.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/Arith.java` | ソース | 算術計算ユーティリティ |
