# 画面設計書 62-キャッシュ監視

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるキャッシュ監視画面の設計仕様を定義するものである。

### 本画面の処理概要

キャッシュ監視画面は、システム管理者がアプリケーションのキャッシュ状況を確認・管理するための画面である。

**業務上の目的・背景**：Webアプリケーションではパフォーマンス向上のためにキャッシュを多用するが、キャッシュの状態を可視化し、必要に応じてクリアできる機能は運用上非常に重要である。本画面では、キャッシュ名一覧、キー一覧、キャッシュ内容の3カラムレイアウトで構成され、階層的にキャッシュ内容を確認・管理できる。認証キャッシュ（SYS_AUTH_CACHE）はセキュリティ上の理由から一覧に表示されない。

**画面へのアクセス方法**：システム首頁の左側メニューから「システム監視」→「キャッシュ監視」を選択してアクセスする。アクセスには`monitor:cache:view`権限が必要である。

**主要な操作・処理内容**：
1. キャッシュ名一覧の表示・更新
2. 選択したキャッシュ名に対応するキー一覧の表示
3. 選択したキャッシュキーの内容（値）の表示
4. 特定のキャッシュ名に属する全キーのクリア
5. 特定のキャッシュキーのクリア
6. 全キャッシュの一括クリア

**画面遷移**：本画面は参照・操作専用であり、他画面への遷移機能は持たない。システム首頁のメニューから本画面に遷移する。

**権限による表示制御**：`monitor:cache:view`権限を持つユーザーのみがこの画面にアクセス可能。権限がない場合はアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | キャッシュ監視 | 主機能 | キャッシュ一覧表示、キー取得、値取得、クリア処理 |

## 画面種別

一覧・詳細（3カラム構成の監視・管理画面）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /monitor/cache | キャッシュ監視画面表示 |
| POST | /monitor/cache/getNames | キャッシュ名一覧の更新取得 |
| POST | /monitor/cache/getKeys | キー一覧の取得 |
| POST | /monitor/cache/getValue | キャッシュ値の取得 |
| POST | /monitor/cache/clearCacheName | 特定キャッシュ名のクリア |
| POST | /monitor/cache/clearCacheKey | 特定キーのクリア |
| GET | /monitor/cache/clearAll | 全キャッシュクリア |

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| cacheName | 文字列 | ○ | キャッシュ名（キー一覧取得・クリア時） |
| cacheKey | 文字列 | ○ | キャッシュキー（値取得・キークリア時） |

## 表示項目

### キャッシュ名一覧パネル（左カラム）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 連番 | 整数 | 行番号（1から連番） |
| 缓存名称 | 文字列 | キャッシュ名（クリック可能） |
| 操作 | ボタン | 削除アイコン（ゴミ箱） |

### キー名一覧パネル（中央カラム）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 連番 | 整数 | 行番号（1から連番） |
| 缓存键名 | 文字列 | キャッシュキー名（クリック可能） |
| 操作 | ボタン | 削除アイコン（ゴミ箱） |

### キャッシュ内容パネル（右カラム）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 缓存名称 | 文字列 | 選択中のキャッシュ名（読み取り専用） |
| 缓存键名 | 文字列 | 選択中のキーン名（読み取り専用） |
| 缓存内容 | 文字列 | キャッシュの値（テキストエリア、読み取り専用） |

## イベント仕様

### 1-キャッシュ名一覧更新

キャッシュ名一覧パネルのリフレッシュアイコンをクリックすると、最新のキャッシュ名一覧を取得して表示を更新する。

- **トリガー**: リフレッシュアイコン（`fa-refresh`）クリック
- **API**: POST `/monitor/cache/getNames`
- **処理**: Ajax通信でキャッシュ名一覧を取得し、`#cacheNames`要素を更新
- **成功メッセージ**: "刷新缓存列表成功"

### 2-キー一覧取得

キャッシュ名一覧からキャッシュ名をクリックすると、そのキャッシュに属するキー一覧を取得して表示する。

- **トリガー**: キャッシュ名セルのクリック
- **API**: POST `/monitor/cache/getKeys`
- **パラメータ**: `cacheName`（クリックしたキャッシュ名）
- **処理**: Ajax通信でキー一覧を取得し、`#cacheKeys`要素を更新、隠しフィールドに`cacheName`を保存

### 3-キー一覧更新

キー名一覧パネルのリフレッシュアイコンをクリックすると、現在選択中のキャッシュ名に対応するキー一覧を再取得する。

- **トリガー**: リフレッシュアイコン（`fa-refresh`）クリック
- **API**: POST `/monitor/cache/getKeys`
- **処理**: 隠しフィールドの`cacheName`を使用してキー一覧を更新
- **成功メッセージ**: "刷新键名列表成功"

### 4-キャッシュ値取得

キー一覧からキー名をクリックすると、そのキーに対応するキャッシュ値を取得して表示する。

- **トリガー**: キー名セルのクリック
- **API**: POST `/monitor/cache/getValue`
- **パラメータ**: `cacheName`, `cacheKey`
- **処理**: Ajax通信でキャッシュ値を取得し、`#cacheValue`要素を更新

### 5-キャッシュ名クリア

キャッシュ名一覧の削除アイコンをクリックすると、そのキャッシュ名に属する全キーをクリアする。

- **トリガー**: ゴミ箱アイコン（`fa-trash-o`）クリック
- **API**: POST `/monitor/cache/clearCacheName`
- **パラメータ**: `cacheName`
- **成功メッセージ**: "清理缓存[キャッシュ名]成功"
- **後処理**: キー一覧を更新

### 6-キャッシュキークリア

キー一覧の削除アイコンをクリックすると、そのキーをクリアする。

- **トリガー**: ゴミ箱アイコン（`fa-trash-o`）クリック
- **API**: POST `/monitor/cache/clearCacheKey`
- **パラメータ**: `cacheName`, `cacheKey`
- **成功メッセージ**: "清理缓存[キー名]成功"
- **後処理**: キー一覧を更新

### 7-全キャッシュクリア

右カラムの「清理全部」リンクをクリックすると、全キャッシュをクリアする。

- **トリガー**: 「清理全部」リンククリック
- **API**: GET `/monitor/cache/clearAll`
- **成功メッセージ**: "清理全部缓存成功"

## データベース更新仕様

### 操作別データベース影響一覧

本画面はメモリ上のキャッシュを操作するのみで、データベースへの直接アクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 全操作 | - | - | CacheUtilsを通じたEhcacheのメモリキャッシュ操作（DBアクセスなし） |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| MSG-001 | 刷新缓存列表成功 | 成功 | キャッシュ名一覧更新成功時 |
| MSG-002 | 刷新键名列表成功 | 成功 | キー一覧更新成功時 |
| MSG-003 | 清理缓存[{name}]成功 | 成功 | キャッシュ名クリア成功時 |
| MSG-004 | 清理缓存[{key}]成功 | 成功 | キーク���ア成功時 |
| MSG-005 | 清理全部缓存成功 | 成功 | 全キャッシュクリア成功時 |
| MSG-ERR | {エラーメッセージ} | エラー | 各操作失敗時 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 権限不足 | 403エラー画面へリダイレクト |
| キャッシュ名が存在しない | エラーメッセージを表示 |
| Ajax通信エラー | エラーメッセージを表示 |

## 備考

- 認証キャッシュ（`SYS_AUTH_CACHE`）はセキュリティ上の理由から一覧に表示されない
- キャッシュの実装はEhcacheを使用（CacheUtilsクラス経由）
- キャッシュ値は文字列として表示されるため、オブジェクトの場合はJSON形式等で表示される
- Thymeleafのfragment機能を使用してAjax更新を実現している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

キャッシュ操作に使用するユーティリティクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/CacheUtils.java` | Ehcacheへのアクセスを抽象化したユーティリティ。getCacheNames(), getCache(), get(), remove()等のメソッド |

**読解のコツ**: CacheUtilsがEhcacheのCacheManagerをラップしており、キャッシュの取得・削除操作を提供している。

#### Step 2: エントリーポイントを理解する

コントローラクラスで各種リクエストを処理する流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CacheController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java` | キャッシュ監視のコントローラ。7つのエンドポイントを提供 |

**主要処理フロー**:
1. **31行目**: `cache()`メソッドが初期画面表示を処理
2. **39行目**: `getCacheNames()`がキャッシュ名一覧を返却（fragment形式）
3. **47行目**: `getCacheKeys()`が指定キャッシュのキー一覧を返却
4. **56行目**: `getCacheValue()`がキャッシュ値を返却
5. **66行目**: `clearCacheName()`が指定キャッシュをクリア
6. **75行目**: `clearCacheKey()`が指定キーをクリア
7. **84行目**: `clearAll()`が全キャッシュをクリア

#### Step 3: サービス層を理解する

キャッシュ操作のビジネスロジックを提供するサービスクラスを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CacheService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/CacheService.java` | キャッシュ操作のサービス層。CacheUtilsを使用して各種操作を実行 |

**主要処理フロー**:
- **23-27行目**: `getCacheNames()`でキャッシュ名一覧を取得（SYS_AUTH_CACHEを除外）
- **35-38行目**: `getCacheKeys()`で指定キャッシュのキー一覧をTreeSetで返却
- **47-50行目**: `getCacheValue()`でキャッシュ値を取得
- **57-60行目**: `clearCacheName()`で指定キャッシュの全キーをクリア
- **68-71行目**: `clearCacheKey()`で指定キーをクリア
- **76-83行目**: `clearAll()`で全キャッシュをクリア

#### Step 4: ビューテンプレートを理解する

Thymeleafテンプレートで画面を構成する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cache.html | `ruoyi-admin/src/main/resources/templates/monitor/cache/cache.html` | 3カラムレイアウトのテンプレート。fragmentを使用したAjax部分更新 |

**主要処理フロー**:
- **8行目**: 隠しフィールドで選択中のcacheNameを保持
- **29行目**: `th:fragment="fragment-cache-names"`でキャッシュ名一覧のfragment定義
- **57行目**: `th:fragment="fragment-cache-kyes"`でキー一覧のfragment定義
- **78行目**: `th:fragment="fragment-cache-value"`でキャッシュ値表示のfragment定義
- **104-177行目**: JavaScript関数群（getCacheNames, getCacheKeys, getCacheValue, clearCacheName, clearCacheKey, clearAll）

### プログラム呼び出し階層図

```
GET /monitor/cache
    │
    └─ CacheController.cache()
           │
           └─ CacheService.getCacheNames()
                  │
                  └─ CacheUtils.getCacheNames()
                         └─ Ehcache CacheManager

POST /monitor/cache/getKeys
    │
    └─ CacheController.getCacheKeys()
           │
           └─ CacheService.getCacheKeys()
                  │
                  └─ CacheUtils.getCache(cacheName).keys()

POST /monitor/cache/getValue
    │
    └─ CacheController.getCacheValue()
           │
           └─ CacheService.getCacheValue()
                  │
                  └─ CacheUtils.get(cacheName, cacheKey)

POST /monitor/cache/clearCacheName
    │
    └─ CacheController.clearCacheName()
           │
           └─ CacheService.clearCacheName()
                  │
                  └─ CacheUtils.removeAll(cacheName)

POST /monitor/cache/clearCacheKey
    │
    └─ CacheController.clearCacheKey()
           │
           └─ CacheService.clearCacheKey()
                  │
                  └─ CacheUtils.remove(cacheName, cacheKey)

GET /monitor/cache/clearAll
    │
    └─ CacheController.clearAll()
           │
           └─ CacheService.clearAll()
                  │
                  └─ CacheUtils.removeAll() ×N回（全キャッシュ名に対して）
```

### データフロー図

```
[入力]               [処理]                    [出力]

cacheName ────▶ CacheController ────────▶ HTML Fragment
cacheKey          │                         (部分更新)
                  ▼
             CacheService
                  │
                  ▼
             CacheUtils
                  │
                  ▼
          Ehcache CacheManager
                  │
    ┌─────────────┼─────────────┐
    ▼             ▼             ▼
 キャッシュ名   キー一覧    キャッシュ値
    │             │             │
    └─────────────┼─────────────┘
                  ▼
         Thymeleaf Fragment
                  │
                  ▼
            Ajax部分更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CacheController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java` | ソース | コントローラ（7エンドポイント） |
| CacheService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/CacheService.java` | ソース | キャッシュ操作サービス |
| CacheUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/CacheUtils.java` | ソース | Ehcacheアクセスユーティリティ |
| Constants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` | ソース | SYS_AUTH_CACHE定数定義 |
| cache.html | `ruoyi-admin/src/main/resources/templates/monitor/cache/cache.html` | テンプレート | 画面テンプレート |
| ehcache.xml | `ruoyi-admin/src/main/resources/ehcache/ehcache.xml` | 設定 | Ehcache設定ファイル |
