# 画面設計書 63-フォームビルダー

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるフォームビルダー画面の設計仕様を定義するものである。

### 本画面の処理概要

フォームビルダー画面は、ドラッグ＆ドロップ操作によりフォームを視覚的に構築し、HTMLコードを自動生成するツール画面である。

**業務上の目的・背景**：開発者がフォームのHTMLコードを手作業で書く代わりに、GUIベースで直感的にフォームを設計できる。これにより、プロトタイピングの高速化、デザインの統一性確保、非エンジニアによるフォーム設計の支援が可能となる。生成されたHTMLコードはBootstrap CSSフレームワークに準拠しており、そのまま本システムのフォームとして利用可能。

**画面へのアクセス方法**：システム首頁の左側メニューから「システムツール」→「フォームビルダー」を選択してアクセスする。

**主要な操作・処理内容**：
1. 左側パネルから各種フォーム要素（テキストボックス、セレクトボックス等）をドラッグ
2. 右側のドロップエリアにドロップしてフォームを構築
3. ドロップした要素の順序をドラッグ＆ドロップで並び替え
4. 各要素のHTMLを編集してカスタマイズ
5. 不要な要素を削除
6. 表示列数を切り替え（1列/2列）
7. 生成されたHTMLコードをコピー

**画面遷移**：本画面はスタンドアローンのツール画面であり、他画面への遷移機能は持たない。システム首頁のメニューから本画面に遷移する。

**権限による表示制御**：特定の権限チェックは行われていない。システムメニューからアクセス可能なユーザーが使用できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | コード生成 | 補助機能 | ドラッグ&ドロップによるフォーム作成ツール |

## 画面種別

ツール（フォームビルダー）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /tool/build | フォームビルダー画面表示 |

## 入出力項目

本画面はクライアントサイドのみで動作し、サーバーとの通信は行わない。

## 表示項目

### 左側パネル（要素パレット）

| 要素タイプ | 説明 | ラベル |
|-----------|------|--------|
| 文本框 | テキスト入力フィールド | 文本框 |
| 多行文本框 | 複数行テキスト入力（textarea） | 多行文本框 |
| 密码框 | パスワード入力フィールド | 密码框 |
| 下拉框 | セレクトボックス | 下拉框 |
| 纯文本 | 静的テキスト表示 | 纯文本 |
| 单选框 | ラジオボタングループ | 单选框 |
| 复选框 | チェックボックスグループ | 复选框 |
| 切换按钮 | トグルスイッチ | 切换按钮 |
| 日期选择 | 日付選択フィールド | 日期选择 |
| 提交/关闭按钮 | 送信・閉じるボタン | 提交/关闭 |

### 右側パネル（構築エリア）

| 項目名 | 説明 |
|--------|------|
| 列数選択 | 表示列数の切り替え（1列/2列） |
| ドロップエリア | フォーム要素の配置エリア（sortable） |
| コピーボタン | 生成されたHTMLをクリップボードにコピー |

## イベント仕様

### 1-要素ドラッグ＆ドロップ

左側パレットから要素をドラッグし、右側エリアにドロップする。

- **トリガー**: `.draggable`要素をドラッグして`.droppable`エリアにドロップ
- **処理**:
  1. 元の要素をクローン
  2. クローンに`dropped`クラスを付与
  3. ドロップエリアに追加
  4. 編集/削除リンクを追加
  5. ラジオボタン・チェックボックスの場合はHTML構造を再構築
- **ライブラリ**: jQuery UI（draggable, droppable）

### 2-要素の並び替え

ドロップエリア内で要素をドラッグして順序を変更する。

- **トリガー**: `.droppable`エリア内で要素をドラッグ
- **処理**: jQuery UI sortableにより順序を変更
- **注意**: 異なるカラム間での移動も可能

### 3-列数切り替え

表示列数を1列または2列に切り替える。

- **トリガー**: `#n-columns`セレクトボックスの変更
- **処理**:
  - 1列選択時: `col-md-12`を表示、`col-md-6`を非表示、要素を`col-md-12`に移動
  - 2列選択時: `col-md-6`×2を表示、`col-md-12`を非表示、要素を交互に振り分け

### 4-HTML編集

各要素の「編集HTML」リンクをクリックしてHTMLを編集する。

- **トリガー**: `.edit-link`クリック
- **処理**:
  1. モーダルダイアログを表示
  2. 現在のHTML（美化済み）をテキストエリアに表示
  3. 「更新HTML」ボタンでHTMLを適用
  4. 空のHTMLを適用すると要素を削除

### 5-要素削除

各要素の「移除」リンクをクリックして要素を削除する。

- **トリガー**: `.remove-link`クリック
- **処理**: 親要素（`.form-group`）をDOMから削除

### 6-コードコピー

「复制代码」ボタンをクリックして生成されたHTMLをコピーする。

- **トリガー**: `#copy-to-clipboard`ボタンクリック
- **処理**:
  1. フォーム領域をクローン
  2. 不要なクラス・スタイル・要素（tools, hidden）を削除
  3. html_beautifyでHTML整形
  4. モーダルダイアログでコードを表示

## データベース更新仕様

### 操作別データベース影響一覧

本画面はクライアントサイドのみで動作し、データベースへのアクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 全操作 | - | - | クライアントサイドのみ（DBアクセスなし） |

## メッセージ仕様

本画面では特定のメッセージ表示機能は実装されていない。

## 例外処理

クライアントサイドのみで動作するため、サーバーサイドの例外処理は存在しない。

## 備考

- jQuery UI（draggable, droppable, sortable）を使用してドラッグ＆ドロップ機能を実現
- beautifyhtml.jsを使用してHTMLコードを整形
- datetimepickerプラグインを使用して日付選択を実現
- 生成されるHTMLはBootstrap 3のform-horizontalレイアウトに準拠
- サーバーとの通信は行わず、完全にクライアントサイドで動作する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

本画面は単一のHTMLファイルで完結しているため、テンプレートから読み始める。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | build.html | `ruoyi-admin/src/main/resources/templates/tool/build/build.html` | フォームビルダーのメインテンプレート。HTMLとJavaScript |

**読解のコツ**: HTMLパート（1-160行目）とJavaScriptパート（164行目以降）に分けて理解する。

#### Step 2: HTML構造を理解する

左側パレットと右側ドロップエリアの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build.html | `ruoyi-admin/src/main/resources/templates/tool/build/build.html` | 左側col-sm-5（要素パレット）、右側col-sm-7（ドロップエリア）のレイアウト |

**主要処理フロー**:
- **13-131行目**: 左側パネル（要素パレット）- 各種フォーム要素を`.draggable`クラスで定義
- **132-158行目**: 右側パネル - 列数選択セレクトと3つのドロップエリア（1列用と2列用×2）
- **154行目**: 「复制代码」ボタン

#### Step 3: JavaScript処理を理解する

ドラッグ＆ドロップ機能の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build.html | `ruoyi-admin/src/main/resources/templates/tool/build/build.html` | setup_draggable関数とイベントハンドラ |

**主要処理フロー**:
- **165行目**: `setup_draggable()`で初期設定
- **165行目内**: `$(".draggable").draggable()`でドラッグ設定
- **165行目内**: `$(".droppable").droppable()`でドロップ設定
- **165行目内**: `.sortable()`でソート設定
- **165行目内**: `#n-columns`の`change`イベントで列数切り替え
- **165行目内**: `#copy-to-clipboard`の`click`イベントでコードコピー
- **165行目内**: `get_modal()`でモーダルダイアログ生成
- **165行目内**: `.edit-link`クリックでHTML編集モーダル表示
- **165行目内**: `.remove-link`クリックで要素削除

#### Step 4: 外部ライブラリを理解する

使用している外部ライブラリの役割を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | jquery-ui-1.10.4.min.js | `ruoyi-admin/src/main/resources/static/js/jquery-ui-1.10.4.min.js` | ドラッグ＆ドロップ、ソート機能 |
| 4-2 | beautifyhtml.js | `ruoyi-admin/src/main/resources/static/ajax/libs/beautifyhtml/beautifyhtml.js` | HTML整形ライブラリ |
| 4-3 | datetimepicker | 共通インクルード | 日付選択プラグイン |

### プログラム呼び出し階層図

```
ブラウザ
    │
    └─ build.html
           │
           ├─ jQuery UI
           │      ├─ .draggable() ← 左側パレット要素
           │      ├─ .droppable() ← 右側ドロップエリア
           │      └─ .sortable()  ← ドロップエリア内ソート
           │
           ├─ beautifyhtml.js
           │      └─ html_beautify() ← コードコピー時のHTML整形
           │
           ├─ datetimepicker
           │      └─ 日付選択要素の初期化
           │
           └─ イベントハンドラ
                  ├─ #n-columns change → 列数切り替え
                  ├─ #copy-to-clipboard click → コードコピー
                  ├─ .edit-link click → HTML編集モーダル
                  └─ .remove-link click → 要素削除
```

### データフロー図

```
[入力]               [処理]                    [出力]

ドラッグ操作 ──────▶ jQuery UI         ──────▶ DOM更新
                    draggable/droppable       （要素配置）

要素並び替え ──────▶ jQuery UI         ──────▶ DOM更新
                    sortable                  （順序変更）

列数選択 ──────────▶ JavaScript        ──────▶ DOM更新
                    #n-columns change         （レイアウト変更）

コピーボタン ──────▶ JavaScript        ──────▶ モーダル表示
                    html_beautify()           （整形済みHTML）

編集リンク ────────▶ JavaScript        ──────▶ モーダル表示
                    get_modal()               （HTML編集）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build.html | `ruoyi-admin/src/main/resources/templates/tool/build/build.html` | テンプレート | 画面テンプレート（HTML + JavaScript） |
| jquery-ui-1.10.4.min.js | `ruoyi-admin/src/main/resources/static/js/jquery-ui-1.10.4.min.js` | ライブラリ | ドラッグ＆ドロップ機能 |
| beautifyhtml.js | `ruoyi-admin/src/main/resources/static/ajax/libs/beautifyhtml/beautifyhtml.js` | ライブラリ | HTML整形 |
| datetimepicker関連 | 共通インクルード | ライブラリ | 日付選択コンポーネント |
| style.min.css | `ruoyi-admin/src/main/resources/static/css/style.min.css` | スタイル | 共通スタイル |
| bootstrap.min.css | `ruoyi-admin/src/main/resources/static/css/bootstrap.min.css` | スタイル | Bootstrapフレームワーク |
