# 画面設計書 64-コード生成一覧

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるコード生成一覧画面の設計仕様を定義するものである。

### 本画面の処理概要

コード生成一覧画面は、データベーステーブルをもとに自動的にCRUD機能のソースコードを生成するためのメイン画面である。

**業務上の目的・背景**：システム開発において、単純なCRUD機能のコーディングは開発工数の多くを占める。本画面ではデータベーステーブル構造からController、Service、Mapper、Entity、HTML等のソースコードを自動生成することで、開発生産性を大幅に向上させる。RuoYiフレームワークの規約に沿ったコードが生成され、そのまま動作する品質のコードが得られる。

**画面へのアクセス方法**：システム首頁の左側メニューから「システムツール」→「コード生成」を選択してアクセスする。アクセスには`tool:gen:view`権限が必要である。

**主要な操作・処理内容**：
1. コード生成対象テーブル一覧の表示・検索
2. データベースからテーブルをインポート
3. SQLでテーブルを新規作成
4. テーブル設定の編集（フィールド設定、生成オプション等）
5. 生成コードのプレビュー（各ファイルのコードを確認）
6. コードの生成・ダウンロード（ZIP形式）
7. 自定義パスへのコード生成
8. データベースとの同期（テーブル構造変更時）
9. テーブル設定の削除

**画面遷移**：
- テーブルインポート画面（モーダル）への遷移
- テーブル作成画面（モーダル）への遷移
- コード生成編集画面（タブ）への遷移
- コードプレビュー（レイヤーモーダル）の表示

**権限による表示制御**：
- `tool:gen:view`: 画面表示
- `tool:gen:list`: 一覧取得
- `tool:gen:edit`: 編集・同期
- `tool:gen:remove`: 削除
- `tool:gen:preview`: プレビュー
- `tool:gen:code`: コード生成
- `admin`ロール: テーブル作成

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | コード生成 | 主機能 | テーブル一覧表示、プレビュー、コード生成、DB同期処理 |

## 画面種別

一覧

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /tool/gen | コード生成一覧画面表示 |
| POST | /tool/gen/list | テーブル一覧取得 |
| GET | /tool/gen/importTable | テーブルインポート画面表示 |
| POST | /tool/gen/importTable | テーブルインポート実行 |
| GET | /tool/gen/createTable | テーブル作成画面表示 |
| POST | /tool/gen/createTable | テーブル作成実行 |
| GET | /tool/gen/edit/{tableId} | 編集画面表示 |
| POST | /tool/gen/edit | 編集保存 |
| POST | /tool/gen/remove | テーブル削除 |
| GET | /tool/gen/preview/{tableId} | コードプレビュー |
| GET | /tool/gen/download/{tableName} | コードダウンロード（ZIP） |
| GET | /tool/gen/genCode/{tableName} | 自定義パス生成 |
| GET | /tool/gen/synchDb/{tableName} | DB同期 |
| GET | /tool/gen/batchGenCode | 一括コード生成 |

## 入出力項目

### 検索条件（入力）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| tableName | 文字列 | - | テーブル名（部分一致） |
| tableComment | 文字列 | - | テーブル説明（部分一致） |
| params[beginTime] | 日時 | - | 作成日時（開始） |
| params[endTime] | 日時 | - | 作成日時（終了） |

## 表示項目

### テーブル一覧

| 項目名 | データ型 | ソート | 説明 |
|--------|---------|--------|------|
| チェックボックス | - | - | 行選択用 |
| 序号 | 整数 | - | 連番 |
| 表名称 | 文字列 | ○ | テーブル名（ツールチップあり） |
| 表描述 | 文字列 | ○ | テーブルの説明（15文字で省略） |
| 実体類名称 | 文字列 | ○ | 生成するEntityクラス名 |
| 創建時間 | 日時 | ○ | 作成日時（デフォルトソート：降順） |
| 更新時間 | 日時 | ○ | 更新日時 |
| 操作 | ボタン群 | - | プレビュー、編集、削除、同期、生成 |

## イベント仕様

### 1-検索

検索フォームの条件でテーブル一覧を絞り込む。

- **トリガー**: 「搜索」ボタンクリック
- **処理**: `$.table.search()`でAjax検索
- **API**: POST `/tool/gen/list`

### 2-リセット

検索条件をクリアして再検索する。

- **トリガー**: 「重置」ボタンクリック
- **処理**: `$.form.reset()`でフォームリセット後に再検索

### 3-生成（一括）

選択した複数テーブルのコードを一括生成してダウンロードする。

- **トリガー**: ツールバー「生成」ボタンクリック
- **権限**: `tool:gen:code`
- **処理**:
  1. 選択されたテーブル名を取得
  2. 確認ダイアログを表示
  3. `/tool/gen/batchGenCode?tables=xxx`へリダイレクト
  4. ZIPファイルをダウンロード

### 4-作成（テーブル新規作成）

SQLを入力して新規テーブルを作成する。

- **トリガー**: ツールバー「創建」ボタンクリック
- **権限**: `admin`ロール
- **処理**: モーダルで`/tool/gen/createTable`画面を表示

### 5-導入（テーブルインポート）

データベースからテーブルをインポートする。

- **トリガー**: ツールバー「導入」ボタンクリック
- **処理**: モーダルで`/tool/gen/importTable`画面を表示

### 6-修改（編集）

テーブルの生成設定を編集する。

- **トリガー**: 行操作「編輯」ボタンまたはツールバー「修改」ボタンクリック
- **権限**: `tool:gen:edit`
- **処理**: タブで`/tool/gen/edit/{tableId}`画面を開く

### 7-刪除（削除）

テーブル設定を削除する。

- **トリガー**: 行操作「刪除」ボタンまたはツールバー「刪除」ボタンクリック
- **権限**: `tool:gen:remove`
- **API**: POST `/tool/gen/remove`
- **処理**: 確認ダイアログ後に削除実行

### 8-預覧（プレビュー）

生成されるコードをプレビューする。

- **トリガー**: 行操作「預覧」ボタンクリック
- **権限**: `tool:gen:preview`
- **API**: GET `/tool/gen/preview/{tableId}`
- **処理**:
  1. ローディング表示
  2. 各テンプレートファイルのコードを取得
  3. シンタックスハイライト（highlight.js）を適用
  4. タブ形式のレイヤーモーダルで表示
  5. 各ファイルにコピー機能あり

### 9-同歩（同期）

テーブル構造の変更をコード生成設定に同期する。

- **トリガー**: 行操作「同歩」ボタンクリック
- **権限**: `tool:gen:edit`
- **API**: GET `/tool/gen/synchDb/{tableName}`
- **処理**: 確認ダイアログ後に同期実行

### 10-生成代碼（コード生成）

個別テーブルのコードを生成する。

- **トリガー**: 行操作「生成代碼」ボタンクリック
- **権限**: `tool:gen:code`
- **処理**:
  - `genType=0`（ZIP）: `/tool/gen/download/{tableName}`へリダイレクト
  - `genType=1`（自定義パス）: `/tool/gen/genCode/{tableName}`をAjax呼び出し

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テーブルインポート | gen_table | INSERT | テーブル情報を登録 |
| テーブルインポート | gen_table_column | INSERT | カラム情報を登録 |
| テーブル作成 | (ユーザー指定テーブル) | CREATE TABLE | DDL実行 |
| 編集保存 | gen_table | UPDATE | テーブル設定を更新 |
| 編集保存 | gen_table_column | UPDATE | カラム設定を更新 |
| 削除 | gen_table | DELETE | テーブル情報を削除 |
| 削除 | gen_table_column | DELETE | カラム情報を削除 |
| DB同期 | gen_table_column | INSERT/UPDATE/DELETE | カラム情報を同期 |

### テーブル別更新項目詳細

#### gen_table

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | table_name | DBから取得 | テーブル名 |
| INSERT | table_comment | DBから取得 | テーブルコメント |
| INSERT | class_name | 自動生成 | エンティティクラス名 |
| INSERT | create_by | ログインユーザー | 作成者 |
| INSERT | create_time | 現在日時 | 作成日時 |
| UPDATE | 各設定項目 | 編集画面の入力値 | - |
| DELETE | - | tableId指定 | - |

#### gen_table_column

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | column_name | DBから取得 | カラム名 |
| INSERT | column_type | DBから取得 | データ型 |
| INSERT | java_type | 自動推論 | Javaデータ型 |
| INSERT | java_field | 自動変換 | Javaフィールド名 |
| UPDATE | 各設定項目 | 編集画面の入力値 | - |
| DELETE | - | tableId指定またはDB同期時 | - |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| MSG-001 | 執行成功,正在生成代碼請稍候... | 成功 | コード生成開始時 |
| MSG-002 | 請選擇要生成的數據 | 警告 | 一括生成時に選択なし |
| MSG-003 | 確定要生成{tableName}表代碼嗎？ | 確認 | 個別コード生成時 |
| MSG-004 | 確認要強制同歩{tableName}表結構嗎？ | 確認 | DB同期時 |
| MSG-005 | 確認要生成選中的{N}條數據嗎? | 確認 | 一括生成時 |
| MSG-006 | 【系統預設】不允許生成文件覆蓋到本地 | エラー | 自定義パス生成不可時 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 権限不足 | 403エラー画面へリダイレクト |
| テーブルが存在しない | エラーメッセージ表示 |
| コード生成エラー | エラーメッセージ表示 |

## 備考

- highlight.jsを使用してプレビューコードのシンタックスハイライトを実現
- Excelエクスポート機能あり（showExport: true）
- デフォルトソートはcreateTimeの降順
- rememberSelected: trueでページ遷移後も選択状態を保持
- uniqueIdはtableIdを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コード生成に使用するドメインクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GenTable.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTable.java` | テーブル情報ドメイン。テーブル名、クラス名、生成オプション等 |
| 1-2 | GenTableColumn.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTableColumn.java` | カラム情報ドメイン。カラム名、型、Javaフィールド設定等 |

**読解のコツ**: GenTableとGenTableColumnは1:Nの関係。GenTableにはList<GenTableColumn>がある。

#### Step 2: エントリーポイントを理解する

コントローラクラスで各種リクエストを処理する流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | コード生成のコントローラ。約15のエンドポイントを提供 |

**主要処理フロー**:
1. **59-63行目**: `gen()`で一覧画面を表示
2. **68-76行目**: `genList()`でテーブル一覧をJSON返却
3. **110-114行目**: `importTable()`でインポート画面表示
4. **128-140行目**: `importTableSave()`でインポート実行
5. **145-169行目**: `edit()`で編集画面表示（関連テーブル情報も取得）
6. **233-240行目**: `preview()`でコードプレビュー
7. **247-252行目**: `download()`でZIPダウンロード
8. **257-269行目**: `genCode()`で自定義パス生成
9. **274-282行目**: `synchDb()`でDB同期

#### Step 3: サービス層を理解する

コード生成のビジネスロジックを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IGenTableService.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/IGenTableService.java` | サービスインターフェース |
| 3-2 | GenTableServiceImpl.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` | サービス実装。Velocityテンプレートでコード生成 |

**主要処理フロー**:
- **166-199行目**: `importGenTable()`でテーブル情報をDBに登録
- **201-232行目**: `previewCode()`でVelocityテンプレートをレンダリング
- **254-290行目**: `generatorCode()`でファイル生成
- **297-345行目**: `synchDb()`でテーブル構造同期

#### Step 4: ビューテンプレートを理解する

一覧画面のThymeleafテンプレートを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gen.html | `ruoyi-generator/src/main/resources/templates/tool/gen/gen.html` | 一覧画面テンプレート。Bootstrap Table使用 |

**主要処理フロー**:
- **9-32行目**: 検索フォーム
- **34-50行目**: ツールバーボタン群
- **67-139行目**: Bootstrap Tableの列定義
- **141-172行目**: preview()関数（コードプレビュー）
- **174-184行目**: genCode()関数（コード生成）
- **186-191行目**: synchDb()関数（DB同期）
- **193-205行目**: batchGenCode()関数（一括生成）

### プログラム呼び出し階層図

```
GET /tool/gen
    │
    └─ GenController.gen()
           │
           └─ gen.html (Bootstrap Table)
                  │
                  └─ POST /tool/gen/list ← Ajax
                         │
                         └─ GenController.genList()
                                │
                                └─ GenTableServiceImpl.selectGenTableList()
                                       │
                                       └─ GenTableMapper.selectGenTableList()

GET /tool/gen/preview/{tableId}
    │
    └─ GenController.preview()
           │
           └─ GenTableServiceImpl.previewCode()
                  │
                  ├─ GenTableMapper.selectGenTableById()
                  │
                  ├─ VelocityInitializer.initVelocity()
                  │
                  └─ Velocity.getTemplate() ×N
                         │
                         └─ template.merge(context, sw)

GET /tool/gen/download/{tableName}
    │
    └─ GenController.download()
           │
           └─ GenTableServiceImpl.downloadCode()
                  │
                  ├─ generatorCode(tableName, zip)
                  │
                  └─ ZIPストリーム出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

テーブル検索 ──────▶ GenController ───────▶ JSON（一覧）
                    GenTableService
                    GenTableMapper

テーブルインポート ▶ GenController ───────▶ gen_table
                    GenTableService          gen_table_column
                    GenTableMapper

コードプレビュー ──▶ GenController ───────▶ レイヤーモーダル
                    GenTableService          （シンタックスハイライト）
                    Velocity

コード生成 ────────▶ GenController ───────▶ ZIPファイル
                    GenTableService          または
                    Velocity                  ファイル出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | ソース | コントローラ |
| IGenTableService.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/IGenTableService.java` | ソース | サービスインターフェース |
| GenTableServiceImpl.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` | ソース | サービス実装 |
| GenTable.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTable.java` | ソース | テーブル情報ドメイン |
| GenTableColumn.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTableColumn.java` | ソース | カラム情報ドメイン |
| GenTableMapper.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableMapper.java` | ソース | Mapper |
| GenTableColumnMapper.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableColumnMapper.java` | ソース | Mapper |
| VelocityUtils.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/util/VelocityUtils.java` | ソース | Velocityユーティリティ |
| gen.html | `ruoyi-generator/src/main/resources/templates/tool/gen/gen.html` | テンプレート | 一覧画面 |
| vm/* | `ruoyi-generator/src/main/resources/vm/` | テンプレート | コード生成Velocityテンプレート |
