# 画面設計書 65-テーブルインポート

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるテーブルインポート画面の設計仕様を定義するものである。

### 本画面の処理概要

テーブルインポート画面は、データベース内の既存テーブルをコード生成対象としてインポートするためのモーダルダイアログ画面である。

**業務上の目的・背景**：コード自動生成機能を利用するためには、まず対象となるテーブル情報をシステムに登録する必要がある。本画面では、データベースに存在するテーブルのうち、まだインポートされていないテーブルの一覧を表示し、複数テーブルを一括でインポートできる。これにより、既存データベースからのコード生成が容易になる。

**画面へのアクセス方法**：コード生成一覧画面のツールバーにある「導入」ボタンをクリックすると、モーダルダイアログとして表示される。アクセスには`tool:gen:list`権限が必要である。

**主要な操作・処理内容**：
1. データベース内のテーブル一覧を表示（未インポートテーブルのみ）
2. テーブル名・テーブル説明による検索絞り込み
3. 複数テーブルの選択
4. 選択したテーブルをコード生成対象としてインポート

**画面遷移**：本画面はモーダルダイアログであり、インポート完了後は自動的に閉じられ、コード生成一覧画面に戻る。

**権限による表示制御**：`tool:gen:list`権限を持つユーザーのみがこの画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | コード生成 | 主機能 | データベーステーブルのインポート処理 |

## 画面種別

一覧（モーダルダイアログ）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /tool/gen/importTable | インポート画面表示 |
| POST | /tool/gen/db/list | データベーステーブル一覧取得 |
| POST | /tool/gen/importTable | インポート実行 |

## 入出力項目

### 検索条件（入力）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| tableName | 文字列 | - | テーブル名（部分一致） |
| tableComment | 文字列 | - | テーブル説明（部分一致） |

### インポート実行（入力）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| tables | 文字列 | ○ | 選択されたテーブル名（カンマ区切り） |

## 表示項目

### テーブル一覧

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| チェックボックス | - | 行選択用 |
| 序号 | 整数 | 連番 |
| 表名称 | 文字列 | テーブル名（ツールチップあり） |
| 表描述 | 文字列 | テーブルの説明（ツールチップあり） |
| 創建時間 | 日時 | テーブル作成日時 |
| 更新時間 | 日時 | テーブル更新日時 |

## イベント仕様

### 1-検索

検索フォームの条件でテーブル一覧を絞り込む。

- **トリガー**: 「搜索」ボタンクリック
- **処理**: `$.table.search()`でAjax検索
- **API**: POST `/tool/gen/db/list`

### 2-リセット

検索条件をクリアして再検索する。

- **トリガー**: 「重置」ボタンクリック
- **処理**: `$.form.reset()`でフォームリセット後に再検索

### 3-インポート実行

選択したテーブルをコード生成対象としてインポートする。

- **トリガー**: モーダルの「確定」ボタンクリック（親画面から`submitHandler()`が呼び出される）
- **処理**:
  1. 選択されたテーブル名を取得
  2. 1件も選択されていない場合は警告メッセージを表示
  3. 選択されたテーブル名をカンマ区切りで結合
  4. POST `/tool/gen/importTable`へ送信
  5. 成功時はモーダルを閉じて一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インポート実行 | gen_table | INSERT | テーブル情報を登録 |
| インポート実行 | gen_table_column | INSERT | カラム情報を登録 |

### テーブル別更新項目詳細

#### gen_table

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | table_name | DBから取得 | テーブル名 |
| INSERT | table_comment | DBから取得 | テーブルコメント |
| INSERT | class_name | GenUtils.initTable()で自動生成 | エンティティクラス名 |
| INSERT | package_name | 設定ファイルから取得 | パッケージ名 |
| INSERT | module_name | 設定ファイルから取得 | モジュール名 |
| INSERT | business_name | テーブル名から自動生成 | 業務名 |
| INSERT | function_name | テーブルコメントから自動生成 | 機能名 |
| INSERT | function_author | 設定ファイルから取得 | 作者 |
| INSERT | create_by | ログインユーザー | 作成者 |
| INSERT | create_time | 現在日時 | 作成日時 |

#### gen_table_column

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | table_id | 親テーブルのID | FK |
| INSERT | column_name | DBから取得 | カラム名 |
| INSERT | column_comment | DBから取得 | カラムコメント |
| INSERT | column_type | DBから取得 | データ型 |
| INSERT | java_type | GenUtils.initColumnField()で自動推論 | Javaデータ型 |
| INSERT | java_field | GenUtils.initColumnField()で自動変換 | Javaフィールド名 |
| INSERT | is_pk | DBから判定 | 主キーフラグ |
| INSERT | is_increment | DBから判定 | 自動インクリメントフラグ |
| INSERT | is_required | nullable属性から判定 | 必須フラグ |
| INSERT | is_insert | 自動判定 | 新規時表示フラグ |
| INSERT | is_edit | 自動判定 | 編集時表示フラグ |
| INSERT | is_list | 自動判定 | 一覧表示フラグ |
| INSERT | is_query | 自動判定 | 検索条件フラグ |
| INSERT | query_type | デフォルト値 | 検索タイプ |
| INSERT | html_type | 自動判定 | HTMLタイプ |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| MSG-001 | 請至少選擇一條記錄 | 警告 | テーブル未選択でインポート実行時 |
| MSG-002 | 操作成功 | 成功 | インポート成功時（$.operate.saveの標準メッセージ） |
| MSG-003 | 導入失敗：{エラーメッセージ} | エラー | インポート失敗時 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 権限不足 | 403エラー画面へリダイレクト |
| テーブルが既にインポート済み | 一覧に表示されない（自動除外） |
| インポートエラー | エラーメッセージを表示 |

## 備考

- Bootstrap Tableを使用してテーブル一覧を表示
- clickToSelect: trueで行クリックによる選択が可能
- rememberSelected: trueでページ遷移後も選択状態を保持
- uniqueIdはtableNameを使用
- 表示されるテーブルは、gen_tableに未登録のテーブルのみ（SQLで除外）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

モーダルダイアログのHTMLとJavaScriptを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | importTable.html | `ruoyi-generator/src/main/resources/templates/tool/gen/importTable.html` | インポート画面テンプレート。Bootstrap Table設定 |

**読解のコツ**: シンプルな一覧画面構成。submitHandler関数がモーダルの確定ボタン押下時に呼ばれる。

#### Step 2: エントリーポイントを理解する

コントローラの該当メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | 3つのエンドポイント（画面表示、一覧取得、インポート実行） |

**主要処理フロー**:
- **79-89行目**: `dataList()`でデータベーステーブル一覧を取得
- **109-114行目**: `importTable()`でインポート画面を表示
- **128-140行目**: `importTableSave()`でインポート処理を実行

#### Step 3: サービス層を理解する

インポート処理のビジネスロジックを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GenTableServiceImpl.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` | selectDbTableList, importGenTableメソッド |

**主要処理フロー**:
- **89-93行目**: `selectDbTableList()`でDBテーブル一覧取得
- **101-105行目**: `selectDbTableListByNames()`で指定テーブル情報取得
- **166-199行目**: `importGenTable()`でテーブル・カラム情報をDB登録

#### Step 4: ユーティリティを理解する

自動設定処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | GenUtils.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/util/GenUtils.java` | initTable, initColumnFieldメソッド |

**読解のコツ**: テーブル名からクラス名を生成、カラム型からJava型を推論する処理を確認。

### プログラム呼び出し階層図

```
GET /tool/gen/importTable
    │
    └─ GenController.importTable()
           │
           └─ importTable.html表示

POST /tool/gen/db/list
    │
    └─ GenController.dataList()
           │
           └─ GenTableServiceImpl.selectDbTableList()
                  │
                  └─ GenTableMapper.selectDbTableList()
                         │
                         └─ SQL: 未インポートテーブルを取得

POST /tool/gen/importTable (tables=xxx,yyy)
    │
    └─ GenController.importTableSave()
           │
           ├─ GenTableServiceImpl.selectDbTableListByNames()
           │      │
           │      └─ GenTableMapper.selectDbTableListByNames()
           │
           └─ GenTableServiceImpl.importGenTable()
                  │
                  ├─ GenUtils.initTable() ← テーブル初期設定
                  │
                  ├─ GenTableMapper.insertGenTable()
                  │
                  ├─ GenTableColumnMapper.selectDbTableColumnsByName()
                  │
                  ├─ GenUtils.initColumnField() ← カラム初期設定
                  │
                  └─ GenTableColumnMapper.insertGenTableColumn()
```

### データフロー図

```
[入力]               [処理]                    [出力]

データベース ──────▶ GenTableMapper ─────────▶ テーブル一覧
（information_schema）                         （Bootstrap Table）

テーブル選択 ──────▶ GenController ─────────▶ gen_table
                    GenTableService           gen_table_column
                    GenUtils                  (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| importTable.html | `ruoyi-generator/src/main/resources/templates/tool/gen/importTable.html` | テンプレート | インポート画面 |
| GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | ソース | コントローラ |
| GenTableServiceImpl.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` | ソース | サービス実装 |
| GenTableMapper.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableMapper.java` | ソース | Mapper |
| GenTableColumnMapper.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableColumnMapper.java` | ソース | Mapper |
| GenUtils.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/util/GenUtils.java` | ソース | 初期化ユーティリティ |
| GenTableMapper.xml | `ruoyi-generator/src/main/resources/mapper/generator/GenTableMapper.xml` | XML | SQLマッピング |
