# 画面設計書 66-テーブル作成

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるテーブル作成画面の設計仕様を定義するものである。

### 本画面の処理概要

テーブル作成画面は、CREATE TABLE文を入力してデータベースにテーブルを新規作成し、同時にコード生成対象として登録するためのモーダルダイアログ画面である。

**業務上の目的・背景**：新規機能開発時にテーブルを新規作成し、同時にコード生成対象として登録したい場合がある。本画面では、CREATE TABLE文を入力するだけで、テーブル作成とコード生成対象へのインポートを一度に行える。複数のCREATE TABLE文を一度に入力することで、関連テーブルをまとめて作成することも可能。

**画面へのアクセス方法**：コード生成一覧画面のツールバーにある「創建」ボタンをクリックすると、モーダルダイアログとして表示される。アクセスには`admin`ロールが必要である。

**主要な操作・処理内容**：
1. CREATE TABLE文をテキストエリアに入力（複数テーブル対応）
2. 確定ボタンでテーブル作成とインポートを実行

**画面遷移**：本画面はモーダルダイアログであり、作成完了後は自動的に閉じられ、コード生成一覧画面に戻る。

**権限による表示制御**：`admin`ロールを持つユーザーのみがこの画面にアクセス可能。一般ユーザーには「創建」ボタンが表示されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | コード生成 | 主機能 | 新規テーブル作成のSQL実行処理 |

## 画面種別

入力（モーダルダイアログ）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /tool/gen/createTable | 作成画面表示 |
| POST | /tool/gen/createTable | 作成実行 |

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| sql | 文字列 | ○ | CREATE TABLE文（複数可） |

## 表示項目

### 入力エリア

| 項目名 | 種別 | 説明 |
|--------|------|------|
| ラベル | テキスト | 「創建表語句(支持多個建表語句)：」 |
| テキストエリア | textarea | 12行、col-sm-11幅 |

## イベント仕様

### 1-テーブル作成実行

入力されたCREATE TABLE文を実行し、テーブルを作成してインポートする。

- **トリガー**: モーダルの「確定」ボタンクリック（親画面から`submitHandler()`が呼び出される）
- **処理**:
  1. テキストエリアの値を取得
  2. 空の場合は警告メッセージを表示
  3. POST `/tool/gen/createTable`へSQL送信
  4. サーバー側でSQL解析・実行
  5. 作成されたテーブルをインポート
  6. 成功時はモーダルを閉じて一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テーブル作成実行 | (ユーザー指定テーブル) | CREATE TABLE | DDL実行 |
| テーブル作成実行 | gen_table | INSERT | テーブル情報を登録 |
| テーブル作成実行 | gen_table_column | INSERT | カラム情報を登録 |

### テーブル別更新項目詳細

#### ユーザー指定テーブル

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| CREATE TABLE | - | 入力されたDDL文をそのまま実行 | MySqlCreateTableStatementで解析 |

#### gen_table / gen_table_column

インポートと同様の処理が行われる（65-テーブルインポート参照）。

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| MSG-001 | 請輸入建表語句 | 警告 | SQL未入力で実行時 |
| MSG-002 | 操作成功 | 成功 | 作成成功時 |
| MSG-003 | 創建表結構異常 | エラー | SQL実行エラー時 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| ロール不足（admin以外） | 403エラー画面へリダイレクト |
| SQL構文エラー | エラーメッセージ「創建表結構異常」を表示 |
| テーブルが既に存在 | SQL実行エラーとして処理 |
| 禁止キーワード検出 | SqlUtil.filterKeyword()で拒否 |

## 備考

- `@RequiresRoles("admin")`により管理者ロール必須
- SQLは`SqlUtil.filterKeyword()`でセキュリティチェックされる
- `DruidのSQLUtils.parseStatements()`でSQL解析される
- `MySqlCreateTableStatement`のみ処理対象（CREATE TABLE文のみ）
- 複数のCREATE TABLE文をセミコロン区切りで入力可能
- 作成成功後、自動的にインポート処理が実行される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

シンプルなモーダルダイアログのHTMLを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | createTable.html | `ruoyi-generator/src/main/resources/templates/tool/gen/createTable.html` | 作成画面テンプレート。テキストエリア1つのみ |

**読解のコツ**: 非常にシンプルな構成。submitHandler関数でテキストエリアの内容を送信。

#### Step 2: エントリーポイントを理解する

コントローラの該当メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | createTableメソッド（画面表示と実行） |

**主要処理フロー**:
- **119-123行目**: `createTable()`で画面表示
- **195-228行目**: `create()`でSQL実行とインポート

#### Step 3: SQL処理を理解する

SQL解析とテーブル作成処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | create()メソッドのSQL処理 |

**主要処理フロー**:
- **203行目**: `SqlUtil.filterKeyword(sql)`でセキュリティチェック
- **204行目**: `SQLUtils.parseStatements(sql, DbType.mysql)`でSQL解析
- **206-215行目**: `MySqlCreateTableStatement`のみを処理
- **211行目**: `genTableService.createTable()`でDDL実行
- **218-220行目**: 作成されたテーブルをインポート

### プログラム呼び出し階層図

```
GET /tool/gen/createTable
    │
    └─ GenController.createTable()
           │
           └─ createTable.html表示

POST /tool/gen/createTable (sql=CREATE TABLE...)
    │
    └─ GenController.create()
           │
           ├─ SqlUtil.filterKeyword()
           │      └─ SQLインジェクション対策
           │
           ├─ SQLUtils.parseStatements()
           │      └─ Druid SQL Parser
           │
           ├─ for each MySqlCreateTableStatement
           │      │
           │      └─ GenTableServiceImpl.createTable()
           │             │
           │             └─ GenTableMapper.createTable()
           │                    │
           │                    └─ DDL実行
           │
           ├─ GenTableServiceImpl.selectDbTableListByNames()
           │
           └─ GenTableServiceImpl.importGenTable()
```

### データフロー図

```
[入力]               [処理]                    [出力]

CREATE TABLE文 ────▶ Druid Parser ──────────▶ DDL実行
                    SqlUtil                   （テーブル作成）
                         │
                         ▼
                    GenTableMapper.createTable()
                         │
                         ▼
                    importGenTable()  ─────▶ gen_table
                                             gen_table_column
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| createTable.html | `ruoyi-generator/src/main/resources/templates/tool/gen/createTable.html` | テンプレート | 作成画面 |
| GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | ソース | コントローラ |
| GenTableServiceImpl.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` | ソース | サービス実装 |
| GenTableMapper.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableMapper.java` | ソース | Mapper |
| SqlUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/sql/SqlUtil.java` | ソース | SQLセキュリティユーティリティ |
