# 画面設計書 67-コード生成編集

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるコード生成編集画面の設計仕様を定義するものである。

### 本画面の処理概要

コード生成編集画面は、インポートしたテーブルのコード生成設定を詳細に編集するためのタブ画面である。

**業務上の目的・背景**：自動インポートされたテーブル情報は基本的な設定のみが行われている。実際のコード生成に際しては、フィールドの表示設定、検索条件、入力タイプ、辞書タイプなど、細かなカスタマイズが必要となる。本画面では3つのタブに分かれた設定項目を通じて、生成されるコードの振る舞いを詳細に制御できる。

**画面へのアクセス方法**：コード生成一覧画面の行操作「編輯」ボタンまたはツールバー「修改」ボタンをクリックすると、新規タブとして表示される。アクセスには`tool:gen:edit`権限が必要である。

**主要な操作・処理内容**：
1. 基本情報タブ：テーブル名、エンティティクラス名、作者、備考の設定
2. 字段信息タブ：各フィールドの詳細設定（Java型、表示設定、必須、検索設定等）
3. 生成信息タブ：生成テンプレート、パッケージ、モジュール、機能名等の設定
4. ツリー構造テーブルの場合：ツリー構造設定（コード、親コード、名称フィールド）
5. 主子テーブルの場合：子テーブル関連設定
6. フィールド順序のドラッグ＆ドロップ並び替え

**画面遷移**：本画面は新規タブとして開かれる。保存後は自動的にタブが閉じられ、一覧画面に戻る。

**権限による表示制御**：`tool:gen:edit`権限を持つユーザーのみがこの画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | コード生成 | 主機能 | コード生成設定の編集保存処理 |

## 画面種別

編集（タブ形式・3タブ構成）

## URL/ルーティング

| メソッド | URL | 説明 |
|---------|-----|------|
| GET | /tool/gen/edit/{tableId} | 編集画面表示 |
| POST | /tool/gen/column/list | カラム一覧取得 |
| POST | /tool/gen/edit | 編集保存 |

## 入出力項目

### 基本情報タブ

| 項目名 | データ型 | 必須 | 最大長 | 説明 |
|--------|---------|------|--------|------|
| tableId | 数値 | ○ | - | テーブルID（hidden） |
| tableName | 文字列 | ○ | 200 | テーブル名 |
| tableComment | 文字列 | ○ | 500 | テーブル説明 |
| className | 文字列 | ○ | 100 | エンティティクラス名 |
| functionAuthor | 文字列 | ○ | 50 | 作者 |
| remark | 文字列 | - | 500 | 備考 |

### 字段信息タブ（フィールド一覧）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| columnId | 数値 | カラムID（hidden） |
| sort | 数値 | 表示順（hidden、ドラッグで変更） |
| columnName | 文字列 | カラム名（表示のみ） |
| columnComment | 文字列 | カラム説明（編集可能） |
| columnType | 文字列 | 物理型（表示のみ） |
| javaType | 選択 | Java型（Long/String/Integer/Double/BigDecimal/Date） |
| javaField | 文字列 | Javaフィールド名（編集可能、必須） |
| isInsert | チェック | 新規画面表示フラグ |
| isEdit | チェック | 編集画面表示フラグ |
| isList | チェック | 一覧表示フラグ |
| isQuery | チェック | 検索条件フラグ |
| queryType | 選択 | 検索タイプ（=, !=, >, >=, <, <=, Like, Between） |
| isRequired | チェック | 必須フラグ |
| htmlType | 選択 | 表示タイプ（テキスト/テキストエリア/セレクト等） |
| dictType | 文字列 | 辞書タイプ（ポップアップ選択） |

### 生成信息タブ

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| tplCategory | 選択 | ○ | テンプレート（crud/tree/sub） |
| packageName | 文字列 | ○ | パッケージ名 |
| moduleName | 文字列 | ○ | モジュール名 |
| businessName | 文字列 | ○ | 業務名 |
| functionName | 文字列 | ○ | 機能名 |
| formColNum | 選択 | ○ | フォームレイアウト（1列/2列/3列） |
| genType | ラジオ | ○ | 生成方式（ZIP/自定義パス） |
| parentMenuId | 数値 | ○ | 上位メニューID（hidden） |
| parentMenuName | 文字列 | ○ | 上位メニュー名（ポップアップ選択） |
| genPath | 文字列 | - | 生成パス（自定義パス選択時のみ） |

### ツリー構造設定（tplCategory=tree時のみ表示）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| treeCode | 選択 | ○ | ツリーコードフィールド |
| treeParentCode | 選択 | ○ | ツリー親コードフィールド |
| treeName | 選択 | ○ | ツリー名称フィールド |

### 主子テーブル設定（tplCategory=sub時のみ表示）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| subTableName | 選択 | ○ | 子テーブル名 |
| subTableFkName | 選択 | ○ | 子テーブルFK名 |

## 表示項目

3タブ構成で表示。字段信息タブがデフォルトでアクティブ。

## イベント仕様

### 1-タブ切り替え

各タブをクリックしてコンテンツを切り替える。

- **トリガー**: タブヘッダーのクリック
- **処理**: 対応するタブペインを表示、他を非表示

### 2-フィールド並び替え

字段信息タブでフィールドをドラッグして表示順を変更する。

- **トリガー**: 序号列のドラッグ
- **処理**: Bootstrap Table reorder-rowsで順序変更
- **後処理**: onReorderRow()でhidden項目のsort値を更新

### 3-テンプレート種別変更

生成テンプレートを変更すると、対応する追加設定項目が表示される。

- **トリガー**: tplCategoryセレクトの変更
- **処理**:
  - crud選択時: ツリー設定・主子設定を非表示
  - tree選択時: ツリー設定を表示、主子設定を非表示
  - sub選択時: 主子設定を表示、ツリー設定を非表示

### 4-生成方式変更

生成方式をZIPから自定義パスに変更すると、パス入力欄が表示される。

- **トリガー**: genTypeラジオの変更
- **処理**:
  - ZIP選択時: パス入力欄を非表示、genPathを「/」にリセット
  - 自定義パス選択時: パス入力欄を表示

### 5-辞書タイプ選択

フィールドの辞書タイプを選択するポップアップを表示する。

- **トリガー**: 辞書タイプ列の検索アイコンクリック
- **処理**: 辞書ツリー選択モーダルを表示
- **後処理**: 選択した辞書タイプを入力欄に設定

### 6-上位メニュー選択

上位メニューを選択するポップアップを表示する。

- **トリガー**: 上級メニュー入力欄クリック
- **処理**: メニューツリー選択モーダルを表示
- **後処理**: 選択したメニューID・名称を入力欄に設定

### 7-保存

編集内容を保存する。

- **トリガー**: 「保存」ボタンクリック
- **処理**:
  1. バリデーション実行
  2. フォームデータを配列形式でシリアライズ
  3. POST `/tool/gen/edit`へ送信
  4. 成功時はタブを閉じて一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | gen_table | UPDATE | テーブル設定を更新 |
| 保存 | gen_table_column | UPDATE | 各カラム設定を更新 |

### テーブル別更新項目詳細

#### gen_table

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | table_name | フォーム入力値 | テーブル名 |
| UPDATE | table_comment | フォーム入力値 | テーブル説明 |
| UPDATE | class_name | フォーム入力値 | エンティティクラス名 |
| UPDATE | function_author | フォーム入力値 | 作者 |
| UPDATE | tpl_category | フォーム入力値 | テンプレート種別 |
| UPDATE | package_name | フォーム入力値 | パッケージ名 |
| UPDATE | module_name | フォーム入力値 | モジュール名 |
| UPDATE | business_name | フォーム入力値 | 業務名 |
| UPDATE | function_name | フォーム入力値 | 機能名 |
| UPDATE | form_col_num | フォーム入力値 | フォームレイアウト |
| UPDATE | gen_type | フォーム入力値 | 生成方式 |
| UPDATE | gen_path | フォーム入力値 | 生成パス |
| UPDATE | sub_table_name | フォーム入力値 | 子テーブル名 |
| UPDATE | sub_table_fk_name | フォーム入力値 | 子テーブルFK |
| UPDATE | options | JSON形式 | 拡張設定（ツリー設定、メニューID等） |
| UPDATE | update_by | ログインユーザー | 更新者 |
| UPDATE | update_time | 現在日時 | 更新日時 |

#### gen_table_column

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | column_comment | フォーム入力値 | カラム説明 |
| UPDATE | java_type | フォーム入力値 | Java型 |
| UPDATE | java_field | フォーム入力値 | Javaフィールド名 |
| UPDATE | is_insert | フォーム入力値 | 新規表示フラグ |
| UPDATE | is_edit | フォーム入力値 | 編集表示フラグ |
| UPDATE | is_list | フォーム入力値 | 一覧表示フラグ |
| UPDATE | is_query | フォーム入力値 | 検索条件フラグ |
| UPDATE | query_type | フォーム入力値 | 検索タイプ |
| UPDATE | is_required | フォーム入力値 | 必須フラグ |
| UPDATE | html_type | フォーム入力値 | 表示タイプ |
| UPDATE | dict_type | フォーム入力値 | 辞書タイプ |
| UPDATE | sort | フォーム入力値 | 表示順 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| MSG-001 | 操作成功 | 成功 | 保存成功時 |
| MSG-002 | 樹編碼字段不能為空 | エラー | ツリー設定不備時 |
| MSG-003 | 樹父編碼字段不能為空 | エラー | ツリー設定不備時 |
| MSG-004 | 樹名稱字段不能為空 | エラー | ツリー設定不備時 |
| MSG-005 | 關聯子表的表名不能為空 | エラー | 主子設定不備時 |
| MSG-006 | 子表關聯的外鍵名不能為空 | エラー | 主子設定不備時 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 権限不足 | 403エラー画面へリダイレクト |
| バリデーションエラー | 対応する項目にエラー表示 |
| 保存エラー | エラーメッセージを表示 |

## 備考

- select2を使用してセレクトボックスをリッチ化
- iCheckを使用してチェックボックスをスタイリング
- Bootstrap Table reorder-rowsでドラッグ並び替えを実現
- cxSelectを使用して主子テーブルの連動選択を実現
- jquery.tmplを使用してテーブルセルのテンプレートを定義
- フォームデータはserializeArray()で配列形式でシリアライズ（columns[0].columnId等）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

3タブ構成の複雑なフォーム画面を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | edit.html | `ruoyi-generator/src/main/resources/templates/tool/gen/edit.html` | 編集画面テンプレート。3タブ構成、Bootstrap Table、各種プラグイン |

**読解のコツ**:
- 1-76行目: 基本情報タブのフォーム
- 77-84行目: 字段信息タブ（Bootstrap Tableのコンテナ）
- 85-254行目: 生成信息タブ（テンプレート設定、ツリー・主子設定）
- 275-571行目: JavaScript処理（テーブル初期化、イベントハンドラ）
- 576-620行目: jQueryテンプレート（セレクトボックス生成）

#### Step 2: エントリーポイントを理解する

コントローラの該当メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | edit, columnList, editSaveメソッド |

**主要処理フロー**:
- **94-104行目**: `columnList()`でカラム一覧を取得
- **145-169行目**: `edit()`で編集画面表示（テーブル情報、関連テーブル情報取得）
- **174-183行目**: `editSave()`で編集内容を保存

#### Step 3: サービス層を理解する

更新処理のビジネスロジックを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GenTableServiceImpl.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` | updateGenTable, validateEditメソッド |

**主要処理フロー**:
- **124-138行目**: `updateGenTable()`でテーブル・カラム情報を更新
- **410-442行目**: `validateEdit()`でツリー・主子設定のバリデーション

### プログラム呼び出し階層図

```
GET /tool/gen/edit/{tableId}
    │
    └─ GenController.edit()
           │
           ├─ GenTableServiceImpl.selectGenTableById()
           │      └─ setTableFromOptions() ← options JSONを展開
           │
           └─ GenTableServiceImpl.selectGenTableAll()
                  └─ 関連テーブル情報（主子テーブル用）

POST /tool/gen/column/list
    │
    └─ GenController.columnList()
           │
           └─ GenTableColumnService.selectGenTableColumnListByTableId()

POST /tool/gen/edit (フォームデータ)
    │
    └─ GenController.editSave()
           │
           ├─ GenTableServiceImpl.validateEdit()
           │      └─ ツリー/主子設定のバリデーション
           │
           └─ GenTableServiceImpl.updateGenTable()
                  │
                  ├─ GenTableMapper.updateGenTable()
                  │
                  └─ GenTableColumnMapper.updateGenTableColumn() ×N
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ──────▶ GenController ─────────▶ gen_table
（3タブ分）         GenTableService          gen_table_column
                    GenTableMapper           (UPDATE)
                    GenTableColumnMapper
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| edit.html | `ruoyi-generator/src/main/resources/templates/tool/gen/edit.html` | テンプレート | 編集画面 |
| GenController.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java` | ソース | コントローラ |
| GenTableServiceImpl.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` | ソース | サービス実装 |
| IGenTableColumnService.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/service/IGenTableColumnService.java` | ソース | カラムサービス |
| GenTableMapper.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableMapper.java` | ソース | Mapper |
| GenTableColumnMapper.java | `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableColumnMapper.java` | ソース | Mapper |
| select2.js | 共通インクルード | ライブラリ | リッチセレクト |
| jquery.tmpl.js | `ruoyi-admin/src/main/resources/static/js/jquery.tmpl.js` | ライブラリ | テンプレートエンジン |
| bootstrap-table-reorder-rows.js | 共通インクルード | ライブラリ | 行ドラッグ |
