# 画面設計書 68-404エラー画面

## 概要

本ドキュメントは、RuoYi後台管理システムにおける404エラー画面の設計仕様を定義するものである。

### 本画面の処理概要

404エラー画面は、リクエストされたURLに対応するページが存在しない場合に表示されるエラー画面である。

**業務上の目的・背景**：ユーザーが存在しないURLにアクセスした際、単純なエラーメッセージではなく、視覚的に分かりやすいエラーページを表示することで、ユーザーエクスペリエンスを向上させる。また、主ページへの導線を提供することで、ユーザーが迷子にならないようにする。

**画面へのアクセス方法**：存在しないURLにアクセスした際、Webサーバー・アプリケーションフレームワークにより自動的に表示される。

**主要な操作・処理内容**：
1. エラー内容の表示（「找不到网页！」メッセージ）
2. 主ページへのリンク提供（「主页」ボタン）

**画面遷移**：「主页」ボタンをクリックすると、システムの首頁（/index）にリダイレクトされる。

**権限による表示制御**：権限チェックは行われない。すべてのユーザーに同一の画面が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | HTTPエラーハンドリング |

## 画面種別

エラー（静的表示）

## URL/ルーティング

本画面は直接的なルーティングを持たず、Spring Bootのエラーハンドリング機構により表示される。

| 条件 | 表示画面 |
|------|---------|
| HTTPステータス 404 | error/404.html |

## 入出力項目

入力項目は存在しない。

## 表示項目

| 項目名 | 種別 | 説明 |
|--------|------|------|
| 404 | 見出し（h1） | HTTPステータスコード |
| 找不到网页！ | 見出し（h3） | エラータイトル |
| エラー説明文 | テキスト | 「对不起，您正在寻找的页面不存在...」 |
| 主页ボタン | ボタン | システム首頁へのリンク |

## イベント仕様

### 1-主ページへ遷移

「主页」ボタンをクリックしてシステム首頁へ遷移する。

- **トリガー**: 「主页」ボタンクリック
- **処理**:
  1. `index()`関数が呼び出される
  2. `window.top.location`を`ctx + "index"`に変更
  3. 最上位フレーム（親ウィンドウ）をシステム首頁にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースへのアクセスを行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | DBアクセスなし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| - | 对不起，您正在寻找的页面不存在。尝试检查URL的错误，然后按浏览器上的刷新按钮或尝试在我们的应用程序中找到其他内容。 | 説明 | 常時表示 |

## 例外処理

本画面自体がエラー状態を表すため、追加の例外処理は存在しない。

## 備考

- アニメーションCSS（animate.min.css）を使用してフェードインアニメーションを適用
- `window.top.location`を使用することで、iframe内での表示時も親フレーム全体を遷移させる
- Thymeleafの`th:inline="javascript"`を使用してコンテキストパスを取得
- Bootstrap3のスタイルを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

シンプルなエラー画面のHTMLを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | 404.html | `ruoyi-admin/src/main/resources/templates/error/404.html` | 404エラー画面テンプレート |

**読解のコツ**:
- CSSインクルード（bootstrap, animate, style）
- `middle-box`クラスで中央配置
- `animated fadeInDown`でアニメーション
- JavaScript関数`index()`で首頁へ遷移

**主要処理フロー**:
- **12行目**: `.middle-box`でコンテンツを中央に配置
- **13行目**: `<h1>404</h1>`でステータスコード表示
- **17行目**: 「主页」ボタンで`index()`関数呼び出し
- **21-24行目**: `index()`関数でwindow.top.locationを変更

### プログラム呼び出し階層図

```
存在しないURL リクエスト
    │
    └─ Spring Boot ErrorController
           │
           └─ ViewResolver
                  │
                  └─ error/404.html表示
                         │
                         └─ 「主页」ボタンクリック
                                │
                                └─ window.top.location = ctx + "index"
```

### データフロー図

```
[入力]               [処理]                    [出力]

不正URL ──────────▶ Spring Boot ───────────▶ 404.html
                    Error Handler

「主页」クリック ─▶ JavaScript ────────────▶ 首頁リダイレクト
                    index()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| 404.html | `ruoyi-admin/src/main/resources/templates/error/404.html` | テンプレート | 404エラー画面 |
| bootstrap.min.css | `ruoyi-admin/src/main/resources/static/css/bootstrap.min.css` | スタイル | Bootstrapフレームワーク |
| animate.min.css | `ruoyi-admin/src/main/resources/static/css/animate.min.css` | スタイル | アニメーション |
| style.min.css | `ruoyi-admin/src/main/resources/static/css/style.min.css` | スタイル | 共通スタイル |
