# 画面設計書 69-500エラー画面

## 概要

本ドキュメントは、RuoYi後台管理システムにおける500エラー画面の設計仕様を定義するものである。

### 本画面の処理概要

500エラー画面は、サーバー内部でエラーが発生した場合に表示されるエラー画面である。

**業務上の目的・背景**：サーバー内部でエラー（例外）が発生した際、技術的なスタックトレースを表示する代わりに、ユーザーフレンドリーなエラーページを表示することで、ユーザーエクスペリエンスを向上させる。また、主ページへの導線を提供することで、ユーザーがシステムを継続利用できるようにする。

**画面へのアクセス方法**：サーバー内部でキャッチされない例外が発生した際、Spring Bootのエラーハンドリング機構により自動的に表示される。

**主要な操作・処理内容**：
1. エラー内容の表示（「内部服务器错误！」メッセージ）
2. エラー説明文の表示
3. 主ページへのリンク提供（「主页」ボタン）

**画面遷移**：「主页」ボタンをクリックすると、システムの首頁（/index）にリダイレクトされる。

**権限による表示制御**：権限チェックは行われない。すべてのユーザーに同一の画面が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | HTTPエラーハンドリング |

## 画面種別

エラー（静的表示）

## URL/ルーティング

本画面は直接的なルーティングを持たず、Spring Bootのエラーハンドリング機構により表示される。

| 条件 | 表示画面 |
|------|---------|
| HTTPステータス 500 | error/500.html |

## 入出力項目

入力項目は存在しない。

## 表示項目

| 項目名 | 種別 | 説明 |
|--------|------|------|
| 500 | 見出し（h1） | HTTPステータスコード |
| 内部服务器错误！ | 見出し（h3） | エラータイトル |
| エラー説明文 | テキスト | 「服务器遇到意外事件...」 |
| 主页ボタン | ボタン | システム首頁へのリンク |

## イベント仕様

### 1-主ページへ遷移

「主页」ボタンをクリックしてシステム首頁へ遷移する。

- **トリガー**: 「主页」ボタンクリック
- **処理**:
  1. `index()`関数が呼び出される
  2. `window.top.location`を`ctx + "index"`に変更
  3. 最上位フレーム（親ウィンドウ）をシステム首頁にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースへのアクセスを行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | DBアクセスなし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| - | 服务器遇到意外事件，不允许完成请求。我们抱歉。您可以返回主页面。 | 説明 | 常時表示 |

## 例外処理

本画面自体がエラー状態を表すため、追加の例外処理は存在しない。

## 備考

- アニメーションCSS（animate.min.css）を使用してフェードインアニメーションを適用
- `window.top.location`を使用することで、iframe内での表示時も親フレーム全体を遷移させる
- Thymeleafの`th:inline="javascript"`を使用してコンテキストパスを取得
- Bootstrap3のスタイルを使用
- 404エラー画面と同様のレイアウト・スタイルを採用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

シンプルなエラー画面のHTMLを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | 500.html | `ruoyi-admin/src/main/resources/templates/error/500.html` | 500エラー画面テンプレート |

**読解のコツ**:
- CSSインクルード（bootstrap, animate, style）
- `middle-box`クラスで中央配置
- `animated fadeInDown`でアニメーション
- JavaScript関数`index()`で首頁へ遷移

**主要処理フロー**:
- **6行目**: `<title>RuoYi - 500</title>`でブラウザタイトル設定
- **12行目**: `.middle-box`でコンテンツを中央に配置
- **13行目**: `<h1>500</h1>`でステータスコード表示
- **14行目**: `<h3>内部服务器错误！</h3>`でエラータイトル表示
- **18行目**: 「主页」ボタンで`index()`関数呼び出し
- **21-26行目**: `index()`関数でwindow.top.locationを変更

### プログラム呼び出し階層図

```
サーバー内部エラー発生
    │
    └─ Spring Boot ErrorController
           │
           └─ ViewResolver
                  │
                  └─ error/500.html表示
                         │
                         └─ 「主页」ボタンクリック
                                │
                                └─ window.top.location = ctx + "index"
```

### データフロー図

```
[入力]               [処理]                    [出力]

サーバー例外 ────────▶ Spring Boot ───────────▶ 500.html
                    Error Handler

「主页」クリック ─▶ JavaScript ────────────▶ 首頁リダイレクト
                    index()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| 500.html | `ruoyi-admin/src/main/resources/templates/error/500.html` | テンプレート | 500エラー画面 |
| bootstrap.min.css | `ruoyi-admin/src/main/resources/static/css/bootstrap.min.css` | スタイル | Bootstrapフレームワーク |
| animate.min.css | `ruoyi-admin/src/main/resources/static/css/animate.min.css` | スタイル | アニメーション |
| style.min.css | `ruoyi-admin/src/main/resources/static/css/style.min.css` | スタイル | 共通スタイル |
