# 画面設計書 7-メインコンテンツ（v1）

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「メインコンテンツ（v1）」の設計仕様を定義する。

### 本画面の処理概要

システム首頁の旧バージョンダッシュボード画面。統計情報（収入、注文、訪問者、活跃用户）、チャート（Flot.js）、およびユーザープロジェクトリストを表示する。

**業務上の目的・背景**：現行のシステム紹介画面（main.html）とは異なり、より業務指向のダッシュボード画面として設計されている。月次・年次の収入、注文数、訪問者数、活跃ユーザー数などのKPIを可視化し、経営層や管理者が一目でシステムの状況を把握できるようにする。ただし、現在はデモデータが表示されており、実データとの連携は行われていない。互換性維持のために残されているバージョン。

**画面へのアクセス方法**：通常の操作では表示されない。システム設定またはURLの直接指定により表示可能。

**主要な操作・処理内容**：
1. 統計情報の閲覧（4つのiboxパネル）
2. 注文チャートの閲覧（Flot.jsによる棒グラフ・折れ線グラフ）
3. ユーザープロジェクトリストの閲覧

**画面遷移**：
- 遷移元：設定による切替または直接URL指定
- 遷移先：なし（表示専用）

**権限による表示制御**：本画面は表示専用であり、特別な権限制御は行われない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ログイン | 補助機能 | ログインユーザー情報の表示 |

## 画面種別

ダッシュボード（統計表示）

## URL/ルーティング

- （設定により切替）

## 入出力項目

本画面は入力項目を持たない（表示専用）。

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 収入パネル | 月間収入統計（40,886,200、98%） |
| 注文パネル | 年間注文統計（275,800、20%） |
| 訪問者パネル | 当日訪問者統計（106,120、44%） |
| 活跃用户パネル | 月間活跃ユーザー統計（80,600、38%） |
| 注文チャート | Flot.jsによる棒グラフ・折れ線グラフ |
| 統計リスト | 注文総数、最近1ヶ月の注文、売上高 |
| ユーザープロジェクトリスト | 状態、日付、ユーザー名、進捗率 |

## イベント仕様

### 1-期間切替ボタン

1. 「天」「月」「年」ボタンをクリック
2. 対応するボタンをactiveに設定
3. （現状はUIのみで機能未実装）

### 2-iboxツールバー

1. 折りたたみアイコン：パネル内容を折りたたみ/展開
2. ×アイコン：パネルを非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

本画面はデモデータを表示しており、データベースを参照・更新しない。

## メッセージ仕様

本画面にメッセージ表示はない。

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| セッションタイムアウト | 親フレーム（システム首頁）がログイン画面にリダイレクト |

## 備考

- 表示されている統計データはすべてデモデータ（ハードコード）
- Flot.jsによるチャートはクライアントサイドで生成
- sparklineによるミニグラフも使用可能（include :: sparkline-js）
- 互換性維持のために残されている旧バージョン
- ユーザープロジェクトリストには中国語の人名がサンプルとして表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main_v1.html | `ruoyi-admin/src/main/resources/templates/main_v1.html` | ダッシュボードレイアウト、Flot.jsチャート |

**主要処理フロー**:
- **17-74行目**: 4つの統計iboxパネル
- **76-131行目**: 注文チャート領域
- **133-213行目**: ユーザープロジェクトリスト
- **220-334行目**: Flot.jsチャート初期化JavaScript

### プログラム呼び出し階層図

```
Browser: main_v1.html 読み込み
    │
    ├─ jQuery.ready()
    │      │
    │      └─ $.plot() - Flot.jsチャート描画
    │             │
    │             ├─ data2 (折れ線データ)
    │             │
    │             └─ data3 (棒グラフデータ)
    │
    └─ sparkline (オプション)
```

### データフロー図

```
[入力]               [処理]                    [出力]

(静的データ) ──────▶ main_v1.html ──────────▶ 画面表示
                        │
                        ├─ Flot.js (チャート)
                        │
                        └─ Bootstrap (レイアウト)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main_v1.html | `ruoyi-admin/src/main/resources/templates/main_v1.html` | テンプレート | 旧ダッシュボード画面 |
| jquery.flot.js | `ruoyi-admin/src/main/resources/static/ajax/libs/flot/jquery.flot.js` | JavaScript | チャートライブラリ |
| style.min.css | `ruoyi-admin/src/main/resources/static/css/style.min.css` | スタイル | iboxスタイル等 |
