# 画面設計書 70-サービスエラー画面

## 概要

本ドキュメントは、RuoYi後台管理システムにおけるサービスエラー画面の設計仕様を定義するものである。

### 本画面の処理概要

サービスエラー画面は、アプリケーションレベルで発生した業務例外（ServiceException等）を表示するためのエラー画面である。

**業務上の目的・背景**：アプリケーション固有のエラー（バリデーションエラー、業務ルール違反等）が発生した際、ユーザーに適切なエラーメッセージを表示することで、問題の原因を理解させ、適切な対応を促す。

**画面へのアクセス方法**：ServiceExceptionなどの業務例外がスローされた際、例外ハンドラにより自動的に表示される。エラーメッセージはサーバーサイドから動的に渡される。

**主要な操作・処理内容**：
1. エラータイトルの表示（「操作异常！」）
2. 動的エラーメッセージの表示

**画面遷移**：本画面には遷移ボタンがない。ブラウザの戻るボタンや直接URL入力での遷移が必要。

**権限による表示制御**：権限チェックは行われない。すべてのユーザーに同一の画面が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 業務例外ハンドリング |

## 画面種別

エラー（動的表示）

## URL/ルーティング

本画面は直接的なルーティングを持たず、例外ハンドラにより表示される。

| 条件 | 表示画面 |
|------|---------|
| ServiceException発生時 | error/service.html |

## 入出力項目

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| errorMessage | String | Yes | サーバーサイドから渡されるエラーメッセージ |

## 表示項目

| 項目名 | 種別 | 説明 |
|--------|------|------|
| 操作异常！ | 見出し（h3） | エラータイトル |
| errorMessage | テキスト | 動的エラーメッセージ |

## イベント仕様

本画面には操作可能なイベントは存在しない。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースへのアクセスを行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | DBアクセスなし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|---------------|------|---------|
| - | 操作异常！ | タイトル | 常時表示 |
| - | ${errorMessage} | エラー詳細 | サーバーから渡された内容を表示 |

## 例外処理

本画面自体がエラー状態を表すため、追加の例外処理は存在しない。

## 備考

- アニメーションCSS（animate.min.css）を使用してフェードインアニメーションを適用
- Thymeleafの`[[${errorMessage}]]`構文で動的にエラーメッセージを表示
- 404/500エラー画面と異なり、主ページへの遷移ボタンがない
- Bootstrap3のスタイルを使用
- エラーメッセージはサーバーサイドのGlobalExceptionHandler等から渡される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

シンプルなエラー画面のHTMLを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | service.html | `ruoyi-admin/src/main/resources/templates/error/service.html` | サービスエラー画面テンプレート |

**読解のコツ**:
- CSSインクルード（bootstrap, animate, style）
- `middle-box`クラスで中央配置
- `animated fadeInDown`でアニメーション
- `[[${errorMessage}]]`で動的メッセージ表示

**主要処理フロー**:
- **6行目**: `<title>RuoYi - 500</title>`でブラウザタイトル設定（500と同じタイトル）
- **12行目**: `.middle-box`でコンテンツを中央に配置
- **13行目**: `<h3>操作异常！</h3>`でエラータイトル表示
- **16行目**: `[[${errorMessage}]]`でサーバーからのエラーメッセージを表示

### プログラム呼び出し階層図

```
業務処理中に例外発生
    │
    └─ ServiceException / その他例外スロー
           │
           └─ GlobalExceptionHandler
                  │
                  ├─ errorMessageをモデルに設定
                  │
                  └─ ViewResolver
                         │
                         └─ error/service.html表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

業務例外 ─────────▶ Exception ───────────▶ service.html
                   Handler
                      │
                      └─ errorMessage
                            ▼
                      Thymeleaf
                            │
                            └─▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| service.html | `ruoyi-admin/src/main/resources/templates/error/service.html` | テンプレート | サービスエラー画面 |
| bootstrap.min.css | `ruoyi-admin/src/main/resources/static/css/bootstrap.min.css` | スタイル | Bootstrapフレームワーク |
| animate.min.css | `ruoyi-admin/src/main/resources/static/css/animate.min.css` | スタイル | アニメーション |
| style.min.css | `ruoyi-admin/src/main/resources/static/css/style.min.css` | スタイル | 共通スタイル |
| GlobalExceptionHandler.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java` | 例外ハンドラ | 例外を捕捉しエラーメッセージを設定 |
