# 画面設計書 8-テーマ切替

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「テーマ切替」の設計仕様を定義する。

### 本画面の処理概要

システムのUI外観（スキン/テーマ）を切り替えるための画面。モーダルウィンドウとして表示され、複数のカラーテーマから選択できる。

**業務上の目的・背景**：ユーザーごとの好みや業務環境に応じたUIカスタマイズを可能にする。目の疲れを軽減するダークテーマや、視認性を高める明るいテーマなど、複数のカラースキームを提供することで、ユーザビリティと生産性を向上させる。テーマ設定はローカルストレージに保存されるため、次回ログイン時も維持される。

**画面へのアクセス方法**：システム首頁の右上ユーザードロップダウンメニューから「切换主题」を選択すると、モーダルウィンドウとして表示される。

**主要な操作・処理内容**：
1. テーマサンプルの一覧表示
2. テーマクリックによる即時適用
3. ローカルストレージへの設定保存

**画面遷移**：
- 遷移元：システム首頁のユーザードロップダウンメニュー
- 遷移先：モーダルクローズ（親画面に戻る）

**権限による表示制御**：本画面は表示専用であり、特別な権限制御は行われない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 独立したUIカスタマイズ機能 |

## 画面種別

設定（モーダル）

## URL/ルーティング

- GET `/system/switchSkin` - テーマ切替画面の表示

## 入出力項目

本画面は入力項目を持たない（選択操作のみ）。

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 蓝（Blue） | 青色テーマ + ダークサイドバー |
| 绿（Green） | 緑色テーマ + ダークサイドバー |
| 紫（Purple） | 紫色テーマ + ダークサイドバー |
| 红（Red） | 赤色テーマ + ダークサイドバー |
| 黄（Yellow） | 黄色テーマ + ダークサイドバー |
| 蓝灰（Blue Light） | 青色テーマ + ライトサイドバー |
| 绿灰（Green Light） | 緑色テーマ + ライトサイドバー |
| 紫灰（Purple Light） | 紫色テーマ + ライトサイドバー |
| 红灰（Red Light） | 赤色テーマ + ライトサイドバー |
| 黄灰（Yellow Light） | 黄色テーマ + ライトサイドバー |
| 蓝浅（Blue Theme） | 青色テーマ + 青色サイドバー |
| 绿浅（Green Theme） | 緑色テーマ + 青色サイドバー |

## イベント仕様

### 1-テーマ選択クリック

1. テーマサンプルをクリック
2. data-skin属性からスキン情報を取得（例：skin-blue|theme-dark）
3. 親ウィンドウのbodyから既存のスキンクラスを削除
4. 新しいスキンクラスを親ウィンドウのbodyに追加
5. ローカルストレージに設定を保存（キー：skin）
6. 即座に画面の外観が変更される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

テーマ設定はローカルストレージに保存され、データベースには保存されない。

## メッセージ仕様

本画面にメッセージ表示はない。

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| ローカルストレージ使用不可 | テーマは適用されるが、次回起動時にリセットされる |

## 備考

- スキンは2つの要素で構成される：skin-{color}（ヘッダー色）とtheme-{style}（サイドバースタイル）
- 利用可能なスキンカラー：blue, green, purple, red, yellow
- 利用可能なテーマスタイル：dark（ダーク）, light（ライト）, blue（青系）
- モーダルウィンドウはlayer.jsで表示される
- サイズは530px x 386px

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | /system/switchSkinのハンドリング |

**主要処理フロー**:
1. **119-123行目**: GET /system/switchSkin - skin.htmlを返す

#### Step 2: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | skin.html | `ruoyi-admin/src/main/resources/templates/skin.html` | テーマ選択UI、JavaScript処理 |

**主要処理フロー**:
- **21-140行目**: テーマサンプルリスト（ul li）
- **151-163行目**: テーマ適用JavaScript

#### Step 3: 親画面との連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html | `ruoyi-admin/src/main/resources/templates/index.html` | テーマ適用ロジック（起動時） |

**主要処理フロー**:
- **index.html 280-297行目**: storage.get("skin")によるテーマ復元

### プログラム呼び出し階層図

```
システム首頁: switchSkin()
    │
    └─ layer.open() - skin.htmlをモーダル表示
           │
           └─ skin.html
                  │
                  ├─ $("[data-skin]").on('click')
                  │      │
                  │      ├─ parent.$("body").removeClass() - 既存スキン削除
                  │      │
                  │      ├─ parent.$("body").addClass() - 新スキン適用
                  │      │
                  │      └─ storage.set('skin') - ローカルストレージ保存
                  │
                  └─ （即座に親画面の外観が変化）
```

### データフロー図

```
[入力]               [処理]                    [出力]

クリック ──────────▶ skin.html JS ──────────▶ parent.$("body")クラス変更
                        │                          │
                        └─ localStorage ◀──────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| skin.html | `ruoyi-admin/src/main/resources/templates/skin.html` | テンプレート | テーマ選択UI |
| SysIndexController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` | コントローラー | エンドポイント |
| skins.css | `ruoyi-admin/src/main/resources/static/css/skins.css` | スタイル | 各テーマのスタイル定義 |
| common.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/common.js` | JavaScript | storageユーティリティ |
