# 画面設計書 9-ユーザー管理一覧

## 概要

本ドキュメントは、RuoYi後台管理システムにおける「ユーザー管理一覧」の設計仕様を定義する。

### 本画面の処理概要

システムユーザーの一覧表示・検索・管理を行う画面。左側に部門ツリー、右側にユーザー一覧テーブルを配置した2ペインレイアウト。ユーザーの追加・編集・削除・インポート・エクスポート・パスワードリセット・ロール割当などの機能を提供する。

**業務上の目的・背景**：組織のユーザーアカウントを一元管理するための中核機能。部門別のフィルタリング、ステータス管理、ロール割当など、ユーザー管理に必要な全機能を集約している。大量のユーザーを効率的に管理するため、ページネーション、ソート、検索機能を備える。Excelインポート/エクスポート機能により、既存システムからの移行やバックアップにも対応。

**画面へのアクセス方法**：システム首頁のサイドバーメニューから「システム管理」→「ユーザー管理」を選択。URL直接アクセスは `/system/user`。

**主要な操作・処理内容**：
1. 部門ツリーでの組織フィルタリング
2. 検索条件（ログイン名、手機番号、状態、作成時間）での絞り込み
3. ユーザー一覧の表示・ソート・ページネーション
4. 新規ユーザーの追加
5. 既存ユーザーの編集・削除
6. ユーザー状態（有効/無効）の切替
7. パスワードリセット
8. ロール割当
9. Excel形式でのインポート/エクスポート

**画面遷移**：
- 遷移元：システム首頁のメニュー
- 遷移先：ユーザー新規登録、ユーザー編集、ユーザー詳細表示、パスワードリセット、ロール割当、部門管理

**権限による表示制御**：`system:user:view` 権限が必要。各操作ボタンは対応する権限（add, edit, remove, import, export, resetPwd）により表示/非表示が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ユーザー管理 | 主機能 | ユーザー一覧の検索、表示、ステータス変更処理 |
| 4 | 部門管理 | 補助機能 | 部門ツリーによるフィルタリング処理 |
| 23 | ファイルアップロード | 補助機能 | ユーザーデータのExcelインポート処理 |
| 24 | ファイルダウンロード | 補助機能 | ユーザーデータのExcelエクスポート処理 |

## 画面種別

一覧

## URL/ルーティング

- GET `/system/user` - ユーザー管理一覧画面の表示
- POST `/system/user/list` - ユーザー一覧データ取得（Ajax）
- POST `/system/user/export` - ユーザーデータエクスポート
- POST `/system/user/importData` - ユーザーデータインポート
- GET `/system/user/importTemplate` - インポートテンプレートダウンロード
- POST `/system/user/remove` - ユーザー削除
- POST `/system/user/changeStatus` - ユーザー状態変更

## 入出力項目

### 検索条件

| 項目名 | 物理名 | 型 | 必須 | 入出力 | 説明 |
|--------|--------|-----|------|--------|------|
| 部門ID | deptId | Long | - | 入力 | ツリー選択 |
| 親部門ID | parentId | Long | - | 入力 | ツリー選択 |
| ログイン名称 | loginName | String | - | 入力 | 部分一致検索 |
| 手機番号 | phonenumber | String | - | 入力 | 部分一致検索 |
| ユーザー状態 | status | String | - | 入力 | 0:正常, 1:停止 |
| 開始時間 | params[beginTime] | String | - | 入力 | 作成日時範囲 |
| 終了時間 | params[endTime] | String | - | 入力 | 作成日時範囲 |

## 表示項目

### ユーザー一覧テーブル

| 項目名 | 物理名 | 説明 |
|--------|--------|------|
| チェックボックス | - | 複数選択用 |
| ユーザーID | userId | 主キー |
| ログイン名称 | loginName | リンク（詳細画面へ） |
| ユーザー名称 | userName | 表示名 |
| 部門 | dept.deptName | 所属部門名 |
| メール | email | 非表示（設定可） |
| 手機 | phonenumber | 携帯電話番号 |
| ユーザー状態 | status | トグルスイッチ表示 |
| 作成時間 | createTime | ソート可能 |
| 操作 | - | 編集・削除・その他操作 |

## イベント仕様

### 1-検索ボタン押下

1. 検索フォームの入力値を取得
2. 部門ツリーで選択された部門IDを含める
3. AjaxでPOST `/system/user/list` にリクエスト送信
4. 取得したデータでテーブルを更新

### 2-重置（リセット）ボタン押下

1. 日付ピッカーをリセット
2. 検索フォームをリセット
3. 部門ID/親部門IDをクリア
4. ツリーの選択状態をクリア
5. 検索を実行

### 3-新規追加ボタン押下

1. `/system/user/add` を新しいタブで開く

### 4-編集ボタン押下

1. 選択されたユーザーIDを取得
2. `/system/user/edit/{userId}` を新しいタブで開く

### 5-削除ボタン押下

1. 選択されたユーザーIDを取得
2. 確認ダイアログを表示
3. 確認後、POST `/system/user/remove` にリクエスト送信
4. テーブルを再読み込み

### 6-状態トグルスイッチ切替

1. ユーザーIDと新しい状態を取得
2. 確認ダイアログを表示
3. 確認後、POST `/system/user/changeStatus` にリクエスト送信
4. 状態変更成功時、トグル表示を更新

### 7-パスワードリセット（更多操作）

1. `/system/user/resetPwd/{userId}` をモーダルで開く

### 8-ロール割当（更多操作）

1. `/system/user/authRole/{userId}` を新しいタブで開く

### 9-インポートボタン押下

1. インポートダイアログをモーダル表示
2. ファイル選択とオプション設定
3. POST `/system/user/importData` でアップロード

### 10-エクスポートボタン押下

1. 現在の検索条件を取得
2. POST `/system/user/export` でExcelダウンロード

### 11-部門ツリークリック

1. 選択された部門のIDを取得
2. deptId, parentIdを検索条件にセット
3. 検索を実行

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索 | sys_user, sys_dept | SELECT | ユーザー一覧取得 |
| 削除 | sys_user | UPDATE | del_flag更新（論理削除） |
| 状態変更 | sys_user | UPDATE | status更新 |
| インポート | sys_user | INSERT/UPDATE | 一括登録/更新 |

### テーブル別更新項目詳細

#### sys_user（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | del_flag | '2' | 論理削除 |
| UPDATE | update_by | ログインユーザー名 | - |
| UPDATE | update_time | 現在日時 | - |

#### sys_user（状態変更時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status | '0' or '1' | 0:正常, 1:停止 |
| UPDATE | update_by | ログインユーザー名 | - |
| UPDATE | update_time | 現在日時 | - |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 確認 | 确认要停用用户吗？ | 状態を停止に変更時 |
| 確認 | 确认要启用用户吗？ | 状態を正常に変更時 |
| 情報 | 仅允许导入"xls"或"xlsx"格式文件！ | インポートダイアログ表示時 |
| エラー | 当前用户不能删除 | 自分自身を削除しようとした場合 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 権限不足 | 対応するボタン/操作が非表示またはエラー |
| 自分自身の削除 | エラーメッセージ「当前用户不能删除」を表示 |
| インポートファイル形式エラー | エラーメッセージを表示 |

## 備考

- ユーザーID=1（admin）に対する操作は制限される
- 部門ツリーはzTree.jsで実装
- テーブルはBootstrap Tableで実装
- 画面幅が狭い場合、部門ツリーペインは自動的に折りたたまれる
- ソートは作成時間の降順がデフォルト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ユーザーエンティティ、dept関連 |
| 1-2 | SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | 部門エンティティ |
| 1-3 | TableDataInfo.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/page/TableDataInfo.java` | ページネーション応答 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | 全エンドポイント |

**主要処理フロー**:
1. **64-69行目**: GET / - 一覧画面表示
2. **71-79行目**: POST /list - 一覧データ取得
3. **276-287行目**: POST /remove - 削除処理
4. **319-331行目**: POST /changeStatus - 状態変更

#### Step 3: フロントエンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | user.html | `ruoyi-admin/src/main/resources/templates/system/user/user.html` | 画面レイアウト、テーブル設定 |

**主要処理フロー**:
- **116-194行目**: queryUserList() - テーブル初期化
- **196-211行目**: queryDeptTree() - 部門ツリー初期化

### プログラム呼び出し階層図

```
user.html
    │
    ├─ queryUserList() - テーブル初期化
    │      │
    │      └─ $.table.init() - Bootstrap Table
    │             │
    │             └─ Ajax POST /system/user/list
    │                    │
    │                    └─ SysUserController.list()
    │                           │
    │                           └─ userService.selectUserList()
    │
    └─ queryDeptTree() - ツリー初期化
           │
           └─ $.tree.init()
                  │
                  └─ Ajax GET /system/user/deptTreeData
                         │
                         └─ SysUserController.deptTreeData()
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ──────────▶ SysUserController ──────▶ TableDataInfo
                        │                          │
部門選択 ──────────────┤                          │
                        │                          │
                        └─▶ ISysUserService        └──▶ user.html
                               │                        (Bootstrap Table)
                               └─▶ SysUserMapper
                                      │
                                      └─▶ sys_user, sys_dept
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| user.html | `ruoyi-admin/src/main/resources/templates/system/user/user.html` | テンプレート | 一覧画面 |
| SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | コントローラー | エンドポイント |
| ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | サービス | ビジネスロジック |
| SysUserMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` | MyBatis | SQL定義 |
| ry-ui.js | `ruoyi-admin/src/main/resources/static/ruoyi/js/ry-ui.js` | JavaScript | $.table, $.tree等 |
