---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **sys_user_online テーブルへのINSERT**：ログイン成功時の処理として記載したが、詳細なコード確認が必要
  2. **アカウントロック時のメッセージ**：Shiro設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/login.html` - ログイン画面テンプレート
- E-02: `ruoyi-admin/src/main/resources/static/ruoyi/login.js` - ログイン処理JavaScript
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java` - ログインコントローラー
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面のURLは `/login` | E-03 (40行目 @GetMapping("/login")) | ○ |
| C-02 | POST `/login` でログイン認証処理 | E-03 (55行目 @PostMapping("/login")) | ○ |
| C-03 | ユーザー名入力フィールドが存在 | E-01 (47行目 input name="username") | ○ |
| C-04 | パスワード入力フィールドが存在 | E-01 (48行目 input name="password") | ○ |
| C-05 | 認証コード入力フィールドが存在（条件付き） | E-01 (49-58行目 th:if captchaEnabled) | ○ |
| C-06 | Remember Me機能が存在（条件付き） | E-01 (59-61行目 th:if isRemembered) | ○ |
| C-07 | ログイン成功時は `/index` にリダイレクト | E-02 (34行目 location.href = ctx + 'index') | ○ |
| C-08 | 新規登録リンクの表示制御 | E-01 (40行目 th:if isAllowRegister), E-03 (51行目) | ○ |
| C-09 | キャプチャ画像クリックで更新 | E-02 (5-8行目 .imgcode click) | ○ |
| C-10 | jQuery Validateによる入力検証 | E-02 (47-68行目 validateRule) | ○ |
| C-11 | 機能No.19「ログイン」が主機能 | E-04 (2行目) | ○ |
| C-12 | 機能No.21「キャプチャ生成」が補助機能 | E-04 (3行目) | ○ |
| C-13 | 機能No.20「ユーザー登録」が遷移先機能 | E-04 (4行目) | ○ |
| C-14 | Apache Shiroによる認証処理 | E-03 (59-63行目 SecurityUtils, subject.login) | ○ |
| C-15 | rememberMe設定は shiro.rememberMe.enabled | E-03 (34-35行目 @Value) | ○ |
| C-16 | 登録可否設定は sys.account.registerUser | E-03 (51行目 configService.getKey) | ○ |
| C-17 | 認証失敗時は「用户或密码错误」 | E-03 (68行目 msg = "用户或密码错误") | ○ |
| C-18 | iframe内セッション切れ時のトップリダイレクト | E-01 (19-21行目 window.top.location) | ○ |
| C-19 | キャプチャ最大長5文字 | E-01 (51行目 maxlength="5") | ○ |
| C-20 | kickout時の警告メッセージ | E-02 (71-90行目 validateKickout) | ○ |
| C-21 | 認証画面のカテゴリは「認証」 | E-05 (2行目) | ○ |
| C-22 | テンプレートファイルパスはlogin.html | E-05 (2行目) | ○ |
| C-23 | 画面遷移：ログイン→システム首頁 | E-06 (49行目 Login --> Index) | ○ |
| C-24 | 画面遷移：ログイン→新規登録 | E-06 (50行目 Login --> Register) | ○ |
| C-25 | X-UA-Compatible: IE=edgeの設定 | E-01 (16行目 meta http-equiv) | ○ |
| C-26 | 360ブラウザ用webkit指定 | E-01 (14行目 meta name="renderer" content="webkit") | ○ |
| C-27 | sys_logininforへのINSERT（ログイン履歴） | **根拠なし** | △ |
| C-28 | sys_user_onlineへのINSERT | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- sys_logininfor, sys_user_onlineへのDB更新処理は、Shiroのイベントリスナーまたはサービス層で実装されていると推測されるが、直接のコード参照なし
  - 候補：`SysLoginService.java` / `LoginLogininforAspect.java` / `SessionManager`設定

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面表示・入力項目・イベント仕様は全てソースコードから確認済み
- **1: 中リスク** - データベース更新仕様の一部（ログ記録）は間接的な推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] ログイン成功時のsys_logininfor INSERT処理のコード箇所を確認
- [ ] sys_user_onlineへの登録処理の実装箇所を確認
- [ ] アカウントロック機能の詳細仕様を確認（Shiro設定）
