---
generated_at: 2026-01-08 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-ユーザー新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/add.html` - ユーザー新規登録テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーコントローラー
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET /system/user/add で画面表示 | E-02 (117行目 @GetMapping("/add")) | ○ |
| C-02 | POST /system/user/add で保存 | E-02 (130行目 @PostMapping("/add")) | ○ |
| C-03 | system:user:add権限が必要 | E-02 (128行目 @RequiresPermissions("system:user:add")) | ○ |
| C-04 | userNameは必須、最大30文字 | E-01 (17行目 required, maxlength="30") | ○ |
| C-05 | loginNameは必須、2-20文字 | E-01 (62行目 required, 155-157行目 minlength:2, maxlength:20) | ○ |
| C-06 | passwordは必須、5-20文字 | E-01 (71行目 required, 169-172行目 minlength:5, maxlength:20) | ○ |
| C-07 | 初期パスワードは設定から取得 | E-01 (71行目 th:value="${@config.getKey('sys.user.initPassword')}") | ○ |
| C-08 | loginName重複チェックはremote | E-01 (158-167行目 remote: url: prefix + "/checkLoginNameUnique") | ○ |
| C-09 | email重複チェックはremote | E-01 (176-185行目 remote: url: prefix + "/checkEmailUnique") | ○ |
| C-10 | phonenumber重複チェックはremote | E-01 (189-198行目 remote: url: prefix + "/checkPhoneUnique") | ○ |
| C-11 | 重複時メッセージ「用户已经存在」 | E-01 (203行目 remote: "用户已经存在") | ○ |
| C-12 | 重複時メッセージ「Email已经存在」 | E-01 (206行目 remote: "Email已经存在") | ○ |
| C-13 | 重複時メッセージ「手机号码已经存在」 | E-01 (209行目 remote: "手机号码已经存在") | ○ |
| C-14 | 性別は辞書sys_user_sexから取得 | E-01 (85行目 th:with="type=${@dict.getType('sys_user_sex')}") | ○ |
| C-15 | 状態はトグルスイッチ | E-01 (95-98行目 toggle-switch) | ○ |
| C-16 | 岗位はSelect2マルチセレクト | E-01 (108行目 select2-multiple, 259行目 $('#post').select2) | ○ |
| C-17 | ロールはチェックボックス | E-01 (120-122行目 type="checkbox") | ○ |
| C-18 | 管理者ロールは除外 | E-02 (120行目 filter(r -> !r.isAdmin())) | ○ |
| C-19 | パスワードは暗号化される | E-02 (148-149行目 setSalt, encryptPassword) | ○ |
| C-20 | 部門選択はモーダルツリー | E-01 (231-248行目 selectDeptTree, $.modal.openOptions) | ○ |
| C-21 | メインカテゴリは「システム管理」 | E-03 (11行目) | ○ |
| C-22 | 機能No.1「ユーザー管理」が主機能 | E-04 (16行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] フォームバリデーションの動作確認
- [ ] ログイン名・メール・電話番号の重複チェック動作確認
- [ ] 部門選択ダイアログの動作確認
- [ ] 岗位・ロールの選択動作確認
- [ ] パスワード暗号化の動作確認
- [ ] ユーザー登録後のデータ整合性確認
