---
generated_at: 2026-01-08 14:30:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：11-ユーザー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **バリデーションルール詳細**：設定ファイルからの動的バリデーションルール確認が必要
  2. **Select2プラグイン設定**：フロントエンドライブラリの詳細仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/edit.html` - 編集画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーコントローラー（159-212行目）
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` - ユーザーエンティティ
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` - ユーザーサービスインターフェース
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` - ユーザーMapperXML（185-206行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（20-23行目）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（12行目）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（89-117行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.11はユーザー編集画面である | E-07 | ○ |
| C-02 | URLパターンは/system/user/edit/{userId} | E-02 (159-168行) | ○ |
| C-03 | system:user:edit権限が必要 | E-02 (158行 @RequiresPermissions) | ○ |
| C-04 | ログイン名は読み取り専用 | E-01 (63行 readonly="true") | ○ |
| C-05 | 岗位は複数選択可能 | E-01 (84-86行 multiple属性) | ○ |
| C-06 | ロールはチェックボックスで複数選択 | E-01 (106-108行) | ○ |
| C-07 | 部門選択ボタンでダイアログ起動 | E-01 (27行 onclick="selectDeptTree()") | ○ |
| C-08 | メール重複チェックAPI存在 | E-02 (309-317行) | ○ |
| C-09 | 電話番号重複チェックAPI存在 | E-02 (299-307行) | ○ |
| C-10 | sys_userテーブルを更新 | E-05 (185-206行) | ○ |
| C-11 | sys_user_roleテーブルを更新 | E-02 (210行 updateUser呼び出し), E-04 (118行) | ○ |
| C-12 | ユーザー情報取得にselectUserById使用 | E-02 (164行) | ○ |
| C-13 | ロール取得にselectRolesByUserId使用 | E-02 (163行) | ○ |
| C-14 | 岗位取得にselectPostsByUserId使用 | E-02 (166行) | ○ |
| C-15 | 管理者ユーザーのロールフィルタリング | E-02 (165行 isAdmin判定) | ○ |
| C-16 | checkUserAllowedで操作制限チェック | E-02 (193行) | ○ |
| C-17 | checkUserDataScopeでデータ権限チェック | E-02 (194行) | ○ |
| C-18 | フォームバリデーションにjQueryValidate使用 | E-01 (137-182行) | ○ |
| C-19 | Select2プラグインで岗位選択実装 | E-01 (224-228行) | ○ |
| C-20 | statusはチェックボックスで0/1変換 | E-01 (71-74行, 187行) | ○ |
| C-21 | 関連機能No.1ユーザー管理が主機能 | E-06 (20-23行) | ○ |
| C-22 | 関連機能No.2ロール管理が補助機能 | E-06 (21行) | ○ |
| C-23 | 関連機能No.5役職管理が補助機能 | E-06 (22行) | ○ |
| C-24 | 関連機能No.4部門管理が補助機能 | E-06 (23行) | ○ |
| C-25 | 画面遷移：一覧から編集へ | E-08 (104-107行) | ○ |
| C-26 | 備考は500文字以内 | E-01 (119行 maxlength="500") | ○ |
| C-27 | ユーザー名は30文字以内 | E-01 (18行 maxlength="30") | ○ |
| C-28 | 電話番号は11桁以内 | E-01 (40行 maxlength="11") | ○ |
| C-29 | メールは50文字以内 | E-01 (51行 maxlength="50") | ○ |
| C-30 | update_timeにsysdate()設定 | E-05 (203行) | ○ |
| C-31 | バリデーションルール詳細（パスワード複雑性等） | **根拠なし** | △ |
| C-32 | Select2の詳細オプション設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- バリデーションルールの詳細設定：システム設定からの動的ルール読み込みに関する仕様は、設定ファイルやconfigテーブルの確認が必要
  - 候補：sys_configテーブル / application.yml / フロントエンドライブラリ設定
- Select2プラグインの詳細オプション：プラグインの初期化オプションの完全な仕様はJavaScriptコードベースの確認が必要

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 大部分の主張はソースコードで直接確認可能
- 1 (中リスク): 動的バリデーションルール - 設定値次第で動作が変わる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 編集画面のフォーム項目がSysUserエンティティと一致しているか確認
- [ ] sys_user_role、sys_user_postテーブルの更新ロジックが正しく記載されているか確認
- [ ] 権限チェック（system:user:edit）の説明が実装と一致しているか確認
- [ ] データ権限チェックの説明が適切か確認
- [ ] 画面遷移の説明が画面遷移図と一致しているか確認
