---
generated_at: 2026-01-08 14:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-ユーザー詳細表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/view.html` - 詳細表示画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーコントローラー（173-181行目）
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` - ユーザーエンティティ
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` - ユーザーサービスインターフェース（207-215行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（24行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（13行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.12はユーザー詳細表示画面である | E-06 | ○ |
| C-02 | URLパターンは/system/user/view/{userId} | E-02 (174行) | ○ |
| C-03 | system:user:list権限が必要 | E-02 (173行 @RequiresPermissions) | ○ |
| C-04 | 本画面は参照専用（編集機能なし） | E-01 (入力フォームなし確認) | ○ |
| C-05 | ユーザー名称を表示 | E-01 (15行 th:text="*{userName}") | ○ |
| C-06 | 部門名を表示 | E-01 (23行 th:text="*{dept.deptName}") | ○ |
| C-07 | 電話番号を表示 | E-01 (33行 th:text="*{phonenumber}") | ○ |
| C-08 | メールを表示 | E-01 (41行 th:text="*{email}") | ○ |
| C-09 | ログイン名を表示 | E-01 (51行 th:text="*{loginName}") | ○ |
| C-10 | ステータスを正常/停用で表示 | E-01 (59行 status == '0' ? '正常' : '停用') | ○ |
| C-11 | 岗位グループを表示（无岗位対応） | E-01 (69行 defaultString) | ○ |
| C-12 | 性別を辞書変換で表示 | E-01 (77行 @dict.getLabel) | ○ |
| C-13 | ロールグループを表示（无角色対応） | E-01 (87行 defaultString) | ○ |
| C-14 | 作成者を表示 | E-01 (98行 th:text="*{createBy}") | ○ |
| C-15 | 作成時間を表示 | E-01 (106行 #dates.format) | ○ |
| C-16 | 更新者を表示 | E-01 (116行 th:text="*{updateBy}") | ○ |
| C-17 | 更新時間を表示 | E-01 (124行 #dates.format) | ○ |
| C-18 | 最終ログインIPを表示 | E-01 (134行 th:text="*{loginIp}") | ○ |
| C-19 | 最終ログイン時間を表示 | E-01 (142行 #dates.format) | ○ |
| C-20 | 備考を表示 | E-01 (152行 th:text="*{remark}") | ○ |
| C-21 | selectUserRoleGroupでロール名取得 | E-02 (179行), E-04 (207行) | ○ |
| C-22 | selectUserPostGroupで岗位名取得 | E-02 (180行), E-04 (215行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目がview.htmlテンプレートと一致しているか確認
- [ ] データ権限チェック（checkUserDataScope）の説明が適切か確認
- [ ] 日時フォーマット（yyyy-MM-dd HH:mm:ss）が正しく記載されているか確認
