---
generated_at: 2026-01-08 14:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ユーザーパスワードリセット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/resetPwd.html` - パスワードリセット画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーコントローラー（214-242行目）
- E-03: `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` - ユーザーMapperXML（173-175行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（25行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（14行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.13はユーザーパスワードリセット画面である | E-05 | ○ |
| C-02 | URLパターンは/system/user/resetPwd/{userId} | E-02 (215行) | ○ |
| C-03 | system:user:resetPwd権限が必要 | E-02 (214行 @RequiresPermissions) | ○ |
| C-04 | ログイン名は読み取り専用 | E-01 (13行 readonly="true") | ○ |
| C-05 | 初期パスワードはsys.user.initPasswordから取得 | E-01 (20行 @config.getKey) | ○ |
| C-06 | パスワードは5-20文字のバリデーション | E-01 (34-36行 minlength/maxlength) | ○ |
| C-07 | specialSignルールでチェック | E-01 (37行) | ○ |
| C-08 | マウス押下でパスワード表示 | E-01 (22行 onmousedown) | ○ |
| C-09 | マウス離すとパスワード非表示 | E-01 (23行 onmouseup) | ○ |
| C-10 | $.operate.saveで保存処理 | E-01 (45行) | ○ |
| C-11 | checkUserAllowedでadmin保護 | E-02 (229行) | ○ |
| C-12 | checkUserDataScopeで権限チェック | E-02 (230行) | ○ |
| C-13 | randomSaltでソルト生成 | E-02 (231行) | ○ |
| C-14 | encryptPasswordで暗号化 | E-02 (232行) | ○ |
| C-15 | resetUserPwdでDB更新 | E-02 (233行) | ○ |
| C-16 | password, salt, pwd_update_dateを更新 | E-03 (174行) | ○ |
| C-17 | update_timeにsysdate()設定 | E-03 (174行) | ○ |
| C-18 | 自身のパスワードリセット時セッション更新 | E-02 (235-238行) | ○ |
| C-19 | 関連機能No.1ユーザー管理が主機能 | E-04 (25行) | ○ |
| C-20 | hidden項目でuserIdを保持 | E-01 (9行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] パスワード暗号化処理（encryptPassword）の説明が適切か確認
- [ ] 初期パスワード取得（sys.user.initPassword）の説明が正しいか確認
- [ ] admin保護処理（checkUserAllowed）の説明が実装と一致しているか確認
- [ ] バリデーションルール（5-20文字、specialSign）が正しく記載されているか確認
