---
generated_at: 2026-01-08 14:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-ユーザーロール割当

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/authRole.html` - ロール割当画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーコントローラー（244-274行目）
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java` - ロールエンティティ
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（26-27行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（15行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.14はユーザーロール割当画面である | E-05 | ○ |
| C-02 | URLパターンは/system/user/authRole/{userId} | E-02 (248行) | ○ |
| C-03 | system:user:edit権限が必要 | E-02 (247行 @RequiresPermissions) | ○ |
| C-04 | タブ形式で表示 | E-02 (257行 "authRole"を返却→タブ表示) | ○ |
| C-05 | ユーザー名称とログイン名を表示 | E-01 (14-27行) | ○ |
| C-06 | Bootstrap Tableでロール一覧表示 | E-01 (52行 $.table.init) | ○ |
| C-07 | sidePagination: "client"でクライアントサイド | E-01 (55行) | ○ |
| C-08 | roleSortでソート | E-01 (56行 sortName) | ○ |
| C-09 | showSearch/showRefresh等は非表示 | E-01 (57-60行) | ○ |
| C-10 | clickToSelect: trueで行クリック選択 | E-01 (61行) | ○ |
| C-11 | maintainSelected: trueで選択維持 | E-01 (62行) | ○ |
| C-12 | flagでチェック状態判定 | E-01 (68行) | ○ |
| C-13 | status=1で無効化（disabled） | E-01 (66行) | ○ |
| C-14 | roleId, roleName, roleKey, createTimeを表示 | E-01 (74-97行) | ○ |
| C-15 | $.operate.saveTabで保存 | E-01 (111行) | ○ |
| C-16 | roleIds.join()でカンマ区切り送信 | E-01 (111行) | ○ |
| C-17 | 管理者以外は管理者ロール非表示 | E-02 (256行 isAdmin判定) | ○ |
| C-18 | insertAuthRoleでロール割当保存 | E-02 (265行) | ○ |
| C-19 | userService.insertUserAuth呼び出し | E-02 (271行) | ○ |
| C-20 | AuthorizationUtils.clearAllCachedAuthorizationInfo | E-02 (272行) | ○ |
| C-21 | 関連機能No.1ユーザー管理が主機能 | E-04 (26行) | ○ |
| C-22 | 関連機能No.2ロール管理がAPI連携 | E-04 (27行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Bootstrap Tableの設定（sidePagination, sortName等）が正しく記載されているか確認
- [ ] チェックボックスのflag/status判定ロジックが正しいか確認
- [ ] 管理者ロールのフィルタリングロジックが正しく説明されているか確認
- [ ] insertUserAuthの処理内容（削除→登録）が正しいか確認
