---
generated_at: 2026-01-08 14:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-部門ツリー選択

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/deptTree.html` - 部門ツリー選択画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーコントローラー（336-356行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（28行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（16行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.15は部門ツリー選択画面である | E-04 | ○ |
| C-02 | URLパターンは/system/user/selectDeptTree/{deptId} | E-02 (351行) | ○ |
| C-03 | system:user:list権限が必要 | E-02 (350行 @RequiresPermissions) | ○ |
| C-04 | モーダルダイアログ形式 | E-01 (body class="hold-transition box box-main") | ○ |
| C-05 | hidden項目でtreeId/treeNameを保持 | E-01 (12-13行) | ○ |
| C-06 | zTree初期化 | E-01 (34-40行 $.tree.init) | ○ |
| C-07 | expandLevel: 2で初期展開 | E-01 (37行) | ○ |
| C-08 | zOnClickでノード選択処理 | E-01 (38行, 43-48行) | ○ |
| C-09 | 検索機能（$.tree.searchNode） | E-01 (20行 onclick) | ○ |
| C-10 | 展開機能（$.tree.expand） | E-01 (23行 onclick) | ○ |
| C-11 | 折りたたみ機能（$.tree.collapse） | E-01 (24行 onclick) | ○ |
| C-12 | 検索表示切替（$.tree.toggleSearch） | E-01 (14行 onclick) | ○ |
| C-13 | Ajax: /system/user/deptTreeData | E-01 (34行 url) | ○ |
| C-14 | deptTreeDataでZtreeリスト返却 | E-02 (337-343行) | ○ |
| C-15 | deptService.selectDeptTree呼び出し | E-02 (341行) | ○ |
| C-16 | selectDeptByIdで現在部門取得 | E-02 (354行) | ○ |
| C-17 | 関連機能No.4部門管理が主機能 | E-03 (28行) | ○ |
| C-18 | キーワード検索入力欄（maxlength=50） | E-01 (19行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] zTree初期化設定（expandLevel等）が正しく記載されているか確認
- [ ] 検索・展開・折りたたみ機能の説明が実装と一致しているか確認
- [ ] hidden項目によるデータ受け渡しの説明が正しいか確認
