---
generated_at: 2026-01-08 14:55:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-プロフィール画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/profile/profile.html` - プロフィール画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java` - プロフィールコントローラー
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（29-30行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（17行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.16はプロフィール画面である | E-04 | ○ |
| C-02 | URLパターンは/system/user/profile | E-02 (50行) | ○ |
| C-03 | 2カラムレイアウト（左:資料表示、右:タブ編集） | E-01 (12行 col-sm-3, 48行 col-sm-9) | ○ |
| C-04 | アバター表示とクリック起動 | E-01 (19行 onclick="avatar()") | ○ |
| C-05 | ログイン名、電話、部門、メール、作成日表示 | E-01 (22-42行) | ○ |
| C-06 | タブ切替（基本資料/修改密码） | E-01 (55-58行) | ○ |
| C-07 | ユーザー名の編集 | E-01 (68行) | ○ |
| C-08 | 電話番号の編集 | E-01 (74行) | ○ |
| C-09 | メールの編集 | E-01 (80行) | ○ |
| C-10 | 性別のラジオボタン選択 | E-01 (86-93行) | ○ |
| C-11 | 旧パスワード入力欄 | E-01 (111行) | ○ |
| C-12 | 新パスワード入力欄（ポリシー表示） | E-01 (117行, 118-127行) | ○ |
| C-13 | 確認パスワード入力欄 | E-01 (133行) | ○ |
| C-14 | avatar()でモーダル起動 | E-01 (155-177行) | ○ |
| C-15 | jQueryValidateで基本資料バリデーション | E-01 (180-235行) | ○ |
| C-16 | checkEmailUniqueでメール重複確認 | E-01 (189-200行 remote) | ○ |
| C-17 | checkPhoneUniqueで電話重複確認 | E-01 (206-217行 remote) | ○ |
| C-18 | submitUserInfo()で基本資料保存 | E-01 (237-241行) | ○ |
| C-19 | /system/user/profile/updateへPOST | E-01 (239行) | ○ |
| C-20 | jQueryValidateでパスワードバリデーション | E-01 (244-288行) | ○ |
| C-21 | checkPasswordで旧パスワード確認 | E-01 (250-258行, E-02 60-66行) | ○ |
| C-22 | newPassword 6-20文字制限 | E-01 (261-264行) | ○ |
| C-23 | confirmPassword一致チェック | E-01 (266-268行) | ○ |
| C-24 | submitChangPassword()でパスワード保存 | E-01 (290-296行) | ○ |
| C-25 | checkpwd()でポリシーチェック | E-01 (293行) | ○ |
| C-26 | 関連機能No.22プロファイル管理が主機能 | E-03 (29行) | ○ |
| C-27 | 関連機能No.1ユーザー管理が補助機能 | E-03 (30行) | ○ |
| C-28 | パスワードポリシー表示（chrtype） | E-01 (118-127行 @config.getKey) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 2カラムレイアウトの説明が正しいか確認
- [ ] タブ切替（基本資料/修改密码）の構造が正しく記載されているか確認
- [ ] バリデーションルール（メール重複、電話重複、パスワードポリシー）が正しいか確認
- [ ] パスワードポリシー（chrtype設定）の説明が正しいか確認
