---
generated_at: 2026-01-08 15:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-パスワード変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/profile/resetPwd.html` - パスワード変更画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java` - プロフィールコントローラー（60-98行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（19行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.18はパスワード変更画面である | E-04 | ○ |
| C-02 | URLパターンは/system/user/profile/resetPwd | E-02 (68行, 77行) | ○ |
| C-03 | hidden項目でuserIdを保持 | E-01 (9行) | ○ |
| C-04 | ログイン名は読み取り専用 | E-01 (13行 readonly="true") | ○ |
| C-05 | 旧パスワード必須入力 | E-01 (52-53行 required:true) | ○ |
| C-06 | 旧パスワードのリモート検証 | E-01 (54-63行 remote) | ○ |
| C-07 | checkPasswordでパスワード検証 | E-02 (60-66行) | ○ |
| C-08 | passwordService.matchesで検証 | E-02 (65行) | ○ |
| C-09 | 新パスワード5-20文字制限 | E-01 (66-68行 minlength:5, maxlength:20) | ○ |
| C-10 | specialSign（ポリシーチェック） | E-01 (69行) | ○ |
| C-11 | 確認パスワードequalTo検証 | E-01 (71-73行) | ○ |
| C-12 | chrtype=0で制限なし | E-01 (27行 th:if="${chrtype != '0'}") | ○ |
| C-13 | chrtype=1で数字のみ | E-01 (29行) | ○ |
| C-14 | chrtype=2で英字のみ | E-01 (30行) | ○ |
| C-15 | chrtype=3で英数字必須 | E-01 (31行) | ○ |
| C-16 | chrtype=4で英数字+特殊文字 | E-01 (32行) | ○ |
| C-17 | checkpwd()でポリシーチェック | E-01 (98行) | ○ |
| C-18 | サーバー側で旧パスワード再検証 | E-02 (82-85行) | ○ |
| C-19 | 新旧パスワード同一チェック | E-02 (86-89行) | ○ |
| C-20 | ShiroUtils.randomSalt()でsalt生成 | E-02 (90行) | ○ |
| C-21 | encryptPasswordで暗号化 | E-02 (91行) | ○ |
| C-22 | resetUserPwdでDB更新 | E-02 (92行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 旧パスワードのリモート検証処理が正しく記載されているか確認
- [ ] パスワードポリシー（chrtype 0-4）の説明が正しいか確認
- [ ] サーバー側の二重検証（旧パスワード、新旧同一）が正しく記載されているか確認
- [ ] パスワード暗号化フロー（salt + MD5）の説明が正しいか確認
